/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.graphlisteners;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.callgraph.StapGraph;
import org.eclipse.swt.widgets.Display;

public class Projectionist
extends Job {
    private StapGraph graph;
    private int frame_time = 2000;
    private boolean pause;
    private boolean busy;

    public Projectionist(String name, StapGraph graph, int time) {
        super(name);
        this.graph = graph;
        this.frame_time = time;
        this.pause = false;
        this.busy = false;
    }

    public IStatus run(IProgressMonitor monitor) {
        long snapshot = System.currentTimeMillis();
        while (true) {
            if (this.busy) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            if (this.pause) {
                return Status.OK_STATUS;
            }
            if (System.currentTimeMillis() - snapshot >= (long)this.frame_time) {
                snapshot = System.currentTimeMillis();
                this.busy = true;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Projectionist.this.graph.drawNextNode();
                        Projectionist.this.busy = false;
                    }
                });
            } else {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (monitor.isCanceled()) break;
        }
        return Status.CANCEL_STATUS;
    }

    public void pause() {
        this.pause = true;
    }
}

