/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.rpmstubby.AbstractGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.model.PomModel;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StubbyPomGenerator
extends AbstractGenerator {
    private PomModel model;

    public StubbyPomGenerator(IFile pomFile) {
        this.parse(pomFile);
        this.specfileName = String.valueOf(this.model.getPackageName().toLowerCase()) + ".spec";
        this.projectName = pomFile.getProject().getName();
    }

    private void parse(IFile pomFile) {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
            Document docroot = docbuilder.parse(pomFile.getContents());
            this.model = new PomModel(docroot);
        }
        catch (ParserConfigurationException e) {
            StubbyLog.logError(e);
        }
        catch (SAXException e) {
            StubbyLog.logError(e);
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
        catch (CoreException e) {
            StubbyLog.logError(e);
        }
    }

    public String generateSpecfile() {
        StringBuilder buffer = new StringBuilder();
        String packageName = this.model.getPackageName();
        buffer.append("Name:           " + packageName.toLowerCase() + "\n");
        buffer.append("Version:        " + this.model.getVersion() + "\n");
        buffer.append("Release:        1%{?dist}\n");
        buffer.append("Summary:        " + this.model.getSummary() + "\n\n");
        buffer.append("Group:          Development/Libraries\n");
        buffer.append("License:        " + this.model.getLicense() + "\n");
        buffer.append("URL:            " + this.model.getURL() + "\n");
        buffer.append("Source0:        #FIXME\n");
        buffer.append("BuildArch: noarch\n\n");
        this.generateRequires(buffer);
        buffer.append("\n%description\n" + this.model.getDescription() + "\n\n");
        this.generateJavadocSubpackage(buffer);
        this.generatePrepSection(buffer);
        this.generateBuildSection(buffer);
        this.generateInstallSection(buffer);
        this.generateFilesSections(buffer);
        this.generateChangelog(buffer);
        return buffer.toString();
    }

    private void generateRequires(StringBuilder buffer) {
        for (Map.Entry<String, String> entry : this.model.getDependencies().entrySet()) {
            buffer.append("BuildRequires: mvn(" + entry.getKey() + ":" + entry.getValue() + ")\n");
        }
        for (Map.Entry<String, String> entry : this.model.getDependencies().entrySet()) {
            buffer.append("Requires: mvn(" + entry.getKey() + ":" + entry.getValue() + ")\n");
        }
    }

    private void generateJavadocSubpackage(StringBuilder buffer) {
        buffer.append("%package javadoc\n");
        buffer.append("Group:          Documentation\n");
        buffer.append("Summary:        Javadoc for %{name}\n");
        buffer.append("Requires:       jpackage-utils\n\n");
        buffer.append("%description javadoc\n");
        buffer.append("API documentation for %{name}.\n\n");
    }

    private void generateChangelog(StringBuilder buffer) {
        buffer.append("%changelog\n\n");
        buffer.append("#FIXME\n");
    }

    private void generateInstallSection(StringBuilder buffer) {
        buffer.append("%install\n");
        buffer.append("# jars\n");
        buffer.append("install -d -m 0755 %{buildroot}%{_javadir}\n");
        buffer.append("install -m 644 target/%{name}-%{version}.jar   %{buildroot}%{_javadir}/%{name}.jar\n\n");
        buffer.append("# poms\n");
        buffer.append("install -d -m 755 %{buildroot}%{_mavenpomdir}\n");
        buffer.append("install -pm 644 pom.xml \\\n");
        buffer.append("    %{buildroot}%{_mavenpomdir}/JPP.%{name}.pom\n\n");
        buffer.append("%add_maven_depmap JPP.%{name}.pom %{name}.jar\n\n");
        buffer.append("# javadoc\n");
        buffer.append("install -d -m 0755 %{buildroot}%{_javadocdir}/%{name}\n");
        buffer.append("cp -pr target/site/api*/* %{buildroot}%{_javadocdir}/%{name}/\n");
        buffer.append("rm -rf target/site/api*\n\n");
    }

    private void generateFilesSections(StringBuilder buffer) {
        buffer.append("%files\n");
        buffer.append("%{_javadir}/*\n");
        buffer.append("%{_mavenpomdir}/*\n");
        buffer.append("%{_mavendepmapfragdir}/*\n\n");
        buffer.append("%files javadoc\n");
        buffer.append("%{_javadocdir}/%{name}\n\n");
    }

    private void generatePrepSection(StringBuilder buffer) {
        buffer.append("\n%prep\n");
        buffer.append("%setup -q #You may need to update this according to your Source0\n\n");
    }

    private void generateBuildSection(StringBuilder buffer) {
        buffer.append("%build\n");
        buffer.append("mvn-rpmbuild \\\n");
        buffer.append("        -e \\\n");
        buffer.append("        install javadoc:javadoc\n\n");
    }
}

