/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;

public abstract class TmfProjectModelElement
implements ITmfProjectModelElement,
IResourceChangeListener {
    private final String fName;
    protected final IResource fResource;
    protected final URI fLocation;
    protected final IPath fPath;
    private final ITmfProjectModelElement fParent;
    protected final List<ITmfProjectModelElement> fChildren;

    protected TmfProjectModelElement(String name, IResource resource, ITmfProjectModelElement parent) {
        this.fName = name;
        this.fResource = resource;
        this.fPath = resource.getFullPath();
        this.fLocation = resource.getLocationURI();
        this.fParent = parent;
        this.fChildren = new ArrayList<ITmfProjectModelElement>();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    @Override
    public URI getLocation() {
        return this.fLocation;
    }

    @Override
    public ITmfProjectModelElement getParent() {
        return this.fParent;
    }

    @Override
    public boolean hasChildren() {
        return this.fChildren.size() > 0;
    }

    @Override
    public List<ITmfProjectModelElement> getChildren() {
        return this.fChildren;
    }

    @Override
    public void addChild(ITmfProjectModelElement child) {
        this.fChildren.add(child);
    }

    @Override
    public void removeChild(ITmfProjectModelElement child) {
        this.fChildren.remove(child);
        this.refresh();
    }

    @Override
    public void refresh() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fLocation == null ? 0 : this.fLocation.hashCode());
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + (this.fPath == null ? 0 : this.fPath.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TmfProjectModelElement)) {
            return false;
        }
        TmfProjectModelElement element = (TmfProjectModelElement)other;
        return element.fName.equals(this.fName) && element.fLocation.equals(this.fLocation);
    }
}

