/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.dataviewers.charts.Activator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class UIHelper {
    public static URL getURL(String sPluginRelativePath) {
        URL url = null;
        if (Platform.getExtensionRegistry() != null) {
            try {
                url = new URL(Activator.getDefault().getBundle().getEntry("/"), sPluginRelativePath);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                url = new URL("file:///" + new File(sPluginRelativePath).getAbsolutePath());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    private static Image createImage(String sPluginRelativePath) {
        Image img = null;
        try {
            try {
                img = new Image((Device)Display.getCurrent(), UIHelper.getURL(sPluginRelativePath).openStream());
            }
            catch (MalformedURLException malformedURLException) {
                img = new Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(UIHelper.getURL(sPluginRelativePath).toString()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), 1, 1);
        }
        return img;
    }

    public static Image getImage(String sPluginRelativePath) {
        ImageRegistry registry = JFaceResources.getImageRegistry();
        Image image = registry.get(sPluginRelativePath);
        if (image == null) {
            image = UIHelper.createImage(sPluginRelativePath);
            registry.put(sPluginRelativePath, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String sPluginRelativePath) {
        ImageRegistry registry = JFaceResources.getImageRegistry();
        ImageDescriptor image = registry.getDescriptor(sPluginRelativePath);
        if (image == null) {
            registry.put(sPluginRelativePath, UIHelper.createImage(sPluginRelativePath));
            image = registry.getDescriptor(sPluginRelativePath);
        }
        return image;
    }
}

