/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.controlflow.evProcessor;

import org.eclipse.linuxtools.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.lttng.core.state.model.LttngProcessState;
import org.eclipse.linuxtools.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventProcess;
import org.eclipse.linuxtools.lttng.ui.views.controlflow.evProcessor.AbsFlowTRangeUpdate;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;

class FlowAfterUpdateHandlers {
    FlowAfterUpdateHandlers() {
    }

    final ILttngEventProcessor getSchedChangeHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                TimeRangeEventProcess localProcess;
                LttngProcessState process_in = (LttngProcessState)traceSt.getRunning_process().get(trcEvent.getCpuId());
                Long pid_in = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_NEXT_PID);
                if (!pid_in.equals(process_in.getPid())) {
                    TraceDebug.debug("pid_in != PID!  (getSchedChangeHandler)");
                }
                if ((localProcess = this.procContainer.findProcess(pid_in, process_in.getCpu(), traceSt.getTraceId(), process_in.getCreation_time())) == null) {
                    if (pid_in == 0L || !pid_in.equals(process_in.getPpid())) {
                        TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                        this.addLocalProcess(process_in, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                    } else {
                        TraceDebug.debug("pid_in is not 0 or pid_in == PPID!  (getSchedChangeHandler)");
                    }
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessForkHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long child_pid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_CHILD_PID);
                LttngProcessState process_child = this.lttv_state_find_process(traceSt, trcEvent.getCpuId(), child_pid);
                if (process_child != null) {
                    TimeRangeEventProcess localProcess = this.procContainer.findProcess(process_child.getPid(), process_child.getCpu(), traceSt.getTraceId(), process_child.getCreation_time());
                    if (localProcess == null) {
                        if (child_pid == 0L || !child_pid.equals(process_child.getPpid())) {
                            TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                            this.addLocalProcess(process_child, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                        } else {
                            TraceDebug.debug("localProcess is null with child_pid not 0 or child_pid equals PPID (getProcessForkHandler)");
                        }
                    } else {
                        localProcess.setPpid(process_child.getPpid());
                        localProcess.setTgid(process_child.getTgid());
                    }
                } else {
                    TraceDebug.debug("process_child is null! (getProcessForkHandler)");
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessExitHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                LttngProcessState process = (LttngProcessState)traceSt.getRunning_process().get(trcEvent.getCpuId());
                if (process != null) {
                    TimeRangeEventProcess localProcess = this.procContainer.findProcess(process.getPid(), process.getCpu(), traceSt.getTraceId(), process.getCreation_time());
                    if (localProcess == null) {
                        if (process.getPid() == 0L || !process.getPid().equals(process.getPpid())) {
                            TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                            this.addLocalProcess(process, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                        } else {
                            TraceDebug.debug("process pid is not 0 or pid equals ppid! (getProcessExitHandler)");
                        }
                    }
                } else {
                    TraceDebug.debug("process is null! (getProcessExitHandler)");
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessExecHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                LttngProcessState process = (LttngProcessState)traceSt.getRunning_process().get(trcEvent.getCpuId());
                if (process != null) {
                    TimeRangeEventProcess localProcess = this.procContainer.findProcess(process.getPid(), process.getCpu(), traceSt.getTraceId(), process.getCreation_time());
                    if (localProcess == null) {
                        if (process.getPid() == 0L || !process.getPid().equals(process.getPpid())) {
                            TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                            this.addLocalProcess(process, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                        } else {
                            TraceDebug.debug("process pid is not 0 or pid equals ppid! (getProcessExecHandler)");
                        }
                    } else {
                        localProcess.setName(process.getName());
                    }
                } else {
                    TraceDebug.debug("process is null! (getProcessExecHandler)");
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor GetThreadBrandHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                LttngProcessState process = (LttngProcessState)traceSt.getRunning_process().get(trcEvent.getCpuId());
                if (process != null) {
                    TimeRangeEventProcess localProcess = this.procContainer.findProcess(process.getPid(), process.getCpu(), traceSt.getTraceId(), process.getCreation_time());
                    if (localProcess == null) {
                        if (process.getPid() == 0L || !process.getPid().equals(process.getPpid())) {
                            TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                            this.addLocalProcess(process, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                        } else {
                            TraceDebug.debug("process pid is not 0 or pid equals ppid! (GetThreadBrandHandler)");
                        }
                    } else {
                        localProcess.setBrand(process.getBrand());
                    }
                } else {
                    TraceDebug.debug("process is null! (GetThreadBrandHandler)");
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getEnumProcessStateHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long pid_in = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PID);
                if (pid_in != null) {
                    int nb_cpus;
                    int first_cpu;
                    if (pid_in == 0L) {
                        first_cpu = 0;
                        nb_cpus = traceSt.getNumberOfCPUs();
                    } else {
                        first_cpu = ANY_CPU.intValue();
                        nb_cpus = ANY_CPU.intValue() + 1;
                    }
                    int cpu = first_cpu;
                    while (cpu < nb_cpus) {
                        LttngProcessState process_in = this.lttv_state_find_process(traceSt, Long.valueOf(cpu), pid_in);
                        if (process_in != null) {
                            TimeRangeEventProcess localProcess = this.procContainer.findProcess(process_in.getPid(), process_in.getCpu(), traceSt.getTraceId(), process_in.getCreation_time());
                            if (localProcess == null) {
                                if (process_in.getPid() == 0L || !process_in.getPid().equals(process_in.getPpid())) {
                                    TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                                    localProcess = this.addLocalProcess(process_in, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                                } else {
                                    TraceDebug.debug("process pid is not 0 or pid equals ppid! (getEnumProcessStateHandler)");
                                    return false;
                                }
                            }
                            localProcess.setName(process_in.getName());
                            localProcess.setPpid(process_in.getPpid());
                            localProcess.setTgid(process_in.getTgid());
                        } else {
                            TraceDebug.debug("process_in is null! This should never happen. (getEnumProcessStateHandler)");
                        }
                        ++cpu;
                    }
                } else {
                    TraceDebug.debug("pid_in is null! This should never happen, really... (getEnumProcessStateHandler)");
                }
                return false;
            }
        };
        return handler;
    }
}

