/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;

public class RequirementHelper {
    private static final ConcurrentMap<String, ILaunchRequirementsFunction> APPLICATION_REQUIREMENTS = new ConcurrentHashMap<String, ILaunchRequirementsFunction>();

    private RequirementHelper() {
    }

    public static void registerLaunchTypeRequirements(String launchTypeId, ILaunchRequirementsFunction requirementsFunction) {
        APPLICATION_REQUIREMENTS.put(launchTypeId, Objects.requireNonNull(requirementsFunction));
    }

    public static void registerSameRequirementsAsFor(String launchTypeId, String sourceLaunchTypeId) {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(sourceLaunchTypeId);
        for (Set modes : type.getSupportedModeCombinations()) {
            try {
                ILaunchDelegate[] iLaunchDelegateArray = type.getDelegates(modes);
                int n = iLaunchDelegateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchDelegate delegate = iLaunchDelegateArray[n2];
                    delegate.getDelegate();
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        APPLICATION_REQUIREMENTS.put(launchTypeId, (ILaunchRequirementsFunction)APPLICATION_REQUIREMENTS.get(sourceLaunchTypeId));
    }

    public static List<String> getApplicationLaunchRequirements(ILaunchConfiguration config) throws CoreException {
        ILaunchRequirementsFunction requirementsFunction = (ILaunchRequirementsFunction)APPLICATION_REQUIREMENTS.get(config.getType().getIdentifier());
        return requirementsFunction != null ? Objects.requireNonNull(requirementsFunction.getRequiredBundleIds(config)) : Collections.emptyList();
    }

    public static boolean addApplicationLaunchRequirements(List<String> appRequirements, ILaunchConfiguration configuration, Map<IPluginModelBase, String> bundle2startLevel) throws CoreException {
        Consumer<IPluginModelBase> addPlugin = b -> BundleLauncherHelper.addDefaultStartingBundle(bundle2startLevel, b);
        return RequirementHelper.addApplicationLaunchRequirements(appRequirements, configuration, bundle2startLevel.keySet(), addPlugin);
    }

    public static boolean addApplicationLaunchRequirements(List<String> appRequirements, ILaunchConfiguration configuration, Set<IPluginModelBase> containedPlugins, Consumer<IPluginModelBase> addPlugin) throws CoreException {
        boolean isFeatureBasedLaunch = configuration.getAttribute("useCustomFeatures", false);
        String pluginResolution = isFeatureBasedLaunch ? configuration.getAttribute("featurePluginResolution", "workspace") : "workspace";
        boolean allRequirementsSatisfied = true;
        for (String requiredBundleId : appRequirements) {
            ModelEntry entry = PluginRegistry.findEntry((String)requiredBundleId);
            if (entry != null) {
                Stream allPluginsWithId = Stream.of(entry.getWorkspaceModels(), entry.getExternalModels()).flatMap(Arrays::stream);
                if (!allPluginsWithId.noneMatch(containedPlugins::contains)) continue;
                IPluginModelBase plugin = BundleLauncherHelper.getLatestPlugin(requiredBundleId, pluginResolution);
                addPlugin.accept(plugin);
                continue;
            }
            allRequirementsSatisfied = false;
        }
        return allRequirementsSatisfied;
    }

    public static List<String> getProductRequirements(ILaunchConfiguration config) throws CoreException {
        IExtension[] extensions;
        String product = config.getAttribute("product", null);
        if (product == null) {
            return Collections.emptyList();
        }
        PDEExtensionRegistry registry = PDECore.getDefault().getExtensionsRegistry();
        IExtension[] iExtensionArray = extensions = registry.findExtensions("org.eclipse.core.runtime.products", true);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (product.equals(extension.getUniqueIdentifier()) || product.equals(extension.getSimpleIdentifier())) {
                IConfigurationElement[] elements;
                LinkedHashSet<String> requiredIds = new LinkedHashSet<String>();
                requiredIds.add(extension.getContributor().getName());
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String application = element.getAttribute("application");
                    if (application != null && !application.isEmpty()) {
                        requiredIds.addAll(RequirementHelper.getApplicationRequirements(application));
                    }
                    ++n4;
                }
                return List.copyOf(requiredIds);
            }
            ++n2;
        }
        return Collections.emptyList();
    }

    public static List<String> getApplicationRequirements(String application) {
        IExtension[] extensions;
        PDEExtensionRegistry registry = PDECore.getDefault().getExtensionsRegistry();
        IExtension[] iExtensionArray = extensions = registry.findExtensions("org.eclipse.core.runtime.applications", true);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (application.equals(extension.getUniqueIdentifier()) || application.equals(extension.getSimpleIdentifier())) {
                return List.of(extension.getContributor().getName());
            }
            ++n2;
        }
        return Collections.emptyList();
    }

    @FunctionalInterface
    public static interface ILaunchRequirementsFunction {
        public List<String> getRequiredBundleIds(ILaunchConfiguration var1) throws CoreException;
    }
}

