/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.internal.markers;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.ui.internal.util.XmlUtils;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.internal.markers.AbstractPomProblemResolution;
import org.eclipse.m2e.editor.internal.markers.MavenMarkerResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class IdPartRemovalResolution
extends AbstractPomProblemResolution {
    final boolean isVersion;

    public IdPartRemovalResolution(IMarker marker, boolean version) {
        super(marker);
        this.isVersion = version;
    }

    public int getOrder() {
        return 100;
    }

    @Override
    protected boolean canFix(String editorHint) {
        return this.isVersion ? MavenMarkerResolutionGenerator.isUnneededParentVersion(editorHint) : MavenMarkerResolutionGenerator.isUnneededParentGroupId(editorHint);
    }

    public String getLabel() {
        return this.isVersion ? Messages.PomQuickAssistProcessor_title_version : Messages.PomQuickAssistProcessor_title_groupId;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
    }

    public String getDescription() {
        if (this.getQuickAssistContext() != null) {
            IDocument doc = this.getQuickAssistContext().getSourceViewer().getDocument();
            String[] toRet = new String[1];
            XmlUtils.performOnRootElement((IDocument)doc, (root, structured) -> {
                if ("project".equals(root.getNodeName())) {
                    Element value = XmlUtils.findChild((Element)root, (String)(this.isVersion ? "version" : "groupId"));
                    stringArray[0] = IdPartRemovalResolution.previewForRemovedElement(doc, value);
                }
            });
            if (toRet[0] != null) {
                return toRet[0];
            }
        }
        return Messages.PomQuickAssistProcessor_remove_hint;
    }

    @Override
    protected void processFix(IStructuredDocument doc, Element root, List<IMarker> markers) {
        Element value;
        Element element;
        if ("project".equals(root.getNodeName()) && (element = (value = XmlUtils.findChild((Element)root, (String)(this.isVersion ? "version" : "groupId")))) instanceof IndexedRegion) {
            IndexedRegion off;
            IndexedRegion indexedRegion = (IndexedRegion)element;
            IndexedRegion cfr_ignored_0 = (IndexedRegion)element;
            int offset = off.getStartOffset();
            if (offset <= 0) {
                return;
            }
            Node prev = value.getNextSibling();
            if (prev instanceof Text) {
                off = (IndexedRegion)prev;
            }
            DeleteEdit edit = new DeleteEdit(offset, off.getEndOffset() - offset);
            try {
                edit.apply((IDocument)doc);
                for (IMarker m : markers) {
                    m.delete();
                }
            }
            catch (Exception e) {
                this.LOG.error("Unable to remove the element", (Throwable)e);
            }
        }
    }
}

