/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.JupiterEngineExtensionContext;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.execution.DefaultExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public class JupiterEngineDescriptor
extends EngineDescriptor
implements Node<JupiterEngineExecutionContext> {
    public static final String ENGINE_ID = "junit-jupiter";
    private final JupiterConfiguration configuration;

    public JupiterEngineDescriptor(UniqueId uniqueId, JupiterConfiguration configuration) {
        super(uniqueId, "JUnit Jupiter");
        this.configuration = configuration;
    }

    public JupiterConfiguration getConfiguration() {
        return this.configuration;
    }

    public Node.ExecutionMode getExecutionMode() {
        return JupiterTestDescriptor.toExecutionMode(this.configuration.getDefaultExecutionMode());
    }

    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry extensionRegistry = MutableExtensionRegistry.createRegistryWithDefaultExtensions(context.getConfiguration());
        EngineExecutionListener executionListener = context.getExecutionListener();
        JupiterEngineExtensionContext extensionContext = new JupiterEngineExtensionContext(executionListener, this, context.getConfiguration(), it -> new DefaultExecutableInvoker((ExtensionContext)it, extensionRegistry));
        return context.extend().withExtensionRegistry(extensionRegistry).withExtensionContext(extensionContext).build();
    }

    public void cleanUp(JupiterEngineExecutionContext context) throws Exception {
        context.close();
    }
}

