/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.dtd;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLWriter;
import de.pdark.decentxml.dtd.DocTypeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DocTypeNotation
extends BasicNode
implements DocTypeNode {
    private String name;
    private char quoteChar = (char)34;
    private String text;
    private List<Node> nodes = new ArrayList<Node>();
    private String systemLiteral;
    private String publicIDLiteral;

    public DocTypeNotation(Token token, String name) {
        super(token);
        this.name = name;
    }

    public DocTypeNotation(XMLTokenizer.Type type, String name) {
        super(type, null);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getSystemLiteral() {
        return this.systemLiteral;
    }

    public void setSystemLiteral(String systemLiteral) {
        this.systemLiteral = systemLiteral;
    }

    public boolean isSystem() {
        return this.systemLiteral != null;
    }

    public String getPublicIDLiteral() {
        return this.publicIDLiteral;
    }

    public void setPublicIDLiteral(String publicIDLiteral) {
        this.publicIDLiteral = publicIDLiteral;
    }

    public boolean isPublic() {
        return this.publicIDLiteral != null;
    }

    public String getValue() {
        return this.toXML();
    }

    public DocTypeNotation toXML(XMLWriter writer) throws IOException {
        writer.write(this, "<!NOTATION");
        if (this.nodes.isEmpty()) {
            writer.write(this, " ");
            writer.write(this, this.name);
            writer.write(this, " ");
            writer.write(this, Character.toString(this.quoteChar));
            writer.write(this, this.text);
            writer.write(this, Character.toString(this.quoteChar));
        } else {
            for (Node n : this.nodes) {
                n.toXML(writer);
            }
        }
        writer.write(this, ">");
        return this;
    }

    public DocTypeNotation addNode(Node node) {
        this.nodes.add(node);
        return this;
    }
}

