/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.problem;

import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetNodeInfo;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetSourceInfo;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;
import org.eclipse.actf.visualization.internal.eval.EvaluationItemImpl;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapData;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Node;

public class ProblemItemImpl
implements IProblemItem {
    private static final String NULL_STRING = "";
    private static GuidelineHolder GUIDELINE_HOLDER = GuidelineHolder.getInstance();
    private boolean canHighlight = false;
    private IEvaluationItem checkItem;
    private String description = "";
    private int serialNumber = -1;
    private int line = -1;
    private HighlightTargetNodeInfo highlightTargetNodeInfo;
    private HighlightTargetId[] targetIds = new HighlightTargetId[0];
    private HighlightTargetSourceInfo[] targetSources = new HighlightTargetSourceInfo[0];
    private Node targetNode = null;
    protected String targetStringForHPB = "";
    protected String targetString = "";
    protected int subType;

    public ProblemItemImpl(String string) {
        this.checkItem = GUIDELINE_HOLDER.getEvaluationItem(string);
        if (this.checkItem == null) {
            this.checkItem = new EvaluationItemImpl("unknown", "info");
            DebugPrintUtil.devOrDebugPrintln((Object)("Problem Item: unknown id \"" + string + "\""));
        } else {
            this.description = this.checkItem.createDescription();
        }
    }

    public ProblemItemImpl(String string, Node node) {
        this(string);
        this.setTargetNode(node);
    }

    public IEvaluationItem getEvaluationItem() {
        return this.checkItem;
    }

    public String getId() {
        return this.checkItem.getId();
    }

    public String[] getTableDataGuideline() {
        return this.checkItem.getTableDataGuideline();
    }

    public int[] getMetricsScores() {
        return this.checkItem.getMetricsScores();
    }

    public Image[] getMetricsIcons() {
        return this.checkItem.getMetricsIcons();
    }

    public int getSeverity() {
        return this.checkItem.getSeverity();
    }

    public String getSeverityStr() {
        return this.checkItem.getSeverityStr();
    }

    public String getDescription() {
        return this.description;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public String getTargetStringForExport() {
        return this.targetStringForHPB;
    }

    public boolean isCanHighlight() {
        return this.canHighlight;
    }

    public void setCanHighlight(boolean bl) {
        this.canHighlight = bl;
    }

    public void setEvaluationItem(IEvaluationItem iEvaluationItem) {
        this.checkItem = iEvaluationItem;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setSerialNumber(int n) {
        this.serialNumber = n;
    }

    public void setHighlightTargetIds(HighlightTargetId[] highlightTargetIdArray) {
        if (highlightTargetIdArray != null) {
            this.targetIds = highlightTargetIdArray;
            if (highlightTargetIdArray.length > 0) {
                this.canHighlight = true;
            }
        }
    }

    public HighlightTargetId[] getHighlightTargetIds() {
        return this.targetIds;
    }

    public void setTargetNode(Node node) {
        this.targetNode = node;
    }

    public void setTargetStringForExport(String string) {
        this.targetStringForHPB = string;
    }

    public String getTargetString() {
        return this.targetString;
    }

    public void setTargetString(String string) {
        this.targetString = string;
        if (string != null) {
            this.description = this.checkItem.createDescription(string);
        }
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public String getLineStr() {
        int n = this.getLine();
        if (n > -1) {
            return Integer.toString(n);
        }
        return NULL_STRING;
    }

    public String getLineStrMulti() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.targetSources.length > 0) {
            int n = 0;
            while (n < this.targetSources.length) {
                int n2 = this.targetSources[n].getStartLine();
                stringBuffer.append(n2);
                stringBuffer.append(", ");
                ++n;
            }
            String string = stringBuffer.substring(0, stringBuffer.length() - 2);
            return string;
        }
        if (this.line > -1) {
            return Integer.toString(this.line);
        }
        return NULL_STRING;
    }

    public void setHighlightTargetSourceInfo(HighlightTargetSourceInfo[] highlightTargetSourceInfoArray) {
        if (highlightTargetSourceInfoArray != null) {
            this.targetSources = highlightTargetSourceInfoArray;
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            while (n2 < this.targetSources.length) {
                if (n > this.targetSources[n2].getStartLine()) {
                    n = this.targetSources[n2].getStartLine();
                }
                if (n != Integer.MAX_VALUE) {
                    this.line = n;
                }
                ++n2;
            }
        }
    }

    public HighlightTargetSourceInfo[] getHighlightTargetSoruceInfo() {
        if (this.targetSources.length == 0 && this.line > -1) {
            Html2ViewMapData html2ViewMapData = new Html2ViewMapData(new int[]{this.line, -1}, new int[]{this.line, -1});
            return new HighlightTargetSourceInfo[]{new HighlightTargetSourceInfo(html2ViewMapData, html2ViewMapData)};
        }
        return this.targetSources;
    }

    public void accept(IProblemItemVisitor iProblemItemVisitor) {
        iProblemItemVisitor.visit(this);
    }

    public HighlightTargetNodeInfo getHighlightTargetNodeInfo() {
        return this.highlightTargetNodeInfo;
    }

    public void setHighlightTargetNodeInfo(HighlightTargetNodeInfo highlightTargetNodeInfo) {
        this.highlightTargetNodeInfo = highlightTargetNodeInfo;
    }

    public void setHighlightTargetIds(HighlightTargetId highlightTargetId) {
        if (highlightTargetId != null) {
            this.setHighlightTargetIds(new HighlightTargetId[]{highlightTargetId});
        }
    }

    public void setHighlightTargetSourceInfo(HighlightTargetSourceInfo highlightTargetSourceInfo) {
        if (highlightTargetSourceInfo != null) {
            this.setHighlightTargetSourceInfo(new HighlightTargetSourceInfo[]{highlightTargetSourceInfo});
        }
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSubType(int n) {
        this.subType = n;
    }
}

