/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class SHTableSectionElement
extends SHElement
implements HTMLTableSectionElement {
    private static final long serialVersionUID = 6890717929157559373L;

    protected SHTableSectionElement(String string, SHDocument sHDocument) {
        super(string, sHDocument);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public String getCh() {
        return this.getAttribute("char");
    }

    public void setCh(String string) {
        this.setAttribute("char", string);
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public void setChOff(String string) {
        this.setAttribute("charoff", string);
    }

    public String getVAlign() {
        return this.getAttribute("valign");
    }

    public void setVAlign(String string) {
        this.setAttribute("valign", string);
    }

    public HTMLCollection getRows() {
        int n = 0;
        Node[] nodeArray = new HTMLTableRowElement[8];
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableRowElement) {
                if (nodeArray.length == n) {
                    HTMLTableRowElement[] hTMLTableRowElementArray = new HTMLTableRowElement[n * 2];
                    System.arraycopy(nodeArray, 0, hTMLTableRowElementArray, 0, n);
                    nodeArray = hTMLTableRowElementArray;
                }
                nodeArray[n++] = (HTMLTableRowElement)node;
            }
            node = node.getNextSibling();
        }
        return ((SHDocument)this.getOwnerDocument()).createCollection(nodeArray, n);
    }

    public HTMLElement insertRow(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = 0;
        Node node = this.getFirstChild();
        while (node != null) {
            if (n2 == n) {
                HTMLElement hTMLElement = (HTMLElement)this.getOwnerDocument().createElement("TR");
                this.insertBefore(hTMLElement, node);
                return hTMLElement;
            }
            ++n2;
            node = node.getNextSibling();
        }
        if (n2 == 0) {
            node = (HTMLElement)this.getOwnerDocument().createElement("TR");
            this.insertBefore(node, null);
            return node;
        }
        return null;
    }

    public void deleteRow(int n) {
        if (n < 0) {
            return;
        }
        int n2 = 0;
        Node node = this.getFirstChild();
        while (node != null) {
            if (n2 == n) {
                this.removeChild(node);
                return;
            }
            ++n2;
            node = node.getNextSibling();
        }
    }
}

