/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class SHTableRowElement
extends SHElement
implements HTMLTableRowElement {
    private static final long serialVersionUID = 8399058496811877036L;

    protected SHTableRowElement(String string, SHDocument sHDocument) {
        super(string, sHDocument);
    }

    public int getRowIndex() {
        Node node = this.getParentNode().getParentNode();
        if (node instanceof HTMLTableElement) {
            HTMLCollection hTMLCollection = ((HTMLTableElement)node).getRows();
            int n = 0;
            while (n < hTMLCollection.getLength()) {
                if (hTMLCollection.item(n) == this) {
                    return n;
                }
                ++n;
            }
            throw new RuntimeException("Internal DOM Implementation Error.");
        }
        int n = 0;
        Node node2 = this.getPreviousSibling();
        while (node2 != null) {
            if (node2 instanceof HTMLTableRowElement) {
                ++n;
            }
            node2 = node2.getPreviousSibling();
        }
        return n;
    }

    public void setRowIndex(int n) {
        if (n < 0) {
            return;
        }
        Node node = this.getParentNode().getParentNode();
        if (node instanceof HTMLTableElement) {
            this.getParentNode().removeChild(this);
            HTMLCollection hTMLCollection = ((HTMLTableElement)node).getRows();
            if (hTMLCollection.getLength() < n) {
                return;
            }
            Node node2 = hTMLCollection.item(n);
            Node node3 = node2.getParentNode();
            node3.insertBefore(this, node2);
        } else {
            Node node4 = this.getParentNode().getFirstChild();
            int n2 = 0;
            while (n2 < n && node4 != null) {
                if (node4 instanceof HTMLTableRowElement) {
                    ++n2;
                }
                node4 = node4.getNextSibling();
            }
            if (node4 == null) {
                return;
            }
            this.getParentNode().removeChild(this);
            node4.getParentNode().insertBefore(this, node4);
        }
    }

    public int getSectionRowIndex() {
        int n = 0;
        Node node = this.getPreviousSibling();
        while (node != null) {
            if (node instanceof HTMLTableRowElement) {
                ++n;
            }
            node = node.getPreviousSibling();
        }
        return n;
    }

    public void setSectionRowIndex(int n) {
        if (n < 0) {
            return;
        }
        Node node = this.getParentNode().getFirstChild();
        int n2 = 0;
        while (n2 < n && node != null) {
            if (node instanceof HTMLTableRowElement) {
                ++n2;
            }
            node = node.getNextSibling();
        }
        if (node == null) {
            return;
        }
        this.getParentNode().removeChild(this);
        node.getParentNode().insertBefore(this, node);
    }

    public HTMLCollection getCells() {
        int n = 0;
        Node[] nodeArray = new HTMLTableCellElement[8];
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof HTMLTableCellElement) {
                if (nodeArray.length == n) {
                    HTMLTableCellElement[] hTMLTableCellElementArray = new HTMLTableCellElement[n * 2];
                    System.arraycopy(nodeArray, 0, hTMLTableCellElementArray, 0, n);
                    nodeArray = hTMLTableCellElementArray;
                }
                nodeArray[n++] = (HTMLTableCellElement)node;
            }
            node = node.getNextSibling();
        }
        return ((SHDocument)this.getOwnerDocument()).createCollection(nodeArray, n);
    }

    public void setCells(HTMLCollection hTMLCollection) {
        while (this.hasChildNodes()) {
            this.removeChild(this.getFirstChild());
        }
        int n = 0;
        while (n < hTMLCollection.getLength()) {
            this.insertBefore(hTMLCollection.item(n), null);
            ++n;
        }
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String string) {
        this.setAttribute("bgcolor", string);
    }

    public String getCh() {
        return this.getAttribute("char");
    }

    public void setCh(String string) {
        this.setAttribute("char", string);
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public void setChOff(String string) {
        this.setAttribute("charoff", string);
    }

    public String getVAlign() {
        return this.getAttribute("valing");
    }

    public void setVAlign(String string) {
        this.setAttribute("valing", string);
    }

    public HTMLElement insertCell(int n) {
        if (n < 0) {
            return null;
        }
        Node node = this.getFirstChild();
        int n2 = 0;
        while (n2 < n && node != null) {
            node = node.getNextSibling();
            ++n2;
        }
        if (node == null && n2 != 0) {
            return null;
        }
        HTMLElement hTMLElement = (HTMLElement)this.getOwnerDocument().createElement("TD");
        this.insertBefore(hTMLElement, node);
        return hTMLElement;
    }

    public void deleteCell(int n) {
        if (n < 0) {
            return;
        }
        Node node = this.getFirstChild();
        int n2 = 0;
        while (n2 < n) {
            if (node == null) {
                return;
            }
            ++n2;
        }
        this.removeChild(node);
    }
}

