/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.internal;

import java.util.ArrayList;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.blind.IBlindVisualizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class BlindVisualizerExtension {
    private static final String VISUALIZER = "blindVisualizer";
    private static final String ATTR_CLASS = "class";
    private static BlindVisualizerExtension[] extensions;
    private static IBlindVisualizer[] visualizers;
    private IBlindVisualizer visualizer = null;

    static {
        visualizers = null;
    }

    public static IBlindVisualizer[] getVisualizers() {
        if (visualizers != null) {
            return visualizers;
        }
        BlindVisualizerExtension[] blindVisualizerExtensionArray = BlindVisualizerExtension.getExtensions();
        ArrayList<IBlindVisualizer> arrayList = new ArrayList<IBlindVisualizer>();
        if (blindVisualizerExtensionArray != null) {
            int n = 0;
            while (n < blindVisualizerExtensionArray.length) {
                IBlindVisualizer iBlindVisualizer = blindVisualizerExtensionArray[n].getElementViewerInfoProvider();
                if (iBlindVisualizer != null) {
                    arrayList.add(iBlindVisualizer);
                }
                ++n;
            }
        }
        visualizers = new IBlindVisualizer[arrayList.size()];
        arrayList.toArray(visualizers);
        return visualizers;
    }

    private static BlindVisualizerExtension[] getExtensions() {
        if (extensions != null) {
            return extensions;
        }
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.visualization.blind", VISUALIZER).getExtensions();
        DebugPrintUtil.devOrDebugPrintln((Object)("Blind Visualizer:" + iExtensionArray.length));
        ArrayList<BlindVisualizerExtension> arrayList = new ArrayList<BlindVisualizerExtension>();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                BlindVisualizerExtension blindVisualizerExtension = BlindVisualizerExtension.parseExtension(iConfigurationElementArray[n2]);
                if (blindVisualizerExtension != null) {
                    arrayList.add(blindVisualizerExtension);
                }
                ++n2;
            }
            ++n;
        }
        extensions = arrayList.toArray(new BlindVisualizerExtension[arrayList.size()]);
        return extensions;
    }

    private static BlindVisualizerExtension parseExtension(IConfigurationElement iConfigurationElement) {
        if (!iConfigurationElement.getName().equals(VISUALIZER)) {
            return null;
        }
        try {
            return new BlindVisualizerExtension(iConfigurationElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BlindVisualizerExtension(IConfigurationElement iConfigurationElement) {
        try {
            this.visualizer = (IBlindVisualizer)iConfigurationElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {}
    }

    private IBlindVisualizer getElementViewerInfoProvider() {
        return this.visualizer;
    }
}

