/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.base.impl;

import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.EmbedDrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.DrawingObjectBaseElementImpl;
import org.eclipse.actf.model.dom.odf.draw.FrameElement;
import org.eclipse.actf.model.dom.odf.svg.DescElement;
import org.eclipse.actf.model.dom.odf.svg.TitleElement;
import org.eclipse.actf.model.dom.odf.text.SequenceElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EmbedDrawingObjectElementImpl
extends DrawingObjectBaseElementImpl
implements EmbedDrawingObjectElement {
    private static final long serialVersionUID = 1100047270119869010L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object exp1 = xpathService.compile("../*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='sequence']");

    protected EmbedDrawingObjectElementImpl(ODFDocument oDFDocument, Element element) {
        super(oDFDocument, element);
    }

    public FrameElement getFrameElement() {
        ODFElement oDFElement = (ODFElement)this.getParentNode();
        if (oDFElement instanceof FrameElement) {
            return (FrameElement)oDFElement;
        }
        new ODFException("parent of embed object element should be draw:frame element.").printStackTrace();
        return null;
    }

    public TitleElement getSVGTitleElement() {
        FrameElement frameElement = this.getFrameElement();
        if (frameElement == null) {
            return null;
        }
        return frameElement.getSVGTitleElement();
    }

    public DescElement getSVGDescElement() {
        FrameElement frameElement = this.getFrameElement();
        if (frameElement == null) {
            return null;
        }
        return frameElement.getSVGDescElement();
    }

    public SequenceElement getTextSequenceElement() {
        FrameElement frameElement = this.getFrameElement();
        if (frameElement == null) {
            return null;
        }
        NodeList nodeList = xpathService.evalForNodeList(exp1, (Node)frameElement);
        if (nodeList != null && nodeList.getLength() == 1) {
            return (SequenceElement)nodeList.item(0);
        }
        if (nodeList != null && nodeList.getLength() > 1) {
            new ODFException("draw:image has more than one text:sequence elements.").printStackTrace();
        }
        return null;
    }
}

