/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;

public class RefactoringPreferences {
    public static final String SAVE_ALL_BEFORE_REFACTORING = "saveAllBeforeRefactoring";
    public static final String USE_INLINE_REFACTORING = "useInlineRefactoring";
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;

    public boolean isSaveAllBeforeRefactoring() {
        return this.preferenceStoreAccess.getPreferenceStore().getBoolean(SAVE_ALL_BEFORE_REFACTORING);
    }

    public boolean useInlineRefactoring() {
        return this.preferenceStoreAccess.getPreferenceStore().getBoolean(USE_INLINE_REFACTORING);
    }

    public void setSaveAllBeforeRefactoring(boolean isSaveAllBeforeRefatoring) {
        this.preferenceStoreAccess.getWritablePreferenceStore().setValue(SAVE_ALL_BEFORE_REFACTORING, isSaveAllBeforeRefatoring);
    }

    public void setUseInlineRefactoring(boolean useInlineRefatoring) {
        this.preferenceStoreAccess.getWritablePreferenceStore().setValue(USE_INLINE_REFACTORING, useInlineRefatoring);
    }

    public static class Initializer
    implements IPreferenceStoreInitializer {
        public void initialize(IPreferenceStoreAccess access) {
            access.getWritablePreferenceStore().setDefault(RefactoringPreferences.SAVE_ALL_BEFORE_REFACTORING, false);
            access.getWritablePreferenceStore().setDefault(RefactoringPreferences.USE_INLINE_REFACTORING, true);
        }
    }
}

