/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.formatting;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting.ILineSeparatorInformation;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class PreferenceStoreWhitespaceInformationProvider
implements IWhitespaceInformationProvider {
    @Inject
    private IIndentationInformation indentInfo;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private IWorkspace workspace;

    public IIndentationInformation getIndentationInformation(URI uri) {
        return this.indentInfo;
    }

    public ILineSeparatorInformation getLineSeparatorInformation(URI uri) {
        final String lineSeparator = this.getLineSeparatorPreference(uri);
        return new ILineSeparatorInformation(){

            public String getLineSeparator() {
                return lineSeparator;
            }
        };
    }

    protected String getLineSeparatorPreference(URI uri) {
        String result;
        IProject project = null;
        if (uri.isPlatformResource()) {
            project = this.workspace.getRoot().getProject(uri.segment(1));
        } else {
            Iterator<Pair<IStorage, IProject>> iterator = this.storage2UriMapper.getStorages(uri).iterator();
            if (iterator.hasNext()) {
                Pair<IStorage, IProject> storage = iterator.next();
                project = (IProject)storage.getSecond();
            }
        }
        if (project != null && (result = this.getLineSeparatorPreference((IScopeContext)new ProjectScope(project))) != null) {
            return result;
        }
        result = this.getLineSeparatorPreference((IScopeContext)new InstanceScope());
        if (result != null) {
            return result;
        }
        return System.getProperty("line.separator");
    }

    protected String getLineSeparatorPreference(IScopeContext scopeContext) {
        String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{scopeContext});
        return lineDelimiter;
    }
}

