/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.DescriptionUtils;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.IValidationJobScheduler;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class ValidationJobScheduler
implements IValidationJobScheduler {
    @Inject
    private IDirtyStateManager dirtyStateManager;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    @Inject
    private DescriptionUtils descriptionUtils;

    public void scheduleInitialValidation(IXtextDocument document) {
        if (!(document instanceof XtextDocument)) {
            return;
        }
        this.doScheduleInitialValidation((XtextDocument)document);
    }

    protected void doScheduleInitialValidation(XtextDocument document) {
        URI uri = document.getResourceURI();
        if (uri == null) {
            return;
        }
        IResourceDescription description = this.resourceDescriptions.getResourceDescription(uri);
        if (description == null) {
            return;
        }
        Set outgoingReferences = this.descriptionUtils.collectOutgoingReferences(description);
        for (URI outgoing : outgoingReferences) {
            if (!this.isDirty(outgoing)) continue;
            document.checkAndUpdateAnnotations();
            return;
        }
    }

    protected boolean isDirty(URI uri) {
        return this.dirtyStateManager.hasContent(uri);
    }

    protected IDirtyStateManager getDirtyStateManager() {
        return this.dirtyStateManager;
    }

    public void setDirtyStateManager(IDirtyStateManager dirtyStateManager) {
        this.dirtyStateManager = dirtyStateManager;
    }

    protected IResourceDescriptions getResourceDescriptions() {
        return this.resourceDescriptions;
    }

    public void setResourceDescriptions(IResourceDescriptions resourceDescriptions) {
        this.resourceDescriptions = resourceDescriptions;
    }

    protected DescriptionUtils getDescriptionUtils() {
        return this.descriptionUtils;
    }

    public void setDescriptionUtils(DescriptionUtils descriptionUtils) {
        this.descriptionUtils = descriptionUtils;
    }
}

