/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.compare;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class DefaultMergeEditor
extends XtextEditor {
    public static final String PROVIDER = DefaultMergeEditor.class.getName();
    private int textOrientation;
    private boolean editable;
    private boolean inputSet;

    public void setInternalSite(IWorkbenchPartSite site) {
        this.setSite(site);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input != null) {
            this.setDocumentProvider(DocumentProviderRegistry.getDefault().getDocumentProvider(input));
        }
        super.doSetInput(input);
        this.inputSet = true;
    }

    public void setTextOrientation(int textOrientation) {
        this.textOrientation = textOrientation;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEditorInputModifiable() {
        return this.editable;
    }

    public boolean isEditorInputReadOnly() {
        return !this.editable;
    }

    public void createActions() {
        if (this.inputSet) {
            super.createActions();
        }
    }

    public void close(boolean save) {
        super.close(save);
        this.getDocumentProvider().disconnect((Object)this.getEditorInput());
    }

    public void createPartControl(Composite composite) {
        SourceViewer sourceViewer = (SourceViewer)this.createSourceViewer(composite, this.createVerticalRuler(), 0x300 | this.textOrientation);
        this.setSourceViewer((ITextEditor)this, sourceViewer);
        this.getSourceViewer().configure((SourceViewerConfiguration)this.getXtextSourceViewerConfiguration());
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer).install(this.getPreferenceStore());
        this.getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
    }

    protected void setActionsActivated(boolean state) {
        Method method = null;
        try {
            method = AbstractTextEditor.class.getDeclaredMethod("setActionActivation", Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this, state);
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    private void setSourceViewer(ITextEditor editor, SourceViewer viewer) {
        Field field = null;
        try {
            field = AbstractTextEditor.class.getDeclaredField("fSourceViewer");
            field.setAccessible(true);
            field.set(editor, viewer);
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }
}

