/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.rk.impl;

import java.util.ArrayList;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.TransformationDecorator;
import org.eclipse.stem.core.solver.SolverException;
import org.eclipse.stem.core.solver.impl.SolverImpl;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.solvers.rk.ApacheCommonsMathODESolver;
import org.eclipse.stem.solvers.rk.RkPackage;
import org.eclipse.stem.solvers.rk.impl.ApacheCommonsMathODEJob;
import org.eclipse.stem.ui.Activator;

public class ApacheCommonsMathODESolverImpl
extends SolverImpl
implements ApacheCommonsMathODESolver {
    protected ArrayList<IntegrationDecorator> iDecorators = new ArrayList();
    protected int[] arraySizes;
    protected ApacheCommonsMathODEJob[] jobs = null;

    protected ApacheCommonsMathODESolverImpl() {
    }

    public boolean step(STEMTime time, long timeDelta, int cycle) throws SolverException {
        try {
            int num_threads;
            BasicEList transDecorators = new BasicEList();
            for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
                if (!(decorator instanceof TransformationDecorator)) continue;
                transDecorators.add((Object)((TransformationDecorator)decorator));
            }
            Activator act = Activator.getDefault();
            if (act != null) {
                IPreferenceStore preferenceStore = act.getPreferenceStore();
                num_threads = (short)preferenceStore.getInt("simulationThreads");
            } else {
                num_threads = 2;
            }
            if (this.arraySizes == null || this.arraySizes.length != num_threads) {
                this.arraySizes = new int[num_threads];
            }
            this.partitioner.setNumProcesses(num_threads);
            for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
                if (!(decorator instanceof Trigger) && !(decorator instanceof TransformationDecorator)) continue;
                decorator.updateLabels(time, timeDelta, cycle);
            }
            for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
                if (!(decorator instanceof IntegrationDecorator)) continue;
                EList allLabels = decorator.getLabelsToUpdate();
                for (IntegrationLabel iLabel : allLabels) {
                    iLabel.getProbeValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    iLabel.getTempValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    iLabel.getTempValue().prepareCycle();
                    iLabel.getProbeValue().prepareCycle();
                }
            }
            if (this.iDecorators.isEmpty()) {
                for (Decorator d : this.getCanonicalGraph().getDecorators()) {
                    if (!(d instanceof IntegrationDecorator)) continue;
                    this.iDecorators.add((IntegrationDecorator)d);
                }
            }
            if (this.jobs == null || this.jobs.length != num_threads) {
                this.jobs = new ApacheCommonsMathODEJob[num_threads];
                int n = 0;
                while (n < num_threads) {
                    this.jobs[n] = new ApacheCommonsMathODEJob("Worker " + n, (short)n, this);
                    n = (short)(n + 1);
                }
            }
            int n = 0;
            while (n < num_threads) {
                this.jobs[n].setCycle(cycle);
                this.jobs[n].setTimeDelta(timeDelta);
                this.jobs[n].setTime(time);
                ++n;
            }
            n = 0;
            while (n < num_threads) {
                this.jobs[n].schedule();
                ++n;
            }
            n = 0;
            while (n < num_threads) {
                this.jobs[n].join();
                ++n;
            }
        }
        catch (Throwable t) {
            throw new SolverException(t.getMessage(), null, t);
        }
        return true;
    }

    protected void _step(STEMTime time, long timeDelta, int cycle, short threadnum) throws SolverException {
        if (this.arraySizes[threadnum] == 0) {
            int size = 0;
            for (IntegrationDecorator sdm : this.iDecorators) {
                EList list = this.partitioner.partitionDecoratorLabels((Decorator)sdm, (int)threadnum);
                int j = 0;
                while (j < list.size()) {
                    size += ((DynamicLabel)list.get(j)).getCurrentValue().eClass().getEAllAttributes().size();
                    ++j;
                }
            }
            this.arraySizes[threadnum] = size;
        }
        if (this.arraySizes[threadnum] == 0) {
            return;
        }
        double[] y0 = new double[this.arraySizes[threadnum]];
        int index = 0;
        for (IntegrationDecorator sdm : this.iDecorators) {
            EList elist = this.partitioner.partitionDecoratorLabels((Decorator)sdm, (int)threadnum);
            int i = 0;
            while (i < elist.size()) {
                DynamicLabel lab = (DynamicLabel)elist.get(i);
                int sz = lab.getCurrentValue().eClass().getEAllAttributes().size();
                double[] ytmp = null;
                ytmp = new double[sz];
                this.getValues(((IntegrationLabel)lab).getTempValue(), ytmp);
                int j = 0;
                while (j < ytmp.length) {
                    y0[index++] = ytmp[j];
                    ++j;
                }
                ++i;
            }
        }
        double t0 = cycle;
        STEMDiffEquation sde = new STEMDiffEquation(time, timeDelta, threadnum);
        FirstOrderIntegrator foInt = this.createIntegrator();
        try {
            foInt.integrate((FirstOrderDifferentialEquations)sde, t0, y0, t0 + 1.0, y0);
        }
        catch (Exception e) {
            throw new SolverException(e.getMessage(), null, (Throwable)e);
        }
        index = 0;
        for (IntegrationDecorator sdm : this.iDecorators) {
            EList labels = this.partitioner.partitionDecoratorLabels((Decorator)sdm, (int)threadnum);
            int i = 0;
            while (i < labels.size()) {
                DynamicLabel lab = (DynamicLabel)labels.get(i);
                int sz = lab.getCurrentValue().eClass().getEAllAttributes().size();
                double[] ytmp = null;
                ytmp = new double[sz];
                int j = 0;
                while (j < ytmp.length) {
                    ytmp[j] = y0[index++];
                    ++j;
                }
                this.setValues((IntegrationLabelValue)lab.getNextValue(), ytmp);
                if (sdm.isAddStochasticNoise()) {
                    sdm.doStochasticProcess((IntegrationLabel)lab, timeDelta);
                }
                lab.setNextValueValid(true);
                ++i;
            }
        }
    }

    void getValues(IntegrationLabelValue lv, double[] result) {
        int i = 0;
        EList attrList = lv.eClass().getEAllAttributes();
        int j = 0;
        while (j < attrList.size()) {
            EAttribute ea = (EAttribute)attrList.get(j);
            result[i++] = lv.eGetDouble(ea.getFeatureID());
            ++j;
        }
    }

    void setValues(IntegrationLabelValue ilv, double[] d) {
        int i = 0;
        EList attrList = ilv.eClass().getEAllAttributes();
        int j = 0;
        while (j < attrList.size()) {
            EAttribute ea = (EAttribute)attrList.get(j);
            if (ea.isChangeable()) {
                ilv.eSetDouble(ea.getFeatureID(), d[i++]);
            } else {
                ++i;
            }
            ++j;
        }
    }

    public void reset() {
        this.setInitialized(false);
        this.arraySizes = null;
        this.jobs = null;
        this.iDecorators.clear();
    }

    protected EClass eStaticClass() {
        return RkPackage.Literals.APACHE_COMMONS_MATH_ODE_SOLVER;
    }

    @Override
    public FirstOrderIntegrator createIntegrator() {
        throw new UnsupportedOperationException();
    }

    public class STEMDiffEquation
    implements FirstOrderDifferentialEquations {
        STEMTime time;
        long timeDelta;
        EList<DynamicLabel> labelList = new BasicEList();
        int threadnum;

        public STEMDiffEquation(STEMTime t, long timeDelta, int threadnum) {
            this.time = t;
            this.timeDelta = timeDelta;
            this.threadnum = threadnum;
        }

        public int getDimension() {
            return ApacheCommonsMathODESolverImpl.this.arraySizes[this.threadnum];
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) {
            EList labels;
            int dim;
            EList llist;
            IntegrationDecorator sdm;
            int index = 0;
            double[] ytemp = null;
            int i = 0;
            while (i < ApacheCommonsMathODESolverImpl.this.iDecorators.size()) {
                sdm = ApacheCommonsMathODESolverImpl.this.iDecorators.get(i);
                llist = ApacheCommonsMathODESolverImpl.this.partitioner.partitionDecoratorLabels((Decorator)sdm, this.threadnum);
                int k = 0;
                while (k < llist.size()) {
                    DynamicLabel l = (DynamicLabel)llist.get(k);
                    IntegrationLabelValue probeV = ((IntegrationLabel)l).getProbeValue();
                    dim = probeV.eClass().getEAllAttributes().size();
                    ytemp = new double[dim];
                    int m = 0;
                    while (m < dim) {
                        ytemp[m] = y[index++];
                        ++m;
                    }
                    ApacheCommonsMathODESolverImpl.this.setValues(probeV, ytemp);
                    ++k;
                }
                ++i;
            }
            i = 0;
            while (i < ApacheCommonsMathODESolverImpl.this.iDecorators.size()) {
                sdm = ApacheCommonsMathODESolverImpl.this.iDecorators.get(i);
                labels = ApacheCommonsMathODESolverImpl.this.partitioner.partitionDecoratorLabels((Decorator)sdm, this.threadnum);
                sdm.calculateDeltas(this.time, t, this.timeDelta, labels);
                ++i;
            }
            i = 0;
            while (i < ApacheCommonsMathODESolverImpl.this.iDecorators.size()) {
                sdm = ApacheCommonsMathODESolverImpl.this.iDecorators.get(i);
                labels = ApacheCommonsMathODESolverImpl.this.partitioner.partitionDecoratorLabels((Decorator)sdm, this.threadnum);
                sdm.applyExternalDeltas(this.time, t, this.timeDelta, labels);
                ++i;
            }
            index = 0;
            i = 0;
            while (i < ApacheCommonsMathODESolverImpl.this.iDecorators.size()) {
                sdm = ApacheCommonsMathODESolverImpl.this.iDecorators.get(i);
                llist = ApacheCommonsMathODESolverImpl.this.partitioner.partitionDecoratorLabels((Decorator)sdm, this.threadnum);
                for (DynamicLabel l : llist) {
                    IntegrationLabelValue deltaV = ((IntegrationLabel)l).getDeltaValue();
                    dim = deltaV.eClass().getEAllAttributes().size();
                    ytemp = new double[dim];
                    ApacheCommonsMathODESolverImpl.this.getValues(((IntegrationLabel)l).getDeltaValue(), ytemp);
                    int k = 0;
                    while (k < dim) {
                        yDot[index++] = ytemp[k];
                        ++k;
                    }
                }
                ++i;
            }
        }
    }
}

