/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.ui.Constants;
import org.eclipse.stem.model.ui.editor.vismodel.CompartmentElement;
import org.eclipse.stem.model.ui.editor.vismodel.ModelElement;
import org.eclipse.swt.widgets.Text;

public final class VisualModelUtils {
    private VisualModelUtils() {
    }

    public static CompartmentElement findCompartmentElementForCompartment(Compartment compartment, ModelElement me) {
        for (CompartmentElement ce : me.getCompartmentElements()) {
            if (ce.getCompartment() != compartment) continue;
            return ce;
        }
        return null;
    }

    public static boolean isCompartmentDirectlyContained(Compartment compartment, CompartmentGroup cg) {
        for (Compartment c : cg.getCompartments()) {
            if (c != compartment) continue;
            return false;
        }
        return true;
    }

    public static String safeGet(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String safeGet(Text field) {
        if ("".equals(field.getText().trim())) {
            return null;
        }
        return field.getText();
    }

    public static EDataType[] getDefaultCompartmentDataTypes() {
        return Constants.DEFAULT_COMPARTMENT_DATA_TYPES;
    }
}

