/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment.ui;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stem.analysis.automaticexperiment.OptimizerAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.ui.AlgorithmControl;
import org.eclipse.stem.analysis.automaticexperiment.views.Messages;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewAutomaticExperimentWizard
extends NewIdentifiableWizard {
    NewAutomaticExperimentPage page;

    public void addPages() {
        this.setForcePreviousAndNextButtons(false);
        this.newIdentifiablePage = this.createNewIdentifiablePage();
        if (this.newIdentifiablePage == null) {
            return;
        }
        this.newDublinCorePage = this.createDublinCorePage();
        if (this.newDublinCorePage == null) {
            return;
        }
        this.addPage((IWizardPage)this.newIdentifiablePage);
        this.addPage((IWizardPage)this.newDublinCorePage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        return nextPage;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/experiment.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.EXPERIMENT_TYPE_URI.toString());
                this.type.setEnabled(false);
                this.titleTextField.setText(Messages.getString("dc_title_a_exp"));
                this.source.setText(Messages.getString("dc_source_a_exp"));
                this.descriptionTextField.setText(Messages.getString("dc_desc_a_exp"));
            }
        };
    }

    protected Identifiable createIdentifiable() {
        return this.createAutomaticExperiment();
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.setHelpContextId("org.eclipse.stem.doc.newautomaticexp_contextid");
        this.page = new NewAutomaticExperimentPage(this.getShell(), "New Automatic Experiment Wizard");
        this.page.setTitle("");
        return this.page;
    }

    protected String getSerializationFileNameExtension() {
        return "automaticexperiment";
    }

    protected String getSerializationFolderName() {
        return "experiments";
    }

    protected String getWizardTitle() {
        return "Automatic Experiment Wizard";
    }

    protected OptimizerAlgorithm createAutomaticExperiment() {
        OptimizerAlgorithm ret = this.page.algControl.createAutomaticExperiment();
        ret.setDublinCore(this.newDublinCorePage.createDublinCore());
        return ret;
    }

    protected static class NewAutomaticExperimentPage
    extends NewIdentifiablePage {
        public List parametersList = null;
        public Combo algorithmCombo = null;
        public Combo errorFunctionCombo = null;
        public Spinner numOfIterationsSpinner = null;
        public Text refDirText = null;
        public Text scenarioText = null;
        protected Shell shell = null;
        AlgorithmControl algControl;
        protected ModifyListener projectValidator = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewAutomaticExperimentPage.this.setPageComplete(NewAutomaticExperimentPage.this.validatePage());
            }
        };
        private OptimizerAlgorithm[] algorithms;

        protected NewAutomaticExperimentPage(Shell shell, String pageName) {
            super(pageName);
            this.shell = shell;
        }

        protected Composite createSpecificComposite(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newautomaticexp_contextid");
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite.setLayout((Layout)gridLayout);
            Label label21 = new Label(composite, 0);
            label21.setText(Messages.getString("WIZ.ALGORITHM"));
            this.algorithmCombo = new Combo(composite, 8);
            this.initializeAlgorithmsCombo();
            GridData gridData21 = new GridData(32);
            gridData21.horizontalSpan = 1;
            this.algorithmCombo.setLayoutData((Object)gridData21);
            GridData gridDataCombo = new GridData(32);
            gridDataCombo.horizontalSpan = 1;
            this.algorithmCombo.setLayoutData((Object)gridDataCombo);
            Label separator = new Label(composite, 258);
            GridData sepData = new GridData(4, 128, true, false);
            sepData.horizontalSpan = 2;
            separator.setLayoutData((Object)sepData);
            this.algControl = new AlgorithmControl(composite, 0, this.projectValidator, this.getSelectedProject(), this.algorithms);
            GridData gridDataAControl = new GridData(4, 0x1000000, true, false, 2, 1);
            this.algControl.setLayoutData(gridDataAControl);
            return composite;
        }

        private void initializeAlgorithmsCombo() {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] algorithmsConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.analysis.automaticexperiment.algorithm");
            ArrayList<OptimizerAlgorithm> temp = new ArrayList<OptimizerAlgorithm>();
            this.algorithms = new OptimizerAlgorithm[algorithmsConfigElements.length];
            int i = 0;
            while (i < algorithmsConfigElements.length) {
                IConfigurationElement element = algorithmsConfigElements[i];
                if (element.getName().equals("classdef")) {
                    try {
                        temp.add((OptimizerAlgorithm)element.createExecutableExtension(Messages.getString("ALG.1")));
                    }
                    catch (CoreException e) {
                        Activator.logError((String)Messages.getString("ALG.3"), (Throwable)e);
                    }
                }
                ++i;
            }
            this.algorithms = temp.toArray(new OptimizerAlgorithm[0]);
            i = 0;
            while (i < this.algorithms.length) {
                this.algorithmCombo.add(this.algorithms[i].eClass().getName());
                ++i;
            }
            this.algorithmCombo.select(0);
        }

        protected boolean validatePage() {
            boolean retValue = super.validatePage();
            if (retValue) {
                this.setErrorMessage(null);
                retValue = this.algControl.validate();
                if (!retValue) {
                    this.setErrorMessage(this.algControl.getErrorMessage());
                }
            }
            return retValue;
        }
    }

    public static class NewAutomaticExperimentWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewAutomaticExperimentWizard wizard = new NewAutomaticExperimentWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

