/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model.provisional;

import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.ViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputRequestor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;

public class ViewerInputService {
    public static final Object NULL_INPUT = new IViewerInputProvider(){

        public void update(IViewerInputUpdate update) {
            update.setInputElement(null);
            update.done();
        }
    };
    private IViewerInputUpdate fPendingUpdate = null;
    private IViewerInputRequestor fRequestor = null;
    private ITreeModelViewer fViewer;
    private IViewerInputRequestor fProxyRequest = new IViewerInputRequestor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewerInputComplete(IViewerInputUpdate update) {
            ViewerInputService viewerInputService = ViewerInputService.this;
            synchronized (viewerInputService) {
                ViewerInputService.this.fPendingUpdate = null;
            }
            ViewerInputService.this.fRequestor.viewerInputComplete(update);
        }
    };

    public ViewerInputService(ITreeModelViewer viewer, IViewerInputRequestor requestor) {
        this.fRequestor = requestor;
        this.fViewer = viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveViewerInput(Object source) {
        IViewerInputProvider provdier = ViewerAdapterService.getInputProvider(source);
        ViewerInputService viewerInputService = this;
        synchronized (viewerInputService) {
            if (this.fPendingUpdate != null) {
                this.fPendingUpdate.cancel();
            }
            this.fPendingUpdate = new ViewerInputUpdate(this.fViewer.getPresentationContext(), this.fViewer.getInput(), this.fProxyRequest, source);
        }
        if (provdier == null) {
            this.fPendingUpdate.setInputElement(source);
            this.fPendingUpdate.done();
        } else {
            provdier.update(this.fPendingUpdate);
        }
    }

    public synchronized void dispose() {
        if (this.fPendingUpdate != null) {
            this.fPendingUpdate.cancel();
            this.fPendingUpdate = null;
        }
    }
}

