/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.render.Line;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.render.AxesRenderHelper;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public class Area
extends Line {
    private static final String AREA_ENVELOPS = "Area.Envelops";

    private Fill getSeriesPaletteEntry() {
        int iThisSeriesIndex;
        Fill fPaletteEntry = null;
        SeriesDefinition sd = null;
        Series se = this.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null && (iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se)) >= 0) {
            EList ePalette = sd.getSeriesPalette().getEntries();
            fPaletteEntry = FillUtil.getPaletteFill((EList)ePalette, (int)iThisSeriesIndex);
            this.updateTranslucency(fPaletteEntry, se);
        }
        return fPaletteEntry;
    }

    protected boolean validateShowAsTape() {
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        AreaSeries as = (AreaSeries)this.getSeries();
        if (!as.isStacked()) {
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                return false;
            }
        } else {
            Axis[] axaOrthogonal = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            if (axaOrthogonal.length > 1) {
                Axis axis;
                if (ChartUtil.isStudyLayout((Chart)cwa) && (axis = ChartUtil.getAxisFromSeries((Series)as)) != null) {
                    for (SeriesDefinition sd : axis.getSeriesDefinitions()) {
                        for (Series se : sd.getRunTimeSeries()) {
                            if (se instanceof AreaSeries && se.isStacked()) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                for (SeriesDefinition sd : axaOrthogonal[0].getSeriesDefinitions()) {
                    for (Series se : sd.getRunTimeSeries()) {
                        if (se instanceof AreaSeries && se.isStacked()) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected void renderAsCurve(IPrimitiveRenderer ipr, LineAttributes lia, ISeriesRenderingHints isrh, Location[] loa, boolean bShowAsTape, double tapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        Fill seriesPalette = this.getSeriesPaletteEntry();
        double zeroLocation = 0.0;
        if (this.isDimension3D()) {
            zeroLocation = ((SeriesRenderingHints3D)isrh).getPlotBaseLocation();
        } else {
            SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
            zeroLocation = srh.getZeroLocation();
            Bounds boClientArea = srh.getClientAreaBounds(true);
            double dSeriesThickness = srh.getSeriesThickness();
            if (((ChartWithAxes)this.getModel()).getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
            }
            if (((ChartWithAxes)this.getModel()).isTransposed()) {
                if (zeroLocation < boClientArea.getLeft()) {
                    zeroLocation = boClientArea.getLeft();
                }
                if (zeroLocation > boClientArea.getLeft() + boClientArea.getWidth()) {
                    zeroLocation = boClientArea.getLeft() + boClientArea.getWidth();
                }
            } else {
                if (zeroLocation < boClientArea.getTop()) {
                    zeroLocation = boClientArea.getTop();
                }
                if (zeroLocation > boClientArea.getTop() + boClientArea.getHeight()) {
                    zeroLocation = boClientArea.getTop() + boClientArea.getHeight();
                }
            }
        }
        boolean bStacked = this.getSeries().isStacked();
        AreaSeries as = (AreaSeries)this.getSeries();
        if (!bStacked && as.isConnectMissingValue()) {
            Line.DataPointsSeeker seeker = Line.DataPointsSeeker.create(isrh.getDataPoints(), (LineSeries)((AreaSeries)this.getSeries()), bStacked);
            ArrayList<Location> lst = new ArrayList<Location>();
            if (seeker.next()) {
                if (seeker.getIndex() > 0) {
                    lst.add(loa[seeker.getIndex() - 1]);
                }
                lst.add(loa[seeker.getIndex()]);
            }
            while (seeker.next()) {
                lst.add(loa[seeker.getIndex()]);
            }
            if (seeker.getIndex() < seeker.size() - 1) {
                lst.add(loa[seeker.getIndex() + 1]);
            }
            loa = this.isDimension3D() ? new Location3D[lst.size()] : new Location[lst.size()];
            loa = lst.toArray(loa);
        }
        CurveRenderer cr = new CurveRenderer((ChartWithAxes)this.getModel(), (BaseRenderer)this, lia, loa, zeroLocation, bShowAsTape, tapeWidth, true, this.getSeries().isTranslucent(), this.getSeries().isStacked() || this.getAxis().isPercent(), true, true, seriesPalette != null ? seriesPalette : paletteEntry, usePaletteLineColor, true);
        cr.draw(ipr);
    }

    protected void renderDataPoints(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh, DataPointHints[] dpha, LineAttributes lia, Location[] loa, boolean bShowAsTape, double dTapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        Fill seriesPalette = this.getSeriesPaletteEntry();
        if (seriesPalette != null) {
            paletteEntry = seriesPalette;
        }
        AreaDataPointsRenderer dpRender = AreaDataPointsRenderer.create(this, ipr, isrh, dpha, loa, bShowAsTape, dTapeWidth, paletteEntry);
        dpRender.render();
    }

    protected void renderShadow(IPrimitiveRenderer ipr, Plot p, LineAttributes lia, Location[] loa, boolean bShowAsTape) {
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        LineSeries ls = (LineSeries)this.getSeries();
        if (fPaletteEntry == null) {
            fPaletteEntry = goFactory.RED();
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), RectangleRenderEvent.class);
        rre.setBackground(ca.getBackground());
        rre.setOutline(lia);
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), PolygonRenderEvent.class);
        Location[] loa = new Location[]{goFactory.createLocation(bo.getLeft() + 1.0 * this.getDeviceScale(), bo.getTop() + bo.getHeight() - 2.0 * this.getDeviceScale()), goFactory.createLocation(bo.getLeft() + bo.getWidth() - 1.0 * this.getDeviceScale(), bo.getTop() + bo.getHeight() - 2.0 * this.getDeviceScale()), goFactory.createLocation(bo.getLeft() + bo.getWidth() * 5.0 / 6.0, bo.getTop() + bo.getHeight() / 3.0), goFactory.createLocation(bo.getLeft() + bo.getWidth() * 2.0 / 3.0, bo.getTop() + bo.getHeight() / 2.0), goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop() + 1.0 * this.getDeviceScale())};
        pre.setBackground(fPaletteEntry);
        pre.setPoints(loa);
        ipr.fillPolygon(pre);
        LineAttributes liaMarker = ls.getLineAttributes();
        if (liaMarker.isVisible()) {
            if (ls.isPaletteLineColor()) {
                liaMarker = goFactory.copyOf(liaMarker);
                liaMarker.setColor(FillUtil.getColor((Fill)fPaletteEntry));
            }
            pre.setOutline(liaMarker);
            ipr.drawPolygon(pre);
        }
    }

    protected Location[] filterNull(Location[] ll) {
        Bounds boClientArea = this.getPlotBounds();
        ArrayList<Location> al = new ArrayList<Location>();
        int i = 0;
        while (i < ll.length) {
            if (Double.isNaN(ll[i].getX())) {
                ll[i].setX(boClientArea.getLeft());
            }
            if (Double.isNaN(ll[i].getY())) {
                ll[i].setY(boClientArea.getTop() + boClientArea.getHeight());
            }
            al.add(ll[i]);
            ++i;
        }
        if (ll instanceof Location3D[]) {
            return (Location[])al.toArray(new Location3D[al.size()]);
        }
        return al.toArray(new Location[al.size()]);
    }

    private static abstract class AreaDataPointsRenderer
    extends Line.DataPointsRenderer {
        protected final Fill fillColor;
        protected final double zeroLocation;

        AreaDataPointsRenderer(Line.DataPointsRenderer.Context context) throws ChartException {
            super(context);
            this.dc.setPlaneShadowsComparator(WrappedInstruction.getDefaultComarator());
            this.dc.setPlanesComparator(WrappedInstruction.getDefaultComarator());
            this.zeroLocation = this.initZeroLocation(context.line, context.isrh);
            Fill fillColor = context.paletteEntry;
            if (this.ls.isTranslucent() && fillColor instanceof ColorDefinition) {
                fillColor = goFactory.translucent((ColorDefinition)fillColor);
            }
            this.fillColor = fillColor;
        }

        protected abstract double initZeroLocation(Line var1, ISeriesRenderingHints var2) throws ChartException;

        public static AreaDataPointsRenderer create(Area area, IPrimitiveRenderer ipr, ISeriesRenderingHints isrh, DataPointHints[] dpha, Location[] loa, boolean bShowAsTape, double dTapeWidth, Fill paletteEntry) throws ChartException {
            Line.DataPointsRenderer.Context context = new Line.DataPointsRenderer.Context(area, ipr, isrh, dpha, paletteEntry);
            if (area.isDimension3D()) {
                return new AreaDataPointsRenderer3D(context, loa, dTapeWidth);
            }
            if (bShowAsTape) {
                return new AreaDataPointsRenderer2Dplus(context, loa);
            }
            if (context.bStacked) {
                return new AreaDataPointsRenderer2DStacked(context, loa);
            }
            return new AreaDataPointsRenderer2D(context, loa);
        }
    }

    private static class AreaDataPointsRenderer2D
    extends AreaDataPointsRenderer {
        protected final SeriesRenderingHints srh;
        protected final Location[] loa;
        protected final Line.Transposition trans;
        protected final LineRenderEvent lre;
        protected final PolygonRenderEvent pre;
        protected final List<Location> lstPolygon = new ArrayList<Location>();

        AreaDataPointsRenderer2D(Line.DataPointsRenderer.Context context, Location[] loa) throws ChartException {
            super(context);
            this.srh = (SeriesRenderingHints)context.isrh;
            this.loa = loa;
            this.trans = ((ChartWithAxes)context.line.getModel()).isTransposed() ? Line.Transposition.TRANSPOSED : Line.Transposition.NOT_TRANSPOSED;
            StructureSource sourceObj = this.createSeriesSource();
            this.pre = (PolygonRenderEvent)((EventObjectCache)context.ipr).getEventObject((Object)sourceObj, PolygonRenderEvent.class);
            this.lre = (LineRenderEvent)((EventObjectCache)context.ipr).getEventObject((Object)sourceObj, LineRenderEvent.class);
            this.lre.setLineAttributes(this.lia);
        }

        protected double initZeroLocation(Line line, ISeriesRenderingHints isrh) throws ChartException {
            SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
            double zeroLocation = srh.getZeroLocation();
            if (ChartUtil.isStudyLayout((Chart)this.cwa)) {
                zeroLocation = srh.getLocationOnOrthogonal(srh.getOrthogonalScale().getMinimum());
            }
            Bounds boClientArea = srh.getClientAreaBounds(true);
            double dSeriesThickness = srh.getSeriesThickness();
            if (this.cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
            }
            if (this.cwa.isTransposed()) {
                if (zeroLocation < boClientArea.getLeft()) {
                    zeroLocation = boClientArea.getLeft();
                }
                if (zeroLocation > boClientArea.getLeft() + boClientArea.getWidth()) {
                    zeroLocation = boClientArea.getLeft() + boClientArea.getWidth();
                }
            } else {
                if (zeroLocation < boClientArea.getTop()) {
                    zeroLocation = boClientArea.getTop();
                }
                if (zeroLocation > boClientArea.getTop() + boClientArea.getHeight()) {
                    zeroLocation = boClientArea.getTop() + boClientArea.getHeight();
                }
            }
            return zeroLocation;
        }

        protected void drawFrontLine(int pindex, int index) {
            this.lre.setStart(this.loa[pindex]);
            this.lre.setEnd(this.loa[index]);
            this.lre.setSourceObject((Object)this.createDataPointSource(pindex));
            this.dc.addLine(this.lre);
        }

        protected void afterLoop(Line.DataPointsSeeker seeker) {
            int lindex = seeker.getIndex();
            if (lindex < seeker.size() - 1) {
                this.trans.setY(this.loa[lindex + 1], this.zeroLocation);
                this.addPolygonPoint(this.loa[lindex + 1]);
                this.drawFrontLine(lindex, lindex + 1);
            } else {
                Location pt1 = this.loa[lindex].copyInstance();
                this.trans.setY(pt1, this.zeroLocation);
                this.addPolygonPoint(pt1);
            }
            this.fillPolygon();
        }

        protected void beforeLoop(Line.DataPointsSeeker seeker) {
            int findex = seeker.getIndex();
            if (findex > 0) {
                this.trans.setY(this.loa[findex - 1], this.zeroLocation);
                this.drawFrontLine(findex - 1, findex);
                this.addPolygonPoint(this.loa[findex - 1]);
            } else {
                Location pt0 = this.loa[findex].copyInstance();
                this.trans.setY(pt0, this.zeroLocation);
                this.addPolygonPoint(pt0);
            }
            this.addPolygonPoint(this.loa[findex]);
        }

        protected void processDataPoint(Line.DataPointsSeeker seeker) {
            int index = seeker.getIndex();
            int pindex = seeker.getPrevIndex();
            if (seeker.isNull()) {
                this.trans.setY(this.loa[index], this.zeroLocation);
            }
            this.addPolygonPoint(this.loa[index]);
            this.drawFrontLine(pindex, index);
        }

        protected void addPolygonPoint(Location lo) {
            this.lstPolygon.add(lo);
        }

        protected void fillPolygon() {
            if (this.lstPolygon.size() > 0) {
                Location[] pa = this.lstPolygon.toArray(new Location[this.lstPolygon.size()]);
                this.pre.setOutline(null);
                this.pre.setPoints(pa);
                this.pre.setBackground(this.fillColor);
                this.pre.setSourceObject((Object)this.createSeriesSource());
                this.dc.addPlane((PrimitiveRenderEvent)this.pre, 2);
            }
        }
    }

    private static class AreaDataPointsRenderer2DStacked
    extends AreaDataPointsRenderer2D {
        protected Location[] loaLast;

        AreaDataPointsRenderer2DStacked(Line.DataPointsRenderer.Context context, Location[] loa) throws ChartException {
            super(context, loa);
        }

        protected void fixPoint(int index) {
            if (this.loaLast == null) {
                this.trans.setY(this.loa[index], this.zeroLocation);
            } else {
                this.trans.setY(this.loa[index], this.trans.getY(this.loaLast[index]));
            }
        }

        protected void loadLastStates() {
            Object obj = this.context.line.getRunTimeContext().getState((Object)"stacked_series_location_key");
            if (obj instanceof Location[]) {
                this.loaLast = (Location[])obj;
            } else if (obj instanceof List) {
                List lst = (List)obj;
                Location[] last = new Location[lst.size()];
                int i = 0;
                while (i < lst.size()) {
                    Object o = lst.get(i);
                    if (o instanceof double[]) {
                        last[i] = goFactory.createLocation(((double[])o)[0], ((double[])o)[1]);
                    }
                    ++i;
                }
                this.loaLast = last;
            }
        }

        protected void saveStates() {
            if (this.context.line.isLastRuntimeSeriesInAxis()) {
                this.context.line.getRunTimeContext().putState((Object)"stacked_series_location_key", null);
            } else {
                ArrayList<double[]> list = new ArrayList<double[]>();
                Location[] locationArray = this.loa;
                int n = this.loa.length;
                int n2 = 0;
                while (n2 < n) {
                    Location lo = locationArray[n2];
                    double[] l = new double[]{lo.getX(), lo.getY()};
                    list.add(l);
                    ++n2;
                }
                this.context.line.getRunTimeContext().putState((Object)"stacked_series_location_key", list);
            }
        }

        protected void beforeLoop(Line.DataPointsSeeker seeker) {
            this.loadLastStates();
            int findex = seeker.getIndex();
            if (seeker.isNull()) {
                this.fixPoint(findex);
            }
            this.addPolygonPoint(this.loa[findex]);
        }

        protected void processDataPoint(Line.DataPointsSeeker seeker) {
            int index = seeker.getIndex();
            if (seeker.isNull()) {
                this.fixPoint(index);
            }
            this.addPolygonPoint(this.loa[index]);
            this.drawFrontLine(index - 1, index);
        }

        protected void afterLoop(Line.DataPointsSeeker seeker) {
            if (this.loaLast != null) {
                int i = this.loaLast.length - 1;
                while (i >= 0) {
                    this.addPolygonPoint(this.loaLast[i]);
                    --i;
                }
            } else {
                Location pt = ((Location)this.lstPolygon.get(this.lstPolygon.size() - 1)).copyInstance();
                this.trans.setY(pt, this.zeroLocation);
                this.addPolygonPoint(pt);
                pt = ((Location)this.lstPolygon.get(0)).copyInstance();
                this.trans.setY(pt, this.zeroLocation);
                this.addPolygonPoint(pt);
            }
            this.fillPolygon();
            this.saveStates();
        }
    }

    private static class AreaDataPointsRenderer2Dplus
    extends AreaDataPointsRenderer2DStacked {
        protected final int iSeriesIndex;
        private final double dTapeWidth;
        private final ColorDefinition tapeColor;
        private final ColorDefinition sideColor;
        private final Location[] loaPlane = Area.createLocationArray(4);
        private Envelop[] envelops;

        AreaDataPointsRenderer2Dplus(Line.DataPointsRenderer.Context context, Location[] loa) throws ChartException {
            super(context, loa);
            this.iSeriesIndex = context.line.getSeriesIndex();
            this.dTapeWidth = this.srh.getSeriesThickness();
            Fill paletteEntry = context.paletteEntry;
            ColorDefinition tapeColor = FillUtil.getBrighterColor((Fill)paletteEntry);
            ColorDefinition sideColor = FillUtil.getDarkerColor((Fill)paletteEntry);
            if (this.ls.isTranslucent()) {
                tapeColor = tapeColor.translucent();
                sideColor = sideColor.translucent();
            }
            this.tapeColor = tapeColor;
            this.sideColor = sideColor;
        }

        private void fillLeftSide(int findex) {
            double lastLocation;
            int index = findex;
            double x = this.loa[index].getX();
            double y = this.loa[index].getY();
            this.loaPlane[0].set(x, y);
            this.loaPlane[1].set(x + this.dTapeWidth, y - this.dTapeWidth);
            double d = lastLocation = this.loaLast == null ? this.zeroLocation : this.trans.getY(this.loaLast[index]);
            if (this.trans == Line.Transposition.TRANSPOSED) {
                this.loaPlane[2].set(lastLocation + this.dTapeWidth, y - this.dTapeWidth);
                this.loaPlane[3].set(lastLocation, y);
            } else {
                this.loaPlane[2].set(x + this.dTapeWidth, lastLocation - this.dTapeWidth);
                this.loaPlane[3].set(x, lastLocation);
            }
            this.pre.setOutline(null);
            this.pre.setBackground((Fill)this.sideColor);
            this.pre.setPoints(this.loaPlane);
            this.dc.addPlaneShadow((PrimitiveRenderEvent)this.pre, 2);
        }

        private void fillRightSide(int lindex) {
            double lastLocation;
            int index = lindex;
            double x = this.loa[index].getX();
            double y = this.loa[index].getY();
            this.loaPlane[0].set(x, y);
            this.loaPlane[1].set(x + this.dTapeWidth, y - this.dTapeWidth);
            double d = lastLocation = this.loaLast == null ? this.zeroLocation : this.trans.getY(this.loaLast[this.loaLast.length - (this.loa.length - index)]);
            if (this.trans == Line.Transposition.TRANSPOSED) {
                this.loaPlane[2].set(lastLocation + this.dTapeWidth, y - this.dTapeWidth);
                this.loaPlane[3].set(lastLocation, y);
            } else {
                this.loaPlane[2].set(x + this.dTapeWidth, lastLocation - this.dTapeWidth);
                this.loaPlane[3].set(x, lastLocation);
            }
            this.pre.setOutline(null);
            this.pre.setBackground((Fill)this.sideColor);
            this.pre.setPoints(this.loaPlane);
            this.pre.setSourceObject((Object)this.createDataPointSource(index));
            this.dc.addPlane((PrimitiveRenderEvent)this.pre, 2);
        }

        protected void beforeLoop(Line.DataPointsSeeker seeker) {
            super.beforeLoop(seeker);
            if (this.context.line.isRightToLeft() && this.context.dpha[0].getOrthogonalValue() != null) {
                this.fillLeftSide(seeker.getIndex());
            }
        }

        protected void processDataPoint(Line.DataPointsSeeker seeker) {
            boolean isTransposed;
            super.processDataPoint(seeker);
            int index = seeker.getIndex();
            int pindex = seeker.getPrevIndex();
            double loX = this.loa[index].getX();
            double loY = this.loa[index].getY();
            double loXp = this.loa[pindex].getX();
            double loYp = this.loa[pindex].getY();
            if (this.envelops == null) {
                this.envelops = new Envelop[seeker.size()];
            }
            boolean bl = isTransposed = this.trans == Line.Transposition.TRANSPOSED;
            if (this.trans == Line.Transposition.TRANSPOSED) {
                if (this.envelops[index] == null) {
                    this.envelops[index] = new Envelop(loYp, loY, this.zeroLocation, isTransposed);
                }
                this.envelops[index].addLine(this.iSeriesIndex, loXp, loX);
            } else {
                if (this.envelops[index] == null) {
                    this.envelops[index] = new Envelop(loXp, loX, this.zeroLocation, isTransposed);
                }
                this.envelops[index].addLine(this.iSeriesIndex, loYp, loY);
            }
            List<Location[]> tops = this.envelops[index].getTopChanges(this.iSeriesIndex, this.dTapeWidth);
            for (Location[] polygon : tops) {
                this.pre.setOutline(null);
                this.pre.setBackground((Fill)this.tapeColor);
                this.pre.setPoints(polygon);
                this.pre.setSourceObject((Object)this.createDataPointSource(index));
                this.dc.addPlaneShadow((PrimitiveRenderEvent)this.pre, 2, this.context.dpha.length + index);
            }
            List<Location[]> bottoms = this.envelops[index].getBottomChanges(this.iSeriesIndex, this.dTapeWidth);
            for (Location[] polygon : bottoms) {
                this.pre.setOutline(null);
                this.pre.setBackground((Fill)this.tapeColor);
                this.pre.setPoints(polygon);
                this.pre.setSourceObject((Object)this.createDataPointSource(index));
                this.dc.addPlaneShadow((PrimitiveRenderEvent)this.pre, 2, index);
            }
        }

        protected void afterLoop(Line.DataPointsSeeker seeker) {
            if (!this.context.line.isRightToLeft() && this.context.dpha[seeker.size() - 1].getOrthogonalValue() != null) {
                this.fillRightSide(seeker.getIndex());
            }
            super.afterLoop(seeker);
        }

        protected void loadLastStates() {
            super.loadLastStates();
            this.envelops = (Envelop[])this.context.line.getRunTimeContext().getState((Object)Area.AREA_ENVELOPS);
        }

        protected void saveStates() {
            RunTimeContext rtc = this.context.line.getRunTimeContext();
            if (this.context.line.isLastRuntimeSeriesInAxis()) {
                rtc.putState((Object)"stacked_series_location_key", null);
                rtc.putState((Object)Area.AREA_ENVELOPS, null);
            } else {
                ArrayList<double[]> list = new ArrayList<double[]>();
                Location[] locationArray = this.loa;
                int n = this.loa.length;
                int n2 = 0;
                while (n2 < n) {
                    Location lo = locationArray[n2];
                    double[] l = new double[]{lo.getX(), lo.getY()};
                    list.add(l);
                    ++n2;
                }
                rtc.putState((Object)"stacked_series_location_key", list);
                rtc.putState((Object)Area.AREA_ENVELOPS, (Object)this.envelops);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Envelop {
            protected static final IGObjectFactory _goFactory = GObjectFactory.instance();
            private List<IndexedPoint> top = new ArrayList<IndexedPoint>();
            private List<IndexedPoint> bottom = new ArrayList<IndexedPoint>();
            private double baseStart;
            private double baseEnd;
            private boolean bTransposed;

            public Envelop(double baseStart, double baseEnd, double zeroLocation, boolean bTransposed) {
                this.bTransposed = bTransposed;
                this.baseStart = baseStart;
                this.baseEnd = baseEnd;
                IndexedPoint ipt0 = new IndexedPoint(0, baseStart, zeroLocation);
                IndexedPoint ipt1 = new IndexedPoint(0, baseEnd, zeroLocation);
                this.top.add(ipt0);
                this.top.add(ipt1);
                IndexedPoint ipt2 = ipt0.copy();
                IndexedPoint ipt3 = ipt1.copy();
                this.bottom.add(ipt2);
                this.bottom.add(ipt3);
            }

            private List<IndexedPoint> merge(List<IndexedPoint> list, int index, StraightLine sl, boolean bLessThan) {
                int len = list.size();
                if (len < 2) {
                    return list;
                }
                ArrayList<IndexedPoint> list_new = new ArrayList<IndexedPoint>();
                IndexedPoint ipt0 = list.get(0);
                int i = 1;
                while (i < len) {
                    boolean bUpdate0;
                    IndexedPoint ipt1 = list.get(i);
                    double y0 = sl.getYfromX(ipt0.getX());
                    double y1 = sl.getYfromX(ipt1.getX());
                    boolean bl = bLessThan ? y0 < ipt0.getY() : (bUpdate0 = y0 > ipt0.getY());
                    boolean bUpdate1 = bLessThan ? y1 < ipt1.getY() : y1 > ipt1.getY();
                    Point pt = sl.getCrossPoint(ipt0.pt, ipt1.pt);
                    IndexedPoint ipn = new IndexedPoint(bUpdate0 ? ipt0.index : index, pt);
                    if (i == 1) {
                        if (bUpdate0) {
                            ipt0.index = index;
                            ipt0.setY(y0);
                        }
                        list_new.add(ipt0);
                    } else if (!bUpdate0) {
                        list_new.add(ipt0);
                    }
                    if (pt != null) {
                        list_new.add(ipn);
                    }
                    if (i == len - 1) {
                        if (bUpdate1) {
                            ipt1.setY(y1);
                        }
                        list_new.add(ipt1);
                    }
                    ipt0 = ipt1;
                    ++i;
                }
                return list_new;
            }

            private void mergeTop(int index, StraightLine sl) {
                this.top = this.merge(this.top, index, sl, !this.bTransposed);
            }

            private void mergeBottom(int index, StraightLine sl) {
                this.bottom = this.merge(this.bottom, index, sl, this.bTransposed);
            }

            public static Location[] createPolygonFromLine(double x0, double y0, double x1, double y1, double dTapeWidth) {
                Location[] loa = new Location[]{_goFactory.createLocation(x0, y0), _goFactory.createLocation(x1, y1), _goFactory.createLocation(x1 + dTapeWidth, y1 - dTapeWidth), _goFactory.createLocation(x0 + dTapeWidth, y0 - dTapeWidth)};
                return loa;
            }

            public List<Location[]> getTopChanges(int index, double dTapeWidth) {
                ArrayList<Location[]> list = new ArrayList<Location[]>();
                int len = this.top.size();
                IndexedPoint[] top_a = new IndexedPoint[len];
                top_a = this.top.toArray(top_a);
                if (len > 0) {
                    int i = 1;
                    while (i < len) {
                        IndexedPoint ipt0 = top_a[i - 1];
                        IndexedPoint ipt1 = top_a[i];
                        if (ipt0.index == index - 1 || ipt0.index == index) {
                            Location[] loa;
                            if (!this.bTransposed) {
                                loa = Envelop.createPolygonFromLine(ipt0.getX(), ipt0.getY(), ipt1.getX(), ipt1.getY(), dTapeWidth);
                                list.add(loa);
                            } else {
                                loa = Envelop.createPolygonFromLine(ipt0.getY(), ipt0.getX(), ipt1.getY(), ipt1.getX(), dTapeWidth);
                                list.add(loa);
                            }
                        }
                        ++i;
                    }
                }
                return list;
            }

            public List<Location[]> getBottomChanges(int index, double dTapeWidth) {
                ArrayList<Location[]> list = new ArrayList<Location[]>();
                int len = this.bottom.size();
                IndexedPoint[] bottom_a = new IndexedPoint[len];
                bottom_a = this.bottom.toArray(bottom_a);
                if (len > 0) {
                    int i = 1;
                    while (i < len) {
                        IndexedPoint ipt0 = bottom_a[i - 1];
                        IndexedPoint ipt1 = bottom_a[i];
                        if (ipt0.index == index - 1 || ipt0.index == index) {
                            Location[] loa;
                            if (!this.bTransposed) {
                                loa = Envelop.createPolygonFromLine(ipt0.getX(), ipt0.getY(), ipt1.getX(), ipt1.getY(), dTapeWidth);
                                list.add(loa);
                            } else {
                                loa = Envelop.createPolygonFromLine(ipt0.getY(), ipt0.getX(), ipt1.getY(), ipt1.getX(), dTapeWidth);
                                list.add(loa);
                            }
                        }
                        ++i;
                    }
                }
                return list;
            }

            public void addLine(int index, double valueStart, double valueEnd) {
                StraightLine sl = new StraightLine(this.baseStart, valueStart, this.baseEnd, valueEnd);
                this.mergeTop(index, sl);
                this.mergeBottom(index, sl);
            }

            private static class IndexedPoint {
                public int index;
                public Point pt;

                public IndexedPoint(int index, double x, double y) {
                    this.index = index;
                    this.pt = new Point(x, y);
                }

                public IndexedPoint(int index, Point pt) {
                    this.index = index;
                    this.pt = pt;
                }

                public IndexedPoint copy() {
                    return new IndexedPoint(this.index, this.pt.x, this.pt.y);
                }

                public double getX() {
                    return this.pt.getX();
                }

                public double getY() {
                    return this.pt.getY();
                }

                public void setY(double y) {
                    this.pt.setY(y);
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder("[");
                    sb.append(this.index);
                    sb.append(", ");
                    sb.append(this.pt.x);
                    sb.append(", ");
                    sb.append(this.pt.y);
                    sb.append("]");
                    return sb.toString();
                }
            }
        }

        private static class StraightLine {
            private double x0;
            private double y0;
            private double k;

            public StraightLine(double x0, double y0, double x1, double y1) {
                this.x0 = x0;
                this.y0 = y0;
                this.k = (y1 - y0) / (x1 - x0);
            }

            public Point getCrossPoint(Point pt0, Point pt1) {
                Point pt = null;
                double xst = pt0.x;
                double yst0 = pt0.y;
                double yst1 = this.getYfromX(xst);
                double xed = pt1.x;
                double yed0 = pt1.y;
                double yed1 = this.getYfromX(xed);
                if (xed != xst) {
                    if ((yst0 - yst1) * (yed0 - yed1) < 0.0) {
                        double x;
                        double y;
                        if (yed1 != yst1) {
                            double rate = (yed0 - yst0) / (yed1 - yst1);
                            y = (yst0 - rate * yst1) / (1.0 - rate);
                            x = this.getXfromY(y);
                        } else {
                            y = yst1;
                            double rate = (xed - xst) / (yed0 - yst0);
                            x = xst + rate * (y - yst0);
                        }
                        pt = new Point(x, y);
                    } else if (yst0 == yst1) {
                        pt = new Point(xst, yst0);
                    } else if (yed0 == yed1) {
                        pt = new Point(xed, yed0);
                    } else if (yst0 == yed0 && this.k != 0.0) {
                        double y = yst0;
                        double x = this.getXfromY(y);
                        pt = new Point(x, y);
                    }
                }
                if (pt != null && (pt.x < Math.min(pt0.x, pt1.x) || pt.x > Math.max(pt0.x, pt1.x))) {
                    pt = null;
                }
                return pt;
            }

            public double getYfromX(double x) {
                return this.y0 + this.k * (x - this.x0);
            }

            public double getXfromY(double y) {
                return this.x0 + (y - this.y0) / this.k;
            }
        }
    }

    private static class AreaDataPointsRenderer3D
    extends AreaDataPointsRenderer {
        private final SeriesRenderingHints3D srh3d;
        private final Location3D[] loa3d;
        private final Location3D loStart = Area.access$0().createLocation3D(0.0, 0.0, 0.0);
        private final Location3D loEnd = Area.access$0().createLocation3D(0.0, 0.0, 0.0);
        private final Location3D[] loaPlane3d = Area.createLocation3DArray(4);
        private final Polygon3DRenderEvent pre3d;
        private final Line3DRenderEvent lre3d;
        private final double dTapeWidth;
        private final ColorDefinition tapeColor;
        private final ColorDefinition sideColor;
        private final double plotBaseLocation;
        private final double plotHeight;
        private int findex;

        AreaDataPointsRenderer3D(Line.DataPointsRenderer.Context context, Location[] loa, double dTapeWidth) throws ChartException {
            super(context);
            StructureSource sourceObj = this.createSeriesSource();
            this.pre3d = (Polygon3DRenderEvent)((EventObjectCache)context.ipr).getEventObject((Object)sourceObj, Polygon3DRenderEvent.class);
            this.lre3d = (Line3DRenderEvent)((EventObjectCache)context.ipr).getEventObject((Object)sourceObj, Line3DRenderEvent.class);
            this.lre3d.setLineAttributes(this.lia);
            this.srh3d = (SeriesRenderingHints3D)context.isrh;
            this.plotBaseLocation = this.srh3d.getPlotBaseLocation();
            this.plotHeight = this.srh3d.getPlotHeight();
            this.loa3d = (Location3D[])loa;
            this.dTapeWidth = dTapeWidth;
            Fill paletteEntry = context.paletteEntry;
            ColorDefinition tapeColor = FillUtil.getBrighterColor((Fill)paletteEntry);
            ColorDefinition sideColor = FillUtil.getDarkerColor((Fill)paletteEntry);
            if (this.ls.isTranslucent()) {
                tapeColor = tapeColor.translucent();
                sideColor = sideColor.translucent();
            }
            this.tapeColor = tapeColor;
            this.sideColor = sideColor;
        }

        private static double shear(double plotBase, double plotHeight, double y) {
            if (y < plotBase) {
                y = plotBase;
            }
            if (y > plotBase + plotHeight) {
                y = plotBase + plotHeight;
            }
            return y;
        }

        private void fillBackPlane(int pindex, int index, Line.DataPointsSeeker seeker) throws ChartException {
            double x0 = this.loa3d[pindex].getX();
            double y0 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[pindex].getY());
            double z0 = this.loa3d[pindex].getZ();
            double x1 = this.loa3d[index].getX();
            double y1 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[index].getY());
            double z1 = this.loa3d[index].getZ();
            Double pValue = Methods.asDouble((Object)seeker.getDataPointHints(pindex).getOrthogonalValue());
            Double value = Methods.asDouble((Object)seeker.getDataPointHints(index).getOrthogonalValue());
            StructureSource source = this.createDataPointSource(index);
            if (this.zeroLocation <= y0) {
                if (pValue != null && value != null && pValue * value < 0.0) {
                    double rate = (0.0 - pValue) / (value - pValue);
                    double midX = x0 + (x1 - x0) * rate;
                    double midY = y0 + (y1 - y0) * rate;
                    Location3D[] loc = Area.createLocation3DArray(3);
                    loc[0].set(x0, y0, z0 - this.dTapeWidth);
                    loc[1].set(midX, midY, z0 - this.dTapeWidth);
                    loc[2].set(x0, midY, z0 - this.dTapeWidth);
                    this.fill3DPlane(this.fillColor, source, loc, false);
                    loc[0].set(midX, midY, z1 - this.dTapeWidth);
                    loc[1].set(x1, midY, z1 - this.dTapeWidth);
                    loc[2].set(x1, y1, z1 - this.dTapeWidth);
                    this.fill3DPlane(this.fillColor, source, loc, false);
                } else {
                    this.loaPlane3d[0].set(x0, y0, z0 - this.dTapeWidth);
                    this.loaPlane3d[1].set(x1, y1, z1 - this.dTapeWidth);
                    this.loaPlane3d[2].set(x1, this.zeroLocation, z1 - this.dTapeWidth);
                    this.loaPlane3d[3].set(x0, this.zeroLocation, z0 - this.dTapeWidth);
                    this.fill3DPlane(this.fillColor, source, false);
                }
            } else if (pValue != null && value != null && pValue * value < 0.0) {
                double rate = (0.0 - pValue) / (value - pValue);
                double midX = x0 + (x1 - x0) * rate;
                double midY = y0 + (y1 - y0) * rate;
                Location3D[] loc = Area.createLocation3DArray(3);
                loc[0].set(x0, midY, z0 - this.dTapeWidth);
                loc[1].set(midX, midY, z0 - this.dTapeWidth);
                loc[2].set(x0, y0, z0 - this.dTapeWidth);
                this.fill3DPlane(this.fillColor, source, loc, false);
                loc[0].set(midX, midY, z1 - this.dTapeWidth);
                loc[1].set(x1, y1, z1 - this.dTapeWidth);
                loc[2].set(x1, midY, z1 - this.dTapeWidth);
                this.fill3DPlane(this.fillColor, source, loc, false);
            } else {
                this.loaPlane3d[0].set(x0, this.zeroLocation, z0 - this.dTapeWidth);
                this.loaPlane3d[1].set(x1, this.zeroLocation, z1 - this.dTapeWidth);
                this.loaPlane3d[2].set(x1, y1, z1 - this.dTapeWidth);
                this.loaPlane3d[3].set(x0, y0, z0 - this.dTapeWidth);
                this.fill3DPlane(this.fillColor, source, false);
            }
        }

        private Object fillFrontPlane(int pindex, int index, Line.DataPointsSeeker seeker) throws ChartException {
            double x0 = this.loa3d[pindex].getX();
            double y0 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[pindex].getY());
            double z0 = this.loa3d[pindex].getZ();
            double x1 = this.loa3d[index].getX();
            double y1 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[index].getY());
            double z1 = this.loa3d[index].getZ();
            Double pValue = Methods.asDouble((Object)seeker.getDataPointHints(pindex).getOrthogonalValue());
            Double value = Methods.asDouble((Object)seeker.getDataPointHints(index).getOrthogonalValue());
            StructureSource source = this.createDataPointSource(index);
            if (this.zeroLocation <= y0) {
                if (pValue != null && value != null && pValue * value < 0.0) {
                    double rate = (0.0 - pValue) / (value - pValue);
                    double midX = x0 + (x1 - x0) * rate;
                    double midY = y0 + (y1 - y0) * rate;
                    Location3D[] loc = Area.createLocation3DArray(3);
                    loc[0].set(x0, y0, z0);
                    loc[1].set(midX + 1.0, midY, z0);
                    loc[2].set(x0, midY, z0);
                    this.fill3DPlane(this.fillColor, source, loc, true);
                    loc[0].set(midX, midY, z1);
                    loc[1].set(x1, midY, z1);
                    loc[2].set(x1, y1, z1);
                    return this.fill3DPlane(this.fillColor, source, loc, true);
                }
                this.loaPlane3d[0].set(x0, y0, z0);
                this.loaPlane3d[1].set(x0, this.zeroLocation, z0);
                this.loaPlane3d[2].set(x1, this.zeroLocation, z1);
                this.loaPlane3d[3].set(x1, y1, z1);
                return this.fill3DPlane(this.fillColor, source, false);
            }
            if (pValue != null && value != null && pValue * value < 0.0) {
                double rate = (0.0 - pValue) / (value - pValue);
                double midX = x0 + (x1 - x0) * rate;
                double midY = y0 + (y1 - y0) * rate;
                Location3D[] loc = Area.createLocation3DArray(3);
                loc[0].set(x0, midY, z0);
                loc[1].set(midX + 1.0, midY, z0);
                loc[2].set(x0, y0, z0);
                this.fill3DPlane(this.fillColor, source, loc, true);
                loc[0].set(midX, midY, z1);
                loc[1].set(x1, y1, z1);
                loc[2].set(x1, midY, z1);
                return this.fill3DPlane(this.fillColor, source, loc, true);
            }
            this.loaPlane3d[0].set(x0, this.zeroLocation, z0);
            this.loaPlane3d[1].set(x0, y0, z0);
            this.loaPlane3d[2].set(x1, y1, z1);
            this.loaPlane3d[3].set(x1, this.zeroLocation, z1);
            return this.fill3DPlane(this.fillColor, source, false);
        }

        private void fillLeftSidePlane(int findex) throws ChartException {
            double x = this.loa3d[findex].getX();
            double y = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[findex].getY());
            double z = this.loa3d[findex].getZ();
            if (this.zeroLocation < this.loa3d[findex].getY()) {
                this.loaPlane3d[0].set(x, y, z);
                this.loaPlane3d[1].set(x, y, z - this.dTapeWidth);
                this.loaPlane3d[2].set(x, this.zeroLocation, z - this.dTapeWidth);
                this.loaPlane3d[3].set(x, this.zeroLocation, z);
            } else {
                this.loaPlane3d[0].set(x, y, z);
                this.loaPlane3d[1].set(x, this.zeroLocation, z);
                this.loaPlane3d[2].set(x, this.zeroLocation, z - this.dTapeWidth);
                this.loaPlane3d[3].set(x, y, z - this.dTapeWidth);
            }
            this.fill3DPlane((Fill)this.tapeColor, this.createSeriesSource(), false);
        }

        private void fillRightSidePlane(int lindex) throws ChartException {
            double x = this.loa3d[lindex].getX();
            double y = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[lindex].getY());
            double z = this.loa3d[lindex].getZ();
            if (AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[lindex].getY()) > this.zeroLocation) {
                this.loaPlane3d[0].set(x, y, z);
                this.loaPlane3d[1].set(x, this.zeroLocation, z);
                this.loaPlane3d[2].set(x, this.zeroLocation, z - this.dTapeWidth);
                this.loaPlane3d[3].set(x, y, z - this.dTapeWidth);
            } else {
                this.loaPlane3d[0].set(x, y, z);
                this.loaPlane3d[1].set(x, y, z - this.dTapeWidth);
                this.loaPlane3d[2].set(x, this.zeroLocation, z - this.dTapeWidth);
                this.loaPlane3d[3].set(x, this.zeroLocation, z);
            }
            this.fill3DPlane((Fill)this.sideColor, this.createDataPointSource(lindex), false);
        }

        private void fillBottomPlane(int findex, int lindex, Line.DataPointsSeeker seeker) throws ChartException {
            Double pValue = Methods.asDouble((Object)seeker.getDataPointHints(findex).getOrthogonalValue());
            Double value = Methods.asDouble((Object)seeker.getDataPointHints(lindex).getOrthogonalValue());
            if (pValue != null && value != null && pValue * value < 0.0) {
                double x0 = this.loa3d[findex].getX();
                double y0 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[findex].getY());
                double z0 = this.loa3d[findex].getZ();
                double x1 = this.loa3d[lindex].getX();
                double y1 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[lindex].getY());
                double z1 = this.loa3d[lindex].getZ();
                boolean up = y0 < y1;
                double rate = (0.0 - pValue) / (value - pValue);
                x1 = x0 + (x1 - x0) * rate;
                y1 = y0 + (y1 - y0) * rate;
                this.fillBottomPlane(x0, z0, x1, z1, up);
                x0 = x1;
                y0 = y1;
                z0 = this.loa3d[findex].getZ();
                x1 = this.loa3d[lindex].getX();
                y1 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[lindex].getY());
                z1 = this.loa3d[lindex].getZ();
                this.fillBottomPlane(x0, z0, x1, z1, !up);
            } else {
                double x0 = this.loa3d[findex].getX();
                double z0 = this.loa3d[findex].getZ();
                double x1 = this.loa3d[lindex].getX();
                double z1 = this.loa3d[lindex].getZ();
                this.fillBottomPlane(x0, z0, x1, z1, true);
            }
        }

        private void fillBottomPlane(double x0, double z0, double x1, double z1, boolean bDoubleSided) throws ChartException {
            this.loaPlane3d[0].set(x0, this.zeroLocation, z0);
            this.loaPlane3d[1].set(x0, this.zeroLocation, z0 - this.dTapeWidth);
            this.loaPlane3d[2].set(x1, this.zeroLocation, z1 - this.dTapeWidth);
            this.loaPlane3d[3].set(x1, this.zeroLocation, z1);
            this.fill3DPlane(this.fillColor, this.createSeriesSource(), bDoubleSided);
        }

        private void fillTopPlane(int pindex, int index, Line.DataPointsSeeker seeker) throws ChartException {
            Double pValue = Methods.asDouble((Object)seeker.getDataPointHints(pindex).getOrthogonalValue());
            Double value = Methods.asDouble((Object)seeker.getDataPointHints(index).getOrthogonalValue());
            if (pValue != null && value != null && pValue * value < 0.0) {
                double x0 = this.loa3d[pindex].getX();
                double y0 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[pindex].getY());
                double z0 = this.loa3d[pindex].getZ();
                double x1 = this.loa3d[index].getX();
                double y1 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[index].getY());
                double z1 = this.loa3d[index].getZ();
                double rate = (0.0 - pValue) / (value - pValue);
                x1 = x0 + (x1 - x0) * rate;
                y1 = y0 + (y1 - y0) * rate;
                this.loaPlane3d[0].set(x0, y0, z0);
                this.loaPlane3d[1].set(x1, y1, z1);
                this.loaPlane3d[2].set(x1, y1, z1 - this.dTapeWidth);
                this.loaPlane3d[3].set(x0, y0, z0 - this.dTapeWidth);
                this.fill3DPlane((Fill)this.tapeColor, this.createDataPointSource(index), true);
                x0 = x1;
                y0 = y1;
                z0 = this.loa3d[this.findex].getZ();
                x1 = this.loa3d[index].getX();
                y1 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[index].getY());
                z1 = this.loa3d[index].getZ();
                this.loaPlane3d[0].set(x0, y0, z0);
                this.loaPlane3d[1].set(x1, y1, z1);
                this.loaPlane3d[2].set(x1, y1, z1 - this.dTapeWidth);
                this.loaPlane3d[3].set(x0, y0, z0 - this.dTapeWidth);
                this.fill3DPlane((Fill)this.tapeColor, this.createDataPointSource(index), true);
            } else {
                double x0 = this.loa3d[pindex].getX();
                double y0 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[pindex].getY());
                double z0 = this.loa3d[pindex].getZ();
                double x1 = this.loa3d[index].getX();
                double y1 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[index].getY());
                double z1 = this.loa3d[index].getZ();
                this.loaPlane3d[0].set(x0, y0, z0);
                this.loaPlane3d[1].set(x1, y1, z1);
                this.loaPlane3d[2].set(x1, y1, z1 - this.dTapeWidth);
                this.loaPlane3d[3].set(x0, y0, z0 - this.dTapeWidth);
                this.fill3DPlane((Fill)this.tapeColor, this.createDataPointSource(index), false);
            }
        }

        private Object fill3DPlane(Fill fillColor, Object sourceObj, boolean bDoubleSided) throws ChartException {
            this.pre3d.setDoubleSided(bDoubleSided);
            this.pre3d.setOutline(null);
            this.pre3d.setPoints3D(this.loaPlane3d);
            this.pre3d.setBackground(fillColor);
            this.pre3d.setSourceObject(sourceObj);
            Object event = this.dc.addPlane((PrimitiveRenderEvent)this.pre3d, 2);
            this.pre3d.setDoubleSided(false);
            return event;
        }

        private Object fill3DPlane(Fill fillColor, Object sourceObj, Location3D[] loc, boolean bDoubleSided) throws ChartException {
            this.pre3d.setDoubleSided(bDoubleSided);
            this.pre3d.setOutline(null);
            this.pre3d.setPoints3D(loc);
            this.pre3d.setBackground(fillColor);
            this.pre3d.setSourceObject(sourceObj);
            Object event = this.dc.addPlane((PrimitiveRenderEvent)this.pre3d, 2);
            this.pre3d.setDoubleSided(false);
            return event;
        }

        private void drawFrontLine(int pindex, int index, Object eventFront) {
            if (!this.lia.isVisible()) {
                return;
            }
            double x0 = this.loa3d[pindex].getX();
            double y0 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[pindex].getY());
            double z0 = this.loa3d[pindex].getZ();
            double x1 = this.loa3d[index].getX();
            double y1 = AreaDataPointsRenderer3D.shear(this.plotBaseLocation, this.plotHeight, this.loa3d[index].getY());
            double z1 = this.loa3d[index].getZ();
            this.loStart.set(x0, y0, z0);
            this.loEnd.set(x1, y1, z1);
            this.lre3d.setStart3D(this.loStart);
            this.lre3d.setEnd3D(this.loEnd);
            AxesRenderHelper.addLine3DEvent((Line3DRenderEvent)this.lre3d, (Object)eventFront, (DeferredCache)this.dc);
        }

        protected double initZeroLocation(Line line, ISeriesRenderingHints isrh) throws ChartException {
            SeriesRenderingHints3D srh3d = (SeriesRenderingHints3D)isrh;
            return AreaDataPointsRenderer3D.shear(srh3d.getPlotBaseLocation(), srh3d.getPlotHeight(), srh3d.getPlotZeroLocation());
        }

        protected void afterLoop(Line.DataPointsSeeker seeker) throws ChartException {
            int lindex = seeker.getIndex();
            this.fillRightSidePlane(lindex);
        }

        protected void beforeLoop(Line.DataPointsSeeker seeker) throws ChartException {
            this.findex = seeker.getIndex();
            if (this.findex >= 0) {
                this.fillLeftSidePlane(this.findex);
            }
        }

        protected void processDataPoint(Line.DataPointsSeeker seeker) throws ChartException {
            int index = seeker.getIndex();
            int pindex = seeker.getPrevIndex();
            this.fillBackPlane(pindex, index, seeker);
            this.fillTopPlane(pindex, index, seeker);
            this.fillBottomPlane(pindex, index, seeker);
            Object eventFront = this.fillFrontPlane(pindex, index, seeker);
            this.drawFrontLine(pindex, index, eventFront);
        }
    }
}

