/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.SEIR;
import org.eclipse.stem.diseasemodels.standard.SI;
import org.eclipse.stem.diseasemodels.standard.SIR;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.StandardStochasticDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StochasticDiseaseModel;
import org.eclipse.stem.ui.adapters.diseasemodelpropertyeditor.DiseaseModelPropertyEditor;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class StandardDiseaseModelPropertyEditor
extends DiseaseModelPropertyEditor {
    public StandardDiseaseModelPropertyEditor(Composite parent, int style, DiseaseModel diseaseModel, ModifyListener projectValidator, IProject project) {
        super(parent, style, diseaseModel, projectValidator, project);
    }

    @Override
    public void populate(DiseaseModel diseaseModel) {
        StandardDiseaseModel model;
        super.populate(diseaseModel);
        if (diseaseModel instanceof StandardDiseaseModel) {
            model = (StandardDiseaseModel)diseaseModel;
            model.setReferencePopulationDensity(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_DISEASE_MODEL__REFERENCE_POPULATION_DENSITY)).getText()));
            model.setRoadNetworkInfectiousProportion(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION)).getText()));
            model.setCharacteristicMixingDistance(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE)).getText()));
        }
        if (diseaseModel instanceof StochasticDiseaseModel) {
            model = (StochasticDiseaseModel)diseaseModel;
            if (this.map.get(StandardPackage.Literals.STOCHASTIC_DISEASE_MODEL__SEED) != null) {
                model.setSeed(Long.parseLong(((Text)this.map.get(StandardPackage.Literals.STOCHASTIC_DISEASE_MODEL__SEED)).getText()));
            }
        }
        if (diseaseModel instanceof StandardStochasticDiseaseModel) {
            model = (StandardStochasticDiseaseModel)diseaseModel;
            if (this.map.get(StandardPackage.Literals.STANDARD_STOCHASTIC_DISEASE_MODEL__GAIN) != null) {
                model.setGain(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_STOCHASTIC_DISEASE_MODEL__GAIN)).getText()));
            }
        }
        if (diseaseModel instanceof SI) {
            model = (SI)diseaseModel;
            model.setTransmissionRate(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SI__TRANSMISSION_RATE)).getText()));
            model.setNonLinearityCoefficient(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SI__NON_LINEARITY_COEFFICIENT)).getText()));
            model.setRecoveryRate(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SI__RECOVERY_RATE)).getText()));
            model.setInfectiousMortalityRate(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SI__INFECTIOUS_MORTALITY_RATE)).getText()));
        }
        if (diseaseModel instanceof SIR) {
            model = (SIR)diseaseModel;
            model.setImmunityLossRate(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SIR__IMMUNITY_LOSS_RATE)).getText()));
        }
        if (diseaseModel instanceof SEIR) {
            model = (SEIR)diseaseModel;
            model.setIncubationRate(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SEIR__INCUBATION_RATE)).getText()));
        }
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Text text = (Text)this.map.get(StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE);
        if (text != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr24");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr25");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.STANDARD_DISEASE_MODEL__REFERENCE_POPULATION_DENSITY)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr26");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr27");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr28");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr29");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.STOCHASTIC_DISEASE_MODEL__SEED)) != null && text.getText().equals("")) {
            this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr30");
            return false;
        }
        text = (Text)this.map.get(StandardPackage.Literals.STANDARD_STOCHASTIC_DISEASE_MODEL__GAIN);
        if (text != null && text.getText().equals("")) {
            this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr31");
            return false;
        }
        text = (Text)this.map.get(StandardPackage.Literals.SI__TRANSMISSION_RATE);
        if (text != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr6");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr7");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.SI__NON_LINEARITY_COEFFICIENT)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr8");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr9");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.SI__RECOVERY_RATE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr10");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr11");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.SI__INFECTIOUS_MORTALITY_RATE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr12");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr13");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.SIR__IMMUNITY_LOSS_RATE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr16");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr17");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.SEIR__INCUBATION_RATE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr18");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr19");
                return false;
            }
        }
        return true;
    }
}

