/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;
import org.eclipse.team.internal.ui.dialogs.ResourceMappingHierarchyArea;

public class NoChangesDialog
extends DetailsDialog {
    private String message;
    private Label messageLabel;
    private Label imageLabel;
    private ResourceMappingHierarchyArea selectedMappingsArea;
    private final ISynchronizationScope scope;
    private final String description;

    public NoChangesDialog(Shell parentShell, String dialogTitle, String message, String description, ISynchronizationScope scope) {
        super(parentShell, dialogTitle);
        this.message = message;
        this.description = description;
        this.scope = scope;
    }

    @Override
    protected void initializeStyle() {
    }

    @Override
    protected Composite createDropDownDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.selectedMappingsArea = ResourceMappingHierarchyArea.create(this.scope, null);
        this.selectedMappingsArea.setDescription(this.description);
        this.selectedMappingsArea.createArea(composite);
        return composite;
    }

    @Override
    protected void createMainDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createMessageArea(composite);
    }

    @Override
    protected void updateEnablements() {
    }

    private Control createMessageArea(Composite composite) {
        Image image = this.getSWTImage(2);
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.imageLabel.setLayoutData((Object)new GridData(66));
        }
        if (this.message != null) {
            this.messageLabel = new Label(composite, 64);
            this.messageLabel.setText(this.message);
            GridData data = new GridData(770);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            this.messageLabel.setLayoutData((Object)data);
        }
        return composite;
    }

    private Image getSWTImage(final int imageID) {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = this.getParentShell();
        }
        final Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        final Image[] image = new Image[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                image[0] = display.getSystemImage(imageID);
            }
        });
        return image[0];
    }

    public boolean isHelpAvailable() {
        return false;
    }

    @Override
    protected boolean includeCancelButton() {
        return false;
    }

    public static void open(Shell shell, String title, String message, String description, ISynchronizationScope scope) {
        new NoChangesDialog(shell, title, message, description, scope).open();
    }
}

