/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script;

import com.ibm.icu.util.ULocale;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.script.IScriptContext;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class AbstractScriptHandler<T>
extends ScriptableObject {
    public static final String BEFORE_DATA_SET_FILLED = "beforeDataSetFilled";
    public static final String AFTER_DATA_SET_FILLED = "afterDataSetFilled";
    public static final String BEFORE_GENERATION = "beforeGeneration";
    public static final String AFTER_GENERATION = "afterGeneration";
    public static final String BEFORE_RENDERING = "beforeRendering";
    public static final String AFTER_RENDERING = "afterRendering";
    private static final long serialVersionUID = 1L;
    protected final transient Object[] ONE_ELEMENT_ARRAY = new Object[1];
    protected final transient Object[] TWO_ELEMENT_ARRAY = new Object[2];
    protected final transient Object[] THREE_ELEMENT_ARRAY = new Object[3];
    protected transient Scriptable scope = null;
    protected transient T javahandler = null;
    protected transient ULocale lcl = null;
    protected transient IScriptClassLoader iscl = null;
    protected transient List<String> javaScriptFunctionNamesCache = null;
    protected IScriptContext csc;

    public AbstractScriptHandler() {
        Context cx = Context.enter();
        try {
            this.scope = new ImporterTopLevel(cx);
        }
        finally {
            Context.exit();
        }
    }

    protected abstract ILogger getLogger();

    protected abstract Map<String, Method> getJavaFunctionMap();

    public final String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final Scriptable getScope() {
        return this.scope;
    }

    public final void setLocale(ULocale lcl) {
        this.lcl = lcl;
    }

    public final void setScriptClassLoader(IScriptClassLoader value) {
        this.iscl = value;
    }

    public final void init(Scriptable scPrototype) throws ChartException {
        Context cx = Context.enter();
        try {
            try {
                if (scPrototype == null) {
                    this.scope = new ImporterTopLevel(cx);
                } else {
                    this.scope = cx.newObject(scPrototype);
                    this.scope.setPrototype(scPrototype);
                }
                Object oConsole = Context.javaToJS((Object)this.getLogger(), (Scriptable)this.scope);
                this.scope.put("logger", this.scope, oConsole);
            }
            catch (RhinoException jsx) {
                throw this.convertException((Exception)((Object)jsx));
            }
        }
        finally {
            Context.exit();
        }
    }

    public final void registerExistingScriptableObject(ScriptableObject so, String sVarName) throws ChartException {
        try {
            ScriptableObject.defineClass((Scriptable)this.scope, so.getClass());
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        Context cx = Context.enter();
        Scriptable soNew = null;
        try {
            try {
                soNew = cx.newObject(this.scope, so.getClassName(), null);
            }
            catch (RhinoException ex) {
                throw this.convertException((Exception)((Object)ex));
            }
        }
        finally {
            Context.exit();
        }
        so.setPrototype(soNew.getPrototype());
        so.setParentScope(soNew.getParentScope());
        this.scope.put(sVarName, this.scope, (Object)so);
    }

    public final void registerNewScriptableObject(Class<? extends Scriptable> clsScriptable, String sVarName) throws ChartException {
        try {
            ScriptableObject.defineClass((Scriptable)this.scope, clsScriptable);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        Context cx = Context.enter();
        Scriptable soNew = null;
        try {
            try {
                soNew = cx.newObject(this.scope, clsScriptable.getName(), null);
            }
            catch (RuntimeException ex) {
                throw this.convertException(ex);
            }
        }
        finally {
            Context.exit();
        }
        this.scope.put(sVarName, this.scope, (Object)soNew);
    }

    public final void registerVariable(String sVarName, Object var) throws ChartException {
        Context.enter();
        try {
            Object oConsole = Context.javaToJS((Object)var, (Scriptable)this.scope);
            this.scope.put(sVarName, this.scope, oConsole);
        }
        finally {
            Context.exit();
        }
    }

    public final void unregisterVariable(String sVarName) throws ChartException {
        this.scope.delete(sVarName);
    }

    private final Function getJavascriptFunction(String sFunctionName) {
        if (this.javaScriptFunctionNamesCache == null || this.javaScriptFunctionNamesCache.indexOf(sFunctionName) < 0) {
            return null;
        }
        Context.enter();
        try {
            Object oFunction = this.scope.get(sFunctionName, this.scope);
            if (oFunction != Scriptable.NOT_FOUND && oFunction instanceof Function) {
                Function function = (Function)oFunction;
                return function;
            }
            return null;
        }
        finally {
            Context.exit();
        }
    }

    private final Object callJavaScriptFunction(Function f, Object[] oaArgs) throws ChartException {
        Context cx = Context.enter();
        Object oReturnValue = null;
        ClassLoader oldLoader = cx.getApplicationClassLoader();
        ClassLoader appLader = SecurityUtil.getClassLoader(((Object)((Object)this)).getClass());
        cx.setApplicationClassLoader(appLader);
        new CoreJavaScriptInitializer().initialize(cx, this.scope);
        try {
            try {
                oReturnValue = f.call(cx, this.scope, this.scope, oaArgs);
            }
            catch (RhinoException ex) {
                throw this.convertException((Exception)((Object)ex));
            }
        }
        finally {
            cx.setApplicationClassLoader(oldLoader);
            Context.exit();
        }
        return oReturnValue;
    }

    private final boolean isJavaFuntion(String name) {
        return this.getJavaFunctionMap().get(name) != null;
    }

    private final Object callJavaFunction(String name, Object[] oaArgs) {
        if (this.javahandler == null) {
            return null;
        }
        Object[] tmpArgs = new Object[3];
        if (oaArgs.length > 0) {
            tmpArgs[0] = oaArgs[0];
        }
        if (oaArgs.length > 1) {
            tmpArgs[1] = oaArgs[1];
        }
        if (oaArgs.length > 2) {
            tmpArgs[2] = oaArgs[2];
        }
        if (!this.callRegularJavaFunction(name, tmpArgs)) {
            Method mtd = this.getJavaFunctionMap().get(name);
            try {
                return SecurityUtil.invokeMethod(mtd, this.javahandler, oaArgs);
            }
            catch (Exception e) {
                this.getLogger().log(e);
            }
        }
        return null;
    }

    protected boolean callRegularJavaFunction(String functionName, Object[] arguments) {
        return false;
    }

    public static final Object callFunction(AbstractScriptHandler<?> sh, String sFunction, Object oArg1) throws ChartException {
        if (sh == null) {
            return null;
        }
        if (sh.javahandler != null && super.isJavaFuntion(sFunction)) {
            sh.ONE_ELEMENT_ARRAY[0] = oArg1;
            return super.callJavaFunction(sFunction, sh.ONE_ELEMENT_ARRAY);
        }
        Function f = super.getJavascriptFunction(sFunction);
        if (f != null) {
            sh.ONE_ELEMENT_ARRAY[0] = oArg1;
            Object oReturnValue = null;
            oReturnValue = super.callJavaScriptFunction(f, sh.ONE_ELEMENT_ARRAY);
            return oReturnValue;
        }
        return null;
    }

    public static final Object callFunction(AbstractScriptHandler<?> sh, String sFunction, Object oArg1, Object oArg2) throws ChartException {
        if (sh == null) {
            return null;
        }
        if (sh.javahandler != null && super.isJavaFuntion(sFunction)) {
            sh.TWO_ELEMENT_ARRAY[0] = oArg1;
            sh.TWO_ELEMENT_ARRAY[1] = oArg2;
            return super.callJavaFunction(sFunction, sh.TWO_ELEMENT_ARRAY);
        }
        Function f = super.getJavascriptFunction(sFunction);
        if (f != null) {
            sh.TWO_ELEMENT_ARRAY[0] = oArg1;
            sh.TWO_ELEMENT_ARRAY[1] = oArg2;
            Object oReturnValue = null;
            oReturnValue = super.callJavaScriptFunction(f, sh.TWO_ELEMENT_ARRAY);
            return oReturnValue;
        }
        return null;
    }

    public static final Object callFunction(AbstractScriptHandler<?> sh, String sFunction, Object oArg1, Object oArg2, Object oArg3) throws ChartException {
        if (sh == null) {
            return null;
        }
        if (sh.javahandler != null && super.isJavaFuntion(sFunction)) {
            sh.THREE_ELEMENT_ARRAY[0] = oArg1;
            sh.THREE_ELEMENT_ARRAY[1] = oArg2;
            sh.THREE_ELEMENT_ARRAY[2] = oArg3;
            return super.callJavaFunction(sFunction, sh.THREE_ELEMENT_ARRAY);
        }
        Function f = super.getJavascriptFunction(sFunction);
        if (f != null) {
            sh.THREE_ELEMENT_ARRAY[0] = oArg1;
            sh.THREE_ELEMENT_ARRAY[1] = oArg2;
            sh.THREE_ELEMENT_ARRAY[2] = oArg3;
            Object oReturnValue = null;
            oReturnValue = super.callJavaScriptFunction(f, sh.THREE_ELEMENT_ARRAY);
            return oReturnValue;
        }
        return null;
    }

    public final Object evaluate(String sScriptContent) throws ChartException {
        Context cx = Context.enter();
        try {
            Object object = cx.evaluateString(this.scope, sScriptContent, "<cmd>", 1, null);
            return object;
        }
        catch (RhinoException jsx) {
            throw this.convertException((Exception)((Object)jsx));
        }
        finally {
            Context.exit();
        }
    }

    public final void register(String sScriptName, String sScriptContent) throws ChartException {
        block17: {
            try {
                this.getLogger().log(1, Messages.getString("Info.try.load.java.handler"));
                Class handlerClass = null;
                try {
                    handlerClass = Class.forName(sScriptContent);
                }
                catch (ClassNotFoundException ex) {
                    if (this.iscl != null) {
                        handlerClass = this.iscl.loadClass(sScriptContent, SecurityUtil.getClassLoader(((Object)((Object)this)).getClass()));
                    }
                    throw ex;
                }
                if (this.getEventHandlerClass().isAssignableFrom(handlerClass)) {
                    try {
                        this.javahandler = SecurityUtil.newClassInstance(handlerClass);
                    }
                    catch (InstantiationException e) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 4, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 4, e);
                    }
                    this.getLogger().log(1, Messages.getString("Info.java.handler.loaded", handlerClass, ULocale.getDefault()));
                    break block17;
                }
                this.getLogger().log(2, Messages.getString("Info.invalid.java.handler", handlerClass, ULocale.getDefault()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.javahandler = null;
                this.getLogger().log(1, Messages.getString("Info.try.register.javascript.content"));
                Context cx = Context.enter();
                try {
                    try {
                        cx.evaluateString(this.scope, sScriptContent, sScriptName == null ? "<cmd>" : sScriptName, 1, null);
                        this.getLogger().log(1, Messages.getString("Info.javascript.content.registered"));
                        Object[] objs = this.scope.getIds();
                        if (objs != null) {
                            this.javaScriptFunctionNamesCache = new ArrayList<String>();
                            int i = 0;
                            while (i < objs.length) {
                                this.javaScriptFunctionNamesCache.add(String.valueOf(objs[i]));
                                ++i;
                            }
                        } else {
                            this.javaScriptFunctionNamesCache = null;
                        }
                    }
                    catch (RhinoException jsx) {
                        throw this.convertException((Exception)((Object)jsx));
                    }
                }
                finally {
                    Context.exit();
                }
            }
        }
    }

    protected abstract Class getEventHandlerClass();

    public void setScriptContext(IScriptContext csc) {
        this.csc = csc;
    }

    protected ChartException convertException(Exception ex) {
        if (ex instanceof RhinoException) {
            RhinoException e = (RhinoException)((Object)ex);
            String lineSource = e.lineSource();
            String details = e.details();
            String lineNumber = String.valueOf(e.lineNumber());
            if (lineSource == null) {
                lineSource = "";
            }
            return new ChartException("org.eclipse.birt.chart.engine", 12, "exception.javascript.error", new Object[]{details, lineNumber, lineSource}, Messages.getResourceBundle(this.csc.getULocale()), e);
        }
        return new ChartException("org.eclipse.birt.chart.engine", 12, ex);
    }
}

