/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.GraphPartitioner;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.jobs.execution.ExecutableManager;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.Messages;
import org.eclipse.stem.jobs.simulation.Simulation;
import org.eclipse.stem.jobs.simulation.SimulationCaching;

public class CustomSimulationManager
extends ExecutableManager {
    private static volatile CustomSimulationManager INSTANCE = null;
    private static int sequenceNumber = 0;
    public static final ISimulation[] NONE = new Simulation[0];
    private List<ISimulation> activeSimulations = new ArrayList<ISimulation>();

    private CustomSimulationManager() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("scenario", new XMIResourceFactoryImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final CustomSimulationManager getManager() {
        if (INSTANCE != null) return INSTANCE;
        Class<CustomSimulationManager> clazz = CustomSimulationManager.class;
        synchronized (CustomSimulationManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CustomSimulationManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static final synchronized int getAndIncrementSimulationSequenceNumber() {
        return sequenceNumber++;
    }

    public static final void resetSimulationManager() {
        INSTANCE = null;
        sequenceNumber = 0;
    }

    public final List<ISimulation> getActiveSimulations() {
        return this.activeSimulations;
    }

    private final void addActiveSimulation(ISimulation simulation) {
        this.activeSimulations.add(simulation);
    }

    public final void removeActiveSimulation(ISimulation simulation) {
        this.activeSimulations.remove(simulation);
    }

    public ISimulation createSimulation(Scenario scenario, IProgressMonitor monitor) {
        Simulation retValue = null;
        try {
            boolean useCache = false;
            Scenario simulationScenario = null;
            if (useCache) {
                if (SimulationCaching.INSTANCE.isScenarioInCache(scenario.getURI())) {
                    simulationScenario = SimulationCaching.INSTANCE.getCachedScenario(scenario.getURI());
                    boolean running = false;
                    for (ISimulation sim : this.getActiveSimulations()) {
                        if (!sim.getScenario().equals(simulationScenario)) continue;
                        Scenario newSimulation = null;
                        newSimulation = (Scenario)EcoreUtil.copy((EObject)simulationScenario);
                        if (simulationScenario.getModel() != null) {
                            newSimulation.setModel((Model)EcoreUtil.copy((EObject)simulationScenario.getModel()));
                        }
                        if (simulationScenario.getSequencer() != null) {
                            newSimulation.setSequencer((Sequencer)EcoreUtil.copy((EObject)simulationScenario.getSequencer()));
                        }
                        running = true;
                        break;
                    }
                    if (!running) {
                        simulationScenario.reset();
                    }
                } else {
                    SimulationCaching.INSTANCE.addScenarioToCache(scenario);
                }
            }
            if (scenario.getCanonicalGraph() == null) {
                scenario.initialize();
            } else {
                scenario.reset();
            }
            Simulation simulation = new Simulation(scenario, CustomSimulationManager.getAndIncrementSimulationSequenceNumber(), (GraphPartitioner)GraphFactory.eINSTANCE.createSimpleGraphPartitioner());
            simulation.setPriority(30);
            retValue = simulation;
            this.addActiveSimulation((ISimulation)retValue);
        }
        catch (ScenarioInitializationException se) {
            Simulation.handleException((ScenarioInitializationException)se, (boolean)true);
            retValue = null;
        }
        return retValue;
    }

    public void createAndRunSimulation(final Scenario scenario) {
        new Job(Messages.getString((String)"SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ISimulation simulation = CustomSimulationManager.this.createSimulation(scenario, monitor);
                    monitor.subTask(Messages.getString((String)"SimMgr.Run"));
                    simulation.run();
                }
                catch (Exception e) {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public ISimulation mapGraphToSimulation(Graph graph) {
        ISimulation retValue = null;
        for (ISimulation simulation : this.activeSimulations) {
            Graph simulationGraph = simulation.getScenario().getCanonicalGraph();
            if (graph != simulationGraph) continue;
            retValue = simulation;
            break;
        }
        return retValue;
    }
}

