/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.serializer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class SemanticSequencerExtensions {
    @Inject
    private IGrammarConstraintProvider gcp;

    public Map<IGrammarConstraintProvider.IConstraint, List<ISerializationContext>> getGrammarConstraints(Grammar grammar, EClass clazz) {
        LinkedHashMap result = CollectionLiterals.newLinkedHashMap();
        SerializationContextMap constraints = this.gcp.getConstraints(grammar);
        List _values = constraints.values();
        for (SerializationContextMap.Entry e : _values) {
            IGrammarConstraintProvider.IConstraint constraint = (IGrammarConstraintProvider.IConstraint)e.getValue();
            EClass _type = constraint.getType();
            boolean _tripleEquals = _type == clazz;
            if (!_tripleEquals) continue;
            List contexts = (List)result.get(constraint);
            if (contexts == null) {
                contexts = CollectionLiterals.newArrayList();
                result.put(constraint, contexts);
            }
            contexts.addAll(e.getContexts(clazz));
        }
        return result;
    }

    protected ResourceSet cloneResourceSet(ResourceSet rs) {
        XtextResourceSet result = new XtextResourceSet();
        result.setPackageRegistry(rs.getPackageRegistry());
        result.setResourceFactoryRegistry(rs.getResourceFactoryRegistry());
        result.setURIConverter(rs.getURIConverter());
        if (rs instanceof XtextResourceSet) {
            result.setClasspathURIContext(((XtextResourceSet)rs).getClasspathURIContext());
            result.setClasspathUriResolver(((XtextResourceSet)rs).getClasspathUriResolver());
        }
        return result;
    }

    public Grammar getSuperGrammar(Grammar grammar) {
        boolean _isEmpty = grammar.getUsedGrammars().isEmpty();
        if (_isEmpty) {
            return null;
        }
        Adapter _existingAdapter = EcoreUtil.getExistingAdapter((Notifier)grammar, SuperGrammar.class);
        SuperGrammar sg = (SuperGrammar)_existingAdapter;
        if (sg != null) {
            return sg.grammar;
        }
        URI uri = ((Grammar)IterableExtensions.head((Iterable)grammar.getUsedGrammars())).eResource().getURI();
        Resource resource = this.cloneResourceSet(grammar.eResource().getResourceSet()).getResource(uri, true);
        EObject _head = (EObject)IterableExtensions.head((Iterable)resource.getContents());
        Grammar result = (Grammar)_head;
        EList _eAdapters = grammar.eAdapters();
        SuperGrammar _superGrammar = new SuperGrammar(result);
        _eAdapters.add((Object)_superGrammar);
        return result;
    }

    public Collection<IGrammarConstraintProvider.IConstraint> getGrammarConstraints(Grammar grammar) {
        if (grammar == null) {
            return CollectionLiterals.emptySet();
        }
        Functions.Function1 _function = it -> (IGrammarConstraintProvider.IConstraint)it.getValue();
        return ListExtensions.map((List)this.gcp.getConstraints(grammar).values(), (Functions.Function1)_function);
    }

    public List<ISemanticSequencerNfaProvider.ISemState> getLinearListOfMandatoryAssignments(IGrammarConstraintProvider.IConstraint constraint) {
        Nfa nfa = constraint.getNfa();
        ISemanticSequencerNfaProvider.ISemState state = (ISemanticSequencerNfaProvider.ISemState)nfa.getStart();
        ArrayList result = CollectionLiterals.newArrayList();
        HashSet features = CollectionLiterals.newHashSet();
        while (state != null) {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            boolean _tripleEquals;
            ISemanticSequencerNfaProvider.ISemState _stop = (ISemanticSequencerNfaProvider.ISemState)nfa.getStop();
            boolean bl = _tripleEquals = state == _stop;
            if (_tripleEquals) {
                ArrayList _xifexpression = null;
                boolean _isEmpty = result.isEmpty();
                _xifexpression = _isEmpty ? null : result;
                return _xifexpression;
            }
            int _size = state.getFollowers().size();
            boolean bl2 = _tripleNotEquals = _size != 1;
            if (_tripleNotEquals) {
                return null;
            }
            ISemanticSequencerNfaProvider.ISemState _start = (ISemanticSequencerNfaProvider.ISemState)nfa.getStart();
            boolean bl3 = _tripleNotEquals_1 = state != _start;
            if (_tripleNotEquals_1) {
                EStructuralFeature feature = state.getFeature();
                if (feature == null || feature.isMany() || !features.add(feature)) {
                    return null;
                }
                result.add(state);
            }
            state = (ISemanticSequencerNfaProvider.ISemState)IterableExtensions.head((Iterable)state.getFollowers());
        }
        return null;
    }

    public String toAcceptMethod(IGrammarConstraintProvider.ConstraintElementType type) {
        String _switchResult = null;
        if (type != null) {
            switch (type) {
                case ASSIGNED_ACTION_CALL: {
                    _switchResult = "acceptAssignedAction";
                    break;
                }
                case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: {
                    _switchResult = "acceptAssignedCrossRefDatatype";
                    break;
                }
                case ASSIGNED_CROSSREF_ENUM_RULE_CALL: {
                    _switchResult = "acceptAssignedCrossRefEnum";
                    break;
                }
                case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: {
                    _switchResult = "acceptAssignedCrossRefTerminal";
                    break;
                }
                case ASSIGNED_CROSSREF_KEYWORD: {
                    _switchResult = "acceptAssignedCrossRefKeyword";
                    break;
                }
                case ASSIGNED_DATATYPE_RULE_CALL: {
                    _switchResult = "acceptAssignedDatatype";
                    break;
                }
                case ASSIGNED_ENUM_RULE_CALL: {
                    _switchResult = "acceptAssignedEnum";
                    break;
                }
                case ASSIGNED_KEYWORD: {
                    _switchResult = "acceptAssignedKeyword";
                    break;
                }
                case ASSIGNED_PARSER_RULE_CALL: {
                    _switchResult = "acceptAssignedParserRuleCall";
                    break;
                }
                case ASSIGNED_TERMINAL_RULE_CALL: {
                    _switchResult = "acceptAssignedTerminal";
                    break;
                }
                default: {
                    _switchResult = "<error, unknown type '" + type + "'>";
                    break;
                }
            }
        } else {
            _switchResult = "<error, unknown type '" + type + "'>";
        }
        return _switchResult;
    }

    public String toNodeType(IGrammarConstraintProvider.ConstraintElementType type) {
        String _switchResult = null;
        if (type != null) {
            switch (type) {
                case ASSIGNED_ACTION_CALL: 
                case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: 
                case ASSIGNED_CROSSREF_ENUM_RULE_CALL: 
                case ASSIGNED_CROSSREF_KEYWORD: 
                case ASSIGNED_DATATYPE_RULE_CALL: 
                case ASSIGNED_ENUM_RULE_CALL: 
                case ASSIGNED_PARSER_RULE_CALL: {
                    _switchResult = ICompositeNode.class.getSimpleName();
                    break;
                }
                case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: 
                case ASSIGNED_KEYWORD: 
                case ASSIGNED_TERMINAL_RULE_CALL: {
                    _switchResult = ILeafNode.class.getSimpleName();
                    break;
                }
                default: {
                    _switchResult = "<error, unknown type '" + type + "'>";
                    break;
                }
            }
        } else {
            _switchResult = "<error, unknown type '" + type + "'>";
        }
        return _switchResult;
    }

    @FinalFieldsConstructor
    @Accessors
    protected static class SuperGrammar
    extends AdapterImpl {
        private final Grammar grammar;

        public boolean isAdapterForType(Object type) {
            return type == SuperGrammar.class;
        }

        public SuperGrammar(Grammar grammar) {
            this.grammar = grammar;
        }

        @Pure
        public Grammar getGrammar() {
            return this.grammar;
        }
    }
}

