/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.evolving.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.evolving.EvolvingFactory;
import org.eclipse.stem.diseasemodels.evolving.EvolvingPackage;
import org.eclipse.stem.diseasemodels.evolving.EvolvingSIRDiseaseModel;
import org.eclipse.stem.diseasemodels.evolving.EvolvingSIRDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.evolving.EvolvingSIRDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.evolving.impl.EvolvingSIDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;
import org.eclipse.stem.interventions.StandardInterventionLabel;
import org.eclipse.stem.interventions.StandardInterventionLabelValue;

public class EvolvingSIRDiseaseModelImpl
extends EvolvingSIDiseaseModelImpl
implements EvolvingSIRDiseaseModel {
    protected static final double IMMUNITY_LOSS_RATE_EDEFAULT = 0.0;
    protected double immunityLossRate = 0.0;
    protected static final double CROSS_IMMUNITY_RATE_EDEFAULT = 0.75;
    protected double crossImmunityRate = 0.75;

    @Override
    protected EClass eStaticClass() {
        return EvolvingPackage.Literals.EVOLVING_SIR_DISEASE_MODEL;
    }

    @Override
    public double getImmunityLossRate() {
        return this.immunityLossRate;
    }

    @Override
    public void setImmunityLossRate(double newImmunityLossRate) {
        this.immunityLossRate = newImmunityLossRate;
    }

    @Override
    public double getCrossImmunityRate() {
        return this.crossImmunityRate;
    }

    @Override
    public void setCrossImmunityRate(double newCrossImmunityRate) {
        this.crossImmunityRate = newCrossImmunityRate;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 31: {
                return this.getImmunityLossRate();
            }
            case 32: {
                return this.getCrossImmunityRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 31: {
                this.setImmunityLossRate((Double)newValue);
                return;
            }
            case 32: {
                this.setCrossImmunityRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 31: {
                this.setImmunityLossRate(0.0);
                return;
            }
            case 32: {
                this.setCrossImmunityRate(0.75);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 31: {
                return this.immunityLossRate != 0.0;
            }
            case 32: {
                return this.crossImmunityRate != 0.75;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (immunityLossRate: ");
        result.append(this.immunityLossRate);
        result.append(", crossImmunityRate: ");
        result.append(this.crossImmunityRate);
        result.append(')');
        return result.toString();
    }

    @Override
    public void calculateEvolvedInitialState() {
        EvolvingSIRDiseaseModelImpl parentDiseaseModel = (EvolvingSIRDiseaseModelImpl)this.getParentDisease();
        DiseaseModelLabel parentEvolutionSource = this.getEvolvedAt();
        if (parentDiseaseModel == null && parentEvolutionSource == null) {
            System.err.println("Trying to calculate label state from an improperly initialized evolved model.  Do something.");
            return;
        }
        Node currentNode = parentEvolutionSource.getNode();
        URI evolutionLocation = currentNode.getURI();
        boolean[] genome = this.getGenome();
        boolean[] parentGenome = parentDiseaseModel.getGenome();
        if (genome != null && genome.length > 1) {
            double dMute = Math.random() * (double)genome.length;
            int iMute = (int)Math.round(dMute);
            int i = 0;
            while (i < genome.length) {
                genome[i] = parentGenome[i];
                if (i == iMute) {
                    genome[i] = !genome[i];
                }
                ++i;
            }
        }
        this.setGenome(genome);
        for (DynamicLabel dl : this.getLabelsToUpdate()) {
            double popCount;
            if (!(dl instanceof EvolvingSIRDiseaseModelLabel)) continue;
            double s = 0.0;
            double i = 0.0;
            double r = 0.0;
            double diseaseDeaths = 0.0;
            EvolvingSIRDiseaseModelLabel childLabel = (EvolvingSIRDiseaseModelLabel)dl;
            EvolvingSIRDiseaseModelLabelValue childLabelValues = (EvolvingSIRDiseaseModelLabelValue)childLabel.getCurrentValue();
            EvolvingSIRDiseaseModelLabel parentSIRlabel = (EvolvingSIRDiseaseModelLabel)parentEvolutionSource;
            childLabel.setPopulationLabel(parentSIRlabel.getPopulationLabel());
            childLabel.setPopulationModelLabel(parentSIRlabel.getPopulationModelLabel());
            EvolvingSIRDiseaseModelLabelValue lv = (EvolvingSIRDiseaseModelLabelValue)parentSIRlabel.getCurrentValue();
            s = popCount = lv.getPopulationCount();
            if (childLabel.getNode().getURI().equals(evolutionLocation)) {
                System.out.println("initializing child disease at evolution location");
                if (parentEvolutionSource instanceof EvolvingSIRDiseaseModelLabel) {
                    if (popCount > 1.0) {
                        i = 1.0;
                        s -= 1.0;
                    } else {
                        System.err.println("Likely ERROR: Zero population detected on node " + currentNode.getURI().lastSegment() + " ...  Do something.");
                    }
                }
            }
            childLabelValues.setS(s);
            childLabelValues.setI(i);
            childLabelValues.setR(r);
            childLabelValues.setDiseaseDeaths(diseaseDeaths);
        }
    }

    protected double getAdjustedImmunityLossRate(long timeDelta) {
        return this.getImmunityLossRate() * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta);
        double transmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        double adjustedImmunityLossRate = this.getAdjustedImmunityLossRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            EvolvingSIRDiseaseModelLabelValue currentSIR = (EvolvingSIRDiseaseModelLabelValue)currentState;
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSIR.getI();
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfInfectedToRecovered = adjustedRecoveryRate * currentSIR.getI();
            double numberOfRecoveredToSusceptible = adjustedImmunityLossRate * currentSIR.getR();
            double effectiveSusceptible = currentSIR.getS();
            double popCount = currentSIR.getS() + currentSIR.getI() + currentSIR.getR();
            double crossProduct = 1.0;
            if (this.crossImmunityRate > 0.0 && effectiveSusceptible > 1.0) {
                Node thisNode = diseaseLabel.getNode();
                EList allLabels = thisNode.getLabels();
                for (NodeLabel nl : allLabels) {
                    EvolvingSIRDiseaseModel otherSIRDiease;
                    EvolvingSIRDiseaseModelLabel sirLabel;
                    Decorator otherDisease;
                    if (!(nl instanceof EvolvingSIRDiseaseModelLabel) || !((otherDisease = (sirLabel = (EvolvingSIRDiseaseModelLabel)nl).getDecorator()) instanceof EvolvingSIRDiseaseModel) || (otherSIRDiease = (EvolvingSIRDiseaseModel)otherDisease).getDiseaseName().equals(this.getDiseaseName())) continue;
                    EvolvingSIRDiseaseModelLabelValue otherValue = (EvolvingSIRDiseaseModelLabelValue)sirLabel.getCurrentValue();
                    double immuneTerm = otherValue.getR() / popCount;
                    double geneticDistance = this.getGeneticDistance(otherSIRDiease);
                    if (geneticDistance >= 1.0) {
                        immuneTerm *= this.crossImmunityRate / geneticDistance;
                    }
                    if (!((crossProduct *= 1.0 - immuneTerm) < 0.0)) continue;
                    crossProduct = 0.0;
                }
            }
            double numberOfSusceptibleToInfected = 0.0;
            numberOfSusceptibleToInfected = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * effectiveSusceptible * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * (effectiveSusceptible *= crossProduct) * effectiveInfectious;
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToInfected;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToRecovered - diseaseDeaths;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            Exchange siExchange = (Exchange)ExchangePool.POOL.get();
            siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            siExchange.setCount(numberOfSusceptibleToInfected);
            siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)siExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            StandardInterventionLabel scl = this.findInterventionLabel((Node)diseaseLabel.getIdentifiable());
            if (scl != null) {
                double vaccinations = ((StandardInterventionLabelValue)scl.getCurrentValue()).getVaccinations();
                double isolations = ((StandardInterventionLabelValue)scl.getCurrentValue()).getIsolations();
                vaccinations *= (double)timeDelta / (double)this.getTimePeriod();
                isolations *= (double)timeDelta / (double)this.getTimePeriod();
                if (currentSIR.getS() < vaccinations) {
                    vaccinations = currentSIR.getS();
                }
                if (currentSIR.getI() < isolations) {
                    isolations = currentSIR.getI();
                }
                deltaS -= vaccinations;
                deltaR += vaccinations;
                deltaI -= isolations;
                deltaR += isolations;
            }
            SIRLabelValueImpl ret = (SIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfInfectedToRecovered);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    @Override
    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        EvolvingSIRDiseaseModelLabel label = EvolvingFactory.eINSTANCE.createEvolvingSIRDiseaseModelLabel();
        label.setTypeURI(DiseaseModelLabel.URI_TYPE_DYNAMIC_DISEASE_LABEL);
        return label;
    }

    @Override
    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return EvolvingFactory.eINSTANCE.createEvolvingSIRDiseaseModelLabelValue();
    }
}

