/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.spatial.geo.PlatformLatLongDataProvider;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.geography.names.GeographicNames;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GEJob;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.GESimEntry;
import org.eclipse.stem.ui.ge.kml.KmlDisplaySelection;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.eclipse.stem.ui.ge.views.GEView;
import org.eclipse.stem.ui.views.geographic.map.GeographicSelectionElements;

public class GEInterface
implements ISimulationListener,
ISimulationManagerListener {
    private static final String controlTemplate = "control_&N_&T.kml";
    private Map<String, GESimEntry> activeSimulations = null;
    private Map<String, GEData> stemMap = null;
    private GEView geView = null;
    private String activeView = null;
    private String displayNode = null;
    private Map<String, GEData> stemMapNode = null;
    private Aspect defaultAspect = null;
    private String errorMessage = null;
    private boolean manualRequest = false;
    private final KmlDisplaySelection displaySelection = new KmlDisplaySelection();
    private boolean didDisplayArea = false;

    public GEInterface(GEView geView) {
        GELog.debug(this, "constructor: ");
        this.geView = geView;
        Aspect.setup();
        this.activeSimulations = new HashMap<String, GESimEntry>(1);
    }

    public boolean init() {
        boolean ok = true;
        boolean okKML = true;
        SimulationManager simulationManager = SimulationManager.getManager();
        simulationManager.addSimulationManagerListener((ISimulationManagerListener)this);
        List list = simulationManager.getActiveSimulations();
        boolean autolog = GEPreferencePage.isAutoLogging();
        for (ISimulation sim : list) {
            String name = GEInterface.getSimulationId(sim);
            GELog.debug(this, "simulationAdded: " + name + " " + sim);
            this.setActive(sim, autolog);
        }
        String url = StemKml.initWebServer();
        GELog.debug(this, "Web server URL: " + url);
        if (url == null) {
            this.setErrorMessage("Unable to access WebServer");
            ok = false;
        } else {
            okKML = StemKml.verifyGE();
            if (!okKML) {
                this.setErrorMessage("GoogleEarth KML files are not defined");
            }
        }
        if (!(ok && okKML || (ok = this.checkPreferences(url, okKML)))) {
            GELog.debug(this.getErrorMessage());
        }
        return ok;
    }

    private boolean checkPreferences(String url, boolean okGE) {
        boolean result = false;
        int method = GEPreferencePage.getMethod();
        int newMethod = -1;
        switch (method) {
            case 1: {
                result = true;
                break;
            }
            case 2: {
                result = false;
                if (url == null && okGE) {
                    newMethod = 4;
                    this.errorMessage = "No WebServer: Changed to directly launch KML";
                    break;
                }
                newMethod = 1;
                this.errorMessage = "KML is not recognized, Changed to only Log files";
                break;
            }
            case 3: {
                if (url == null && okGE) {
                    newMethod = 4;
                    this.errorMessage = "No WebServer: Changed to directly launch KML";
                    break;
                }
                newMethod = 1;
                this.errorMessage = "KML is not recognized, Changed to only Log files";
                break;
            }
            case 4: {
                if (okGE) break;
                newMethod = 1;
                this.errorMessage = "KML is not recognized, Changed to only Log files";
                break;
            }
        }
        if (newMethod != -1) {
            GEPreferencePage.setMethod(newMethod);
            result = false;
        }
        return result;
    }

    public void simulationsChanged(SimulationManagerEvent event) {
        block6: {
            block5: {
                GELog.debug(this.getClass(), "simulationsChanged: ");
                if (event.getSimulationsRemoved().length <= 0) break block5;
                ISimulation[] iSimulationArray = event.getSimulationsRemoved();
                int n = iSimulationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISimulation sim = iSimulationArray[n2];
                    String id = GEInterface.getSimulationId(sim);
                    GELog.debug(this.getClass(), "simulationRemoved: " + id + " " + sim);
                    GESimEntry existing = this.activeSimulations.get(id);
                    if (existing != null) {
                        boolean active = this.isActiveView(sim);
                        this.setActive(sim, false);
                        this.activeSimulations.remove(id);
                        if (active) {
                            this.stopGE();
                        }
                        GELog.debug(this, "Active simulation removed: " + id);
                    }
                    ++n2;
                }
                break block6;
            }
            if (event.getSimulationsAdded().length <= 0) break block6;
            boolean autolog = GEPreferencePage.isAutoLogging();
            ISimulation[] iSimulationArray = event.getSimulationsAdded();
            int n = iSimulationArray.length;
            int n3 = 0;
            while (n3 < n) {
                boolean ok;
                ISimulation sim = iSimulationArray[n3];
                String name = GEInterface.getSimulationId(sim);
                GELog.debug(this, "simulationAdded: " + name + " " + sim);
                GESimEntry existing = this.activeSimulations.get(name);
                if (existing == null && !(ok = this.setActive(sim, autolog)) && !autolog) {
                    this.geView.showMessage(this.errorMessage);
                }
                ++n3;
            }
        }
    }

    public void dispose() {
        SimulationManager simulationManager = SimulationManager.getManager();
        List list = simulationManager.getActiveSimulations();
        for (ISimulation sim : list) {
            sim.removeSimulationListener((ISimulationListener)this);
        }
        simulationManager.removeListener((ISimulationManagerListener)this);
        if (this.activeView != null) {
            this.stopGE();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void simulationChanged(SimulationEvent event) {
        try {
            ISimulation simulation = event.getSimulation();
            SimulationState state = event.getSimulationState();
            String id = GEInterface.getSimulationId(simulation);
            GESimEntry existing = this.activeSimulations.get(id);
            Sequencer seq = simulation.getScenario().getSequencer();
            if (state == SimulationState.COMPLETED_CYCLE) {
                if (existing == null) {
                    GELog.debug(this, "Simulation " + id + " not active for GE.");
                    return;
                }
                int cycle = seq.getCycle();
                GELog.debug(this, String.valueOf(id) + " State=" + state + " cycle=" + cycle);
                this.processCycle(simulation, state);
                this.geView.refresh();
            } else {
                GELog.debug(this, String.valueOf(id) + " State=" + state);
            }
        }
        catch (Exception e) {
            GELog.error("simulationChanged: Failure ", e);
        }
    }

    private void processCycle(ISimulation simulation, SimulationState state) {
        StemKml stemKml;
        String kmlfn = null;
        boolean doit = false;
        int nth = GEPreferencePage.getWhichCycle();
        String id = GEInterface.getSimulationId(simulation);
        GESimEntry existing = this.activeSimulations.get(id);
        if (existing == null) {
            GELog.debug(this, "Simulation " + id + " not active for GE.");
            return;
        }
        int method = existing.getMethod();
        String entryFolder = existing.getLogFolder();
        Scenario scenario = simulation.getScenario();
        Sequencer seq = scenario.getSequencer();
        int cycle = seq.getCycle();
        if (GELog.memoryCheck(0.8)) {
            GELog.debug(this, "Process for cycle " + cycle + " skipped. Memory low");
            return;
        }
        this.stemMap = existing.getStemMap();
        if (this.stemMap == null) {
            if (!GELog.memoryCheck(0.8)) {
                this.stemMap = this.buildMap(simulation);
            }
            if (this.stemMap == null) {
                GELog.debug(this.getClass(), "Unable to build stemMap");
                return;
            }
            doit = true;
            existing.setStemMap(this.stemMap);
        }
        if ((stemKml = existing.getStemKml()) == null) {
            stemKml = new StemKml();
            existing.setStemKml(stemKml);
            stemKml.init();
        }
        if (method == 5 && !this.manualRequest) {
            return;
        }
        if (cycle == 0 || nth == 1) {
            doit = true;
        } else if (nth > 1 && cycle % nth == 0) {
            doit = true;
        }
        Aspect aspect = this.getAspectToDisplay(simulation);
        if (this.manualRequest) {
            doit = true;
        }
        if (doit) {
            try {
                boolean launch = false;
                boolean rename = false;
                switch (method) {
                    case 1: {
                        if (entryFolder != null) {
                            kmlfn = StemKml.getControlFN(entryFolder, controlTemplate, aspect, cycle);
                            break;
                        }
                        doit = false;
                        break;
                    }
                    case 2: {
                        if (this.manualRequest) {
                            doit = true;
                            if (this.activeView == null) {
                                launch = true;
                                kmlfn = StemKml.getControlFile();
                                break;
                            }
                            kmlfn = StemKml.getControlFN(entryFolder, controlTemplate, aspect, cycle);
                            break;
                        }
                        if (!id.equals(this.activeView)) {
                            doit = false;
                            GELog.debug(this, "Unable to display id " + id);
                            break;
                        }
                        if (entryFolder != null) {
                            kmlfn = StemKml.getControlFN(entryFolder, controlTemplate, aspect, cycle);
                            break;
                        }
                        doit = false;
                        GELog.debug(this, "Unable to display. Invalid folder");
                        break;
                    }
                    case 3: {
                        if (this.manualRequest) {
                            if (this.activeView != null) {
                                doit = false;
                                GELog.debug(this, "Unable to do manual display");
                                break;
                            }
                            launch = true;
                            kmlfn = StemKml.getControlFile();
                            break;
                        }
                        if (!id.equals(this.activeView)) {
                            doit = false;
                            GELog.debug(this, "Not an active Simulation id: " + id + " activeView: " + this.activeView);
                            break;
                        }
                        kmlfn = StemKml.getControlFile();
                        rename = true;
                        break;
                    }
                    case 4: {
                        launch = true;
                        kmlfn = StemKml.getControlFile();
                        if (this.manualRequest || id.equals(this.activeView)) break;
                        doit = false;
                        GELog.debug(this, "Invalid. id: " + id + " activeView: " + this.activeView);
                        break;
                    }
                    case 5: {
                        if (this.manualRequest) {
                            GELog.debug(this, "Do manual display");
                            launch = true;
                            kmlfn = StemKml.getControlFile();
                            doit = true;
                            break;
                        }
                        doit = false;
                    }
                }
                this.manualRequest = false;
                if (doit) {
                    this.storeAspects(simulation, this.stemMap);
                    GELog.debug(this.getClass(), "GenerateKML for id: " + id + " aspect " + aspect.toString());
                    this.generateKML(kmlfn, stemKml, this.stemMap, aspect, cycle, launch, rename);
                }
            }
            catch (Exception e) {
                GELog.error("processCycle(): Failure creating KML ", e);
                this.activeSimulations.remove(id);
            }
        }
    }

    public boolean displayArea(String adminFile, String search, boolean clear) {
        Map<String, GEData> stemMap;
        StemKml stemKml;
        String fn;
        boolean result;
        block8: {
            block7: {
                this.displayNode = search;
                this.didDisplayArea = true;
                this.errorMessage = null;
                result = true;
                if (clear) {
                    this.stemMapNode = null;
                }
                GELog.debug(this, "displayMap() " + adminFile + " search: " + search);
                if (adminFile != null) break block7;
                this.errorMessage = "AdminFile argument is null";
                GELog.debug(this, this.errorMessage);
                return false;
            }
            fn = StemKml.getDisplayAreaFile();
            stemKml = new StemKml();
            stemKml.init();
            stemMap = this.buildMap(adminFile, search);
            if (stemMap.size() != 0) break block8;
            this.errorMessage = "Search argument " + search + " did not match any admin area name.";
            return false;
        }
        try {
            if (this.stemMapNode == null) {
                this.stemMapNode = stemMap;
            } else {
                this.stemMapNode.putAll(stemMap);
            }
            Aspect aspect = Aspect.getAspect("S");
            boolean rename = false;
            int cycle = 0;
            boolean launch = true;
            this.generateKML(fn, stemKml, this.stemMapNode, aspect, cycle, launch, rename);
        }
        catch (RuntimeException e) {
            result = false;
            GELog.error("DisplayArea failure", e);
        }
        this.displayNode = null;
        return result;
    }

    public boolean displaySelection(RegionImpl region, GeographicSelectionElements gse) {
        Map<String, GEData> stemMap;
        String fn;
        boolean result;
        block3: {
            this.didDisplayArea = true;
            this.errorMessage = null;
            result = true;
            fn = StemKml.getDisplayAreaFile();
            StemKml stemKml = new StemKml();
            stemKml.init();
            stemMap = this.buildSelectionMap(region, gse);
            if (stemMap != null && stemMap.size() != 0) break block3;
            return false;
        }
        try {
            this.stemMapNode = this.stemMapNode == null ? stemMap : stemMap;
            Aspect aspect = null;
            this.displaySelection.generatePolygons(fn, this.stemMapNode, aspect);
            StemKml.launch(fn);
            GELog.debug(this, "GoogleEarth Map  submitted");
        }
        catch (RuntimeException e) {
            result = false;
            GELog.error("DisplayArea failure", e);
        }
        this.displayNode = null;
        return result;
    }

    public boolean displayMap(ISimulation simulation) {
        boolean result = true;
        SimulationState state = simulation.getSimulationState();
        GELog.debug(this, "DisplayMap request");
        this.manualRequest = true;
        if (state != SimulationState.RUNNING) {
            this.processCycle(simulation, simulation.getSimulationState());
        }
        return result;
    }

    public boolean runGE(String folder) {
        boolean result = true;
        GELog.debug(this, "GoogleEarth run request");
        if (this.activeView == null) {
            this.activeView = "runGE";
            StemKml.setWaitForKML(false);
            StemKml.launchNetworkLink(folder, null);
        } else {
            this.errorMessage = "GoogleEarth is busy";
            GELog.debug(this, this.errorMessage);
            result = false;
        }
        return result;
    }

    public boolean startGE() {
        boolean result = true;
        GELog.debug(this, "GoogleEarth Start request");
        StemKml.launchGE();
        return result;
    }

    public boolean restartGE() {
        GESimEntry existing;
        boolean result = true;
        GELog.debug(this, "GoogleEarth Restart request");
        StemKml.launchGE();
        int method = 0;
        if (this.activeView != null && (existing = this.activeSimulations.get(this.activeView)) != null) {
            method = existing.getMethod();
            ISimulation sim = existing.getSimulation();
            if (sim.getSimulationState() == SimulationState.RUNNING) {
                this.errorMessage = "Simulation should be paused while restarting GoogleEarth";
                return false;
            }
            String folder = existing.getLogFolder();
            if (method == 3 || method == 2) {
                StemKml.launchNetworkLink(folder, null);
            }
        }
        return result;
    }

    public boolean stopGE() {
        boolean result = true;
        GELog.debug(this, "GoogleEarth Stop request");
        if (this.didDisplayArea) {
            StemKml.clearDisplayArea();
        }
        this.activeView = null;
        StemKml.launchGE();
        return result;
    }

    private StemKml generateKML(String fn, StemKml stemKml, Map<String, GEData> stemMap, Aspect aspect, long cycle, boolean launch, boolean rename) {
        try {
            GEJob job = new GEJob("Generate KML");
            job.generateKML(fn, stemKml, stemMap, aspect, cycle, launch, rename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stemKml;
    }

    private void storeAspects(ISimulation sim, Map<String, GEData> stemMap) {
        Scenario scenario = sim.getScenario();
        Graph g = scenario.getCanonicalGraph();
        Decorator[] decorators = (Decorator[])g.getDecorators().toArray((Object[])new Decorator[g.getDecorators().size()]);
        int err1ctr = 0;
        int err2ctr = 0;
        Decorator[] decoratorArray = decorators;
        int n = decorators.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] labels;
            Decorator decorator = decoratorArray[n2];
            Object[] objectArray = labels = decorator.getLabelsToUpdate().toArray();
            int n3 = labels.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean keep;
                NodeLabel nodeLabel;
                Node node;
                String key;
                GEData data;
                Object element = objectArray[n4];
                if (element instanceof NodeLabel && (data = stemMap.get(key = (node = (nodeLabel = (NodeLabel)element).getNode()).getDublinCore().getTitle())) != null && (keep = this.filter(node, key, data))) {
                    RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt(element, RelativeValueProvider.class);
                    rvp.setTarget((Notifier)element);
                    if (rvp != null) {
                        Map<String, Double> map = data.getValueMap();
                        for (ItemPropertyDescriptor property : rvp.getProperties()) {
                            String p = property.getDisplayName((Object)property);
                            double v = rvp.getRelativeValue(property);
                            if (!Aspect.exists(p)) continue;
                            map.put(p, v);
                        }
                    } else {
                        ++err2ctr;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (err1ctr > 0) {
            GELog.debug(this, "Nodes with no LatLong data. count=" + err1ctr);
        }
        if (err2ctr > 0) {
            GELog.debug(this, "Nodes with no aspect values. count=" + err2ctr);
        }
    }

    private Map<String, GEData> buildMap(ISimulation simulation) {
        Graph canonicalGraph;
        block6: {
            this.stemMap = new HashMap<String, GEData>();
            Scenario scenario = simulation.getScenario();
            canonicalGraph = scenario.getCanonicalGraph();
            if (canonicalGraph != null) break block6;
            GELog.debug(this, "buildMap(): canonicalGraph is null");
            return null;
        }
        try {
            int errctr = 0;
            for (Node node : canonicalGraph.getNodes().values()) {
                String nodeTitle;
                boolean keep = this.filter(node, nodeTitle = node.getDublinCore().getTitle(), null);
                if (!keep) continue;
                LatLong latLongData = this.getLatLong(node);
                if (latLongData != null && latLongData.size() > 0) {
                    GEData data = new GEData(nodeTitle, latLongData);
                    this.stemMap.put(nodeTitle, data);
                    continue;
                }
                ++errctr;
            }
            if (errctr > 0) {
                GELog.debug(this, "Total buildmap errors = " + errctr);
            }
        }
        catch (Throwable e) {
            GELog.error("Failure building area map", e);
            this.stemMap = null;
        }
        return this.stemMap;
    }

    boolean filter(Node node, String nodeTitle, GEData data) {
        int adminarea = this.getAreaType(node);
        if (adminarea <= 0) {
            GELog.debug(this, "Skip AdminArea 0: " + node);
            return false;
        }
        if (this.displayNode != null) {
            this.displayNode = this.displayNode.toLowerCase();
            if (nodeTitle.toLowerCase().contains(this.displayNode)) {
                GELog.debug(this, "Display: " + nodeTitle);
                return true;
            }
            return false;
        }
        return true;
    }

    private String getAreaID(Node region) {
        DublinCore dc = region.getDublinCore();
        String dcIdentifier = dc.getIdentifier();
        String isoKey = dcIdentifier.substring(dcIdentifier.lastIndexOf("/") + 1);
        return isoKey;
    }

    private String getAreaName(Node region) {
        DublinCore dc = region.getDublinCore();
        String dcIdentifier = dc.getIdentifier();
        String isoKey = dcIdentifier.substring(dcIdentifier.lastIndexOf("/") + 1);
        if (isoKey != null && !"".equals(isoKey)) {
            String geographicName = GeographicNames.getName((String)isoKey);
            return geographicName;
        }
        return dc.getTitle();
    }

    private int getAreaType(Node node) {
        String mapid;
        int areatype = -1;
        DublinCore dc = node.getDublinCore();
        String spatial = dc.getSpatial();
        if (spatial != null && (mapid = spatial.substring(spatial.lastIndexOf("/") + 1)) != null && !"".equals(mapid)) {
            mapid = mapid.substring(0, mapid.indexOf("#"));
            mapid = mapid.substring(4, 5);
            areatype = Integer.parseInt(mapid);
        }
        return areatype;
    }

    private Map<String, GEData> buildSelectionMap(RegionImpl region, GeographicSelectionElements gse) {
        try {
            DublinCore dc = region.getDublinCore();
            String spatial = dc.getSpatial();
            String uriString = spatial.replace("stemspatial:", "");
            this.stemMap = new HashMap<String, GEData>();
            PlatformLatLongDataProvider provider = new PlatformLatLongDataProvider();
            URI uriNode = URI.createURI((String)uriString);
            LatLong latLong = provider.getLatLong(uriNode);
            String id = this.getAreaID((Node)region);
            String name = this.getAreaName((Node)region);
            GEData data = new GEData(id, name, latLong);
            data.setValue(Aspect.getAspect("S"), 1.0);
            String description = this.formatDescription(region, gse);
            data.setDescription(description);
            double longitude = gse.getLongitude();
            double latitude = gse.getLatitude();
            GELog.debug(String.valueOf(longitude) + ":" + latitude);
            data.setPoint(longitude, latitude);
            this.stemMap.put(id, data);
        }
        catch (Throwable e) {
            GELog.error("Failure building area map", e);
            this.stemMap = null;
            this.errorMessage = "Exception while building Map";
        }
        return this.stemMap;
    }

    private Map<String, GEData> buildMap(String adminFile, String search) {
        String baseURI = "platform:/plugin/org.eclipse.stem.geography/resources/data/geo/country/";
        try {
            String uriString = String.valueOf(baseURI) + adminFile;
            this.stemMap = new HashMap<String, GEData>();
            PlatformLatLongDataProvider provider = new PlatformLatLongDataProvider();
            URI uri = URI.createURI((String)uriString);
            Set ids = provider.getIds(uri);
            if (ids.size() == 0) {
                this.errorMessage = "Invalid Country code specified";
                return this.stemMap;
            }
            String match = search.toLowerCase();
            for (String id : ids) {
                if (!id.toLowerCase().contains(match)) continue;
                URI uriNode = URI.createURI((String)(String.valueOf(uriString) + "#" + id));
                LatLong latLong = provider.getLatLong(uriNode);
                if (latLong != null && latLong.size() > 0) {
                    GEData data = new GEData(id, latLong);
                    data.setValue(Aspect.getAspect("S"), 1.0);
                    this.stemMap.put(id, data);
                    continue;
                }
                GELog.debug(this, "No spacial data Name=" + id);
            }
            if (ids.size() == 0) {
                this.errorMessage = "No Matching internal Administration area found";
            }
        }
        catch (Throwable e) {
            GELog.error("Failure building area map", e);
            this.stemMap = null;
            this.errorMessage = "Exception while building Map";
        }
        return this.stemMap;
    }

    private String formatDescription(RegionImpl region, GeographicSelectionElements gse) {
        StringBuffer sb = new StringBuffer(128);
        Map<String, Double> relValues = this.getRelValues(region);
        Set<String> aspects = relValues.keySet();
        sb.append("&lt;pre&gt;");
        sb.append(this.getAreaID((Node)region));
        sb.append(" &lt;br&gt;");
        for (String aspect : aspects) {
            Double relValue = relValues.get(aspect) * 100.0;
            String result = String.format("%8s: %5.1f%%", aspect, relValue);
            sb.append(result);
            sb.append(" &lt;br&gt;");
        }
        sb.append("&lt;pre&gt;");
        return sb.toString();
    }

    private Map<String, Double> getRelValues(RegionImpl region) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        EList nodes = region.getLabels();
        for (NodeLabel node : nodes) {
            RelativeValueProvider rvp = (RelativeValueProvider)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)node, RelativeValueProvider.class);
            if (rvp == null) continue;
            for (ItemPropertyDescriptor property : rvp.getProperties()) {
                String name = property.getDisplayName((Object)property);
                Double value = rvp.getRelativeValue(property);
                map.put(name, value);
            }
        }
        return map;
    }

    LatLong getLatLong(Node node) {
        try {
            LatLongProviderAdapter latLongProvider = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)node, LatLongProvider.class);
            return latLongProvider.getLatLong();
        }
        catch (RuntimeException e) {
            GELog.debug(this, e.getMessage());
            return null;
        }
    }

    public boolean isActive(ISimulation sim) {
        String name = GEInterface.getSimulationId(sim);
        GESimEntry existing = this.activeSimulations.get(name);
        return existing == null ? false : existing.active;
    }

    public boolean isActiveView(ISimulation sim) {
        String name = GEInterface.getSimulationId(sim);
        return name.equals(this.activeView);
    }

    public boolean setActive(ISimulation sim, boolean active) {
        String name = GEInterface.getSimulationId(sim);
        GESimEntry existing = this.activeSimulations.get(name);
        GELog.debug(this.getClass(), "setActive: " + name + "  " + active);
        if (existing != null) {
            if (existing.active == active) {
                return true;
            }
            existing.active = active;
            if (!existing.active && name.equals(this.activeView)) {
                this.activeView = null;
            }
        } else {
            existing = new GESimEntry(name, sim);
            existing.active = active;
            this.activeSimulations.put(name, existing);
            existing.setAspectToDisplay(GEPreferencePage.getAspect());
            if (active) {
                String entryFolder = existing.getLogFolder();
                int method = GEPreferencePage.getMethod();
                switch (method) {
                    case 1: {
                        if (this.geView != null) {
                            entryFolder = GEPreferencePage.getFolder();
                            entryFolder = this.geView.verifyFolder(entryFolder);
                            existing.setLogFolder(entryFolder);
                            existing.setMethod(method);
                        }
                        sim.addSimulationListener((ISimulationListener)this);
                        break;
                    }
                    case 2: {
                        if (this.geView != null) {
                            entryFolder = GEPreferencePage.getFolder();
                            entryFolder = this.geView.verifyFolder(entryFolder);
                            existing.setLogFolder(entryFolder);
                        }
                        if (entryFolder == null) break;
                        if (this.activeView == null) {
                            StemKml.setWaitForKML(true);
                            StemKml.launchNetworkLink(entryFolder, null);
                            this.activeView = name;
                            sim.addSimulationListener((ISimulationListener)this);
                            existing.setMethod(method);
                            break;
                        }
                        this.errorMessage = "Simulation " + this.activeView + " already active on GoogleEarth.";
                        GELog.debug(this, this.errorMessage);
                        existing.active = false;
                        return false;
                    }
                    case 3: {
                        String kmlfn = StemKml.getControlFile();
                        File f = new File(kmlfn);
                        String parent = String.valueOf(f.getParent()) + File.separator;
                        kmlfn = f.getName();
                        kmlfn = String.valueOf(parent) + kmlfn.replace(".", "_Current.");
                        if (this.activeView == null) {
                            StemKml.setWaitForKML(true);
                            StemKml.launchNetworkLink(entryFolder, kmlfn);
                            this.activeView = name;
                            sim.addSimulationListener((ISimulationListener)this);
                            existing.setMethod(method);
                            break;
                        }
                        this.errorMessage = "Simulation " + this.activeView + " already active on GoogleEarth.";
                        GELog.debug(this, this.errorMessage);
                        existing.active = false;
                        return false;
                    }
                    case 4: {
                        if (this.activeView == null) {
                            this.activeView = name;
                            sim.addSimulationListener((ISimulationListener)this);
                            existing.setMethod(method);
                            break;
                        }
                        this.errorMessage = "Simulation " + this.activeView + " already active on GoogleEarth.";
                        GELog.debug(this, this.errorMessage);
                        existing.active = false;
                        sim.addSimulationListener((ISimulationListener)this);
                        return false;
                    }
                    case 5: {
                        sim.addSimulationListener((ISimulationListener)this);
                        existing.setMethod(method);
                    }
                }
            }
        }
        return true;
    }

    public void setAspectToDisplay(ISimulation sim, Aspect aspect) {
        if (sim == null) {
            this.setDefaultAspect(aspect);
        } else {
            String name = GEInterface.getSimulationId(sim);
            GESimEntry existing = this.activeSimulations.get(name);
            if (existing != null) {
                existing.setAspectToDisplay(aspect);
            } else {
                this.setDefaultAspect(aspect);
            }
        }
    }

    public Aspect getAspectToDisplay(ISimulation sim) {
        String name = GEInterface.getSimulationId(sim);
        GESimEntry existing = this.activeSimulations.get(name);
        Aspect value = null;
        value = existing != null ? existing.getAspectToDisplay() : this.getDefaultAspect();
        return value;
    }

    public void displayStatus() {
        boolean saveDebug = GELog.DEBUG;
        GELog.DEBUG = true;
        GELog.debug(this, GEPreferencePage.display());
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean simulationSleep = preferenceStore.getBoolean("cyclePause");
        int simulationSleepSeconds = preferenceStore.getInt("cyclePauseMilliSeconds") * 1000;
        GELog.debug(this, "SIMULATION_SLEEP: " + simulationSleep);
        GELog.debug(this, "SIMULATION_SLEEP_SECONDS: " + simulationSleepSeconds);
        GELog.debug(this, "activeView: " + this.activeView);
        if (this.activeSimulations.size() == 0) {
            GELog.debug(this, "No active Simulations");
        } else {
            GELog.debug(this, "Active Simulations: " + this.activeSimulations.size());
            for (Map.Entry<String, GESimEntry> entry : this.activeSimulations.entrySet()) {
                GESimEntry geSim = entry.getValue();
                String name = entry.getKey();
                ISimulation sim = geSim.getSimulation();
                try {
                    GELog.debug(this, "  Simulation:  " + geSim.toString());
                    GELog.debug(this, "  State: " + sim.getSimulationState());
                    GESimEntry existing = this.activeSimulations.get(name);
                    GELog.debug(this, "  GESimEntry: " + existing);
                    Scenario scenario = sim.getScenario();
                    GELog.debug(this, "  Scenario: " + scenario);
                    DublinCore dc = scenario.getDublinCore();
                    GELog.debug(this, "  Scenario DublinCore: " + dc);
                    Sequencer sequencer = scenario.getSequencer();
                    GELog.debug(this, "  Sequencer: " + sequencer);
                    Model model = scenario.getModel();
                    GELog.debug(this, "  Model: " + model);
                }
                catch (Throwable t) {
                    GELog.error("Display Status failure", t);
                }
            }
        }
        GELog.DEBUG = saveDebug;
    }

    private String displayLatLong(ISimulation simulation) {
        Graph canonicalGraph;
        int counter;
        StringBuilder sb;
        block7: {
            sb = new StringBuilder();
            counter = 0;
            sb.append("LatLong data: ");
            Scenario scenario = simulation.getScenario();
            canonicalGraph = scenario.getCanonicalGraph();
            GELog.debug(this, "displayLatLong(): canonicalGraph=" + canonicalGraph);
            if (canonicalGraph != null) break block7;
            GELog.debug(this, "displayLatLong(): canonicalGraph is null");
            return null;
        }
        try {
            Iterator nodeIter = canonicalGraph.getNodes().values().iterator();
            while (nodeIter.hasNext()) {
                if (++counter > 100) {
                    sb.append("\n Limit of 100 reached");
                    break;
                }
                Node node = (Node)nodeIter.next();
                String nodeTitle = node.getDublinCore().getTitle();
                sb.append("\nNode: " + nodeTitle);
                LatLongProviderAdapter latLongProvider = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)node, LatLongProvider.class);
                LatLong latLongData = latLongProvider.getLatLong();
                if (latLongData != null && latLongData.size() > 0) {
                    for (LatLong.Segment segment : latLongData.getSegments()) {
                        String data = GEInterface.createStringOfLatLongData(segment);
                        sb.append("LatLong: " + data);
                    }
                    continue;
                }
                GELog.debug(this, "buildMap()(): No spacial data for Node=" + nodeTitle);
            }
        }
        catch (Throwable e) {
            GELog.error("Failure building area map", e);
        }
        return sb.toString();
    }

    private String displayAspect(ISimulation simulation) {
        StringBuilder sb = new StringBuilder();
        try {
            Decorator[] decorators;
            int counter = 0;
            Scenario scenario = simulation.getScenario();
            Graph g = scenario.getCanonicalGraph();
            Decorator[] decoratorArray = decorators = (Decorator[])g.getDecorators().toArray((Object[])new Decorator[g.getDecorators().size()]);
            int n = decorators.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] labels;
                Decorator decorator = decoratorArray[n2];
                GELog.debug(this, "decorator: " + decorator.toString());
                Object[] objectArray = labels = decorator.getLabelsToUpdate().toArray();
                int n3 = labels.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object element = objectArray[n4];
                    if (++counter > 100) {
                        sb.append("\n Limit of 100 reached");
                        break;
                    }
                    if (element instanceof NodeLabel) {
                        NodeLabel nodeLabel = (NodeLabel)element;
                        Node node = nodeLabel.getNode();
                        String title = node.getDublinCore().getTitle();
                        sb.append("\nNode: " + title + " ");
                        RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt(element, RelativeValueProvider.class);
                        rvp.setTarget((Notifier)element);
                        if (rvp != null) {
                            Iterator propertyIter = rvp.getProperties().iterator();
                            while (propertyIter.hasNext()) {
                                ItemPropertyDescriptor property = (ItemPropertyDescriptor)propertyIter.next();
                                sb.append(property.getDisplayName((Object)property));
                                sb.append(": ");
                                sb.append(String.format("%.2f", rvp.getRelativeValue(property)));
                                if (!propertyIter.hasNext()) continue;
                                sb.append(", ");
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            GELog.error("Failure getting SEIR data", e);
        }
        return sb.toString();
    }

    public static String getSimulationId(ISimulation simulation) {
        if (simulation != null) {
            return "SIM[" + Integer.toString(simulation.getSequenceNumber()) + "]";
        }
        return null;
    }

    private static String createStringOfLatLongData(LatLong.Segment segment) {
        StringBuilder sb = new StringBuilder();
        int size = segment.size();
        int i = 0;
        while (i < size) {
            sb.append("(");
            sb.append(segment.latitude(i));
            sb.append(", ");
            sb.append(segment.longitude(i));
            sb.append(")");
            ++i;
        }
        return sb.toString();
    }

    public Aspect getDefaultAspect() {
        if (this.defaultAspect == null) {
            this.defaultAspect = Aspect.getDefault();
        }
        return this.defaultAspect;
    }

    public void setDefaultAspect(Aspect defaultAspect) {
        this.defaultAspect = defaultAspect;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            return "";
        }
        return this.errorMessage;
    }

    public int getCycle(ISimulation sim) {
        Scenario scenario = sim.getScenario();
        Sequencer seq = scenario.getSequencer();
        int cycle = seq.getCycle();
        return cycle;
    }
}

