/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model.edit;

import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.BatchModification;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IMultiModification;
import org.eclipse.xtext.validation.Issue;

public class MultiModificationWrapper
implements IModification,
BatchModification.IBatchableModification {
    private final Issue issue;
    private final IMultiModification<EObject> modification;

    public MultiModificationWrapper(Issue issue, IMultiModification<?> modification) {
        this.issue = issue;
        this.modification = modification;
    }

    @Override
    public void apply(EObject object, IChangeSerializer serializer) {
        serializer.addModification((Notifier)object.eResource(), r -> this.modification.apply(object));
    }

    @Override
    public void apply(IModificationContext ctx) throws Exception {
        IXtextDocument document = ctx.getXtextDocument();
        BatchModification batch = (BatchModification)document.readOnly(r -> (BatchModification)r.getResourceServiceProvider().get(BatchModification.class));
        batch.setDocument(document);
        batch.apply(Collections.singleton(this), (IProgressMonitor)new NullProgressMonitor());
    }

    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public URI getEObjectURI() {
        return this.issue.getUriToProblem();
    }

    @Override
    public boolean isUpdateCrossReferences() {
        return true;
    }

    @Override
    public boolean isUpdateRelatedFiles() {
        return true;
    }
}

