/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.builders.DependencyLoop;
import org.eclipse.pde.internal.core.builders.DependencyLoopFinder;
import org.eclipse.pde.internal.ui.IHelpContextIds;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.plugin.LoopDialog;
import org.eclipse.pde.internal.ui.views.dependencies.CalleesListContentProvider;
import org.eclipse.pde.internal.ui.views.dependencies.CalleesTreeContentProvider;
import org.eclipse.pde.internal.ui.views.dependencies.CallersListContentProvider;
import org.eclipse.pde.internal.ui.views.dependencies.CallersTreeContentProvider;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesViewListPage;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesViewPage;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesViewTreePage;
import org.eclipse.pde.internal.ui.views.dependencies.HistoryDropDownAction;
import org.eclipse.pde.internal.ui.views.target.StateViewPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class DependenciesView
extends PageBookView
implements IPreferenceConstants,
IHelpContextIds {
    public static final String TREE_ACTION_GROUP = "tree";
    protected static final String MEMENTO_KEY_INPUT = "inputPluginId";
    private static final DependencyLoop[] NO_LOOPS = new DependencyLoop[0];
    private Map<IPageBookViewPage, IWorkbenchPart> fPagesToParts;
    private Map<IWorkbenchPart, IPageBookViewPage> fPartsToPages;
    private Object fInput;
    private PDEPreferencesManager fPreferences = PDEPlugin.getDefault().getPreferenceManager();
    private ShowCalleesAction fShowCallees;
    private ShowCallersAction fShowCallers;
    private ShowListAction fShowList;
    private ShowTreeAction fShowTree;
    private ShowLoopsAction fShowLoops;
    private ArrayList<String> fInputHistory;
    private DependencyLoop[] fLoops;
    private HistoryDropDownAction fHistoryDropDownAction;
    private IWorkbenchPart fLastDependenciesPart = null;
    private IWorkbenchPart fPartCalleesList;
    private IWorkbenchPart fPartCalleesTree;
    private IWorkbenchPart fPartCallersList;
    private IWorkbenchPart fPartCallersTree;

    public DependenciesView() {
        this.fPartsToPages = new HashMap<IWorkbenchPart, IPageBookViewPage>(4);
        this.fPagesToParts = new HashMap<IPageBookViewPage, IWorkbenchPart>(4);
        this.fInputHistory = new ArrayList();
        this.fLoops = NO_LOOPS;
    }

    private void contributeToActionBars(IActionBars actionBars) {
        this.contributeToLocalToolBar(actionBars.getToolBarManager());
        actionBars.updateActionBars();
    }

    private void contributeToLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator(TREE_ACTION_GROUP));
        manager.add((IContributionItem)new Separator("type"));
        manager.appendToGroup("type", (IAction)this.fShowCallees);
        manager.appendToGroup("type", (IAction)this.fShowCallers);
        manager.add((IContributionItem)new Separator("presentation"));
        manager.appendToGroup("presentation", (IAction)this.fShowTree);
        manager.appendToGroup("presentation", (IAction)this.fShowList);
        manager.add((IContributionItem)new Separator("history"));
        manager.appendToGroup("history", (IAction)this.fShowLoops);
        manager.appendToGroup("history", (IAction)this.fHistoryDropDownAction);
    }

    protected IPage createDefaultPage(PageBook book) {
        return this.createPage(this.getDefaultPart());
    }

    private IWorkbenchPart getDefaultPart() {
        if (this.fPreferences.getBoolean("DependenciesView.show.callers")) {
            if (this.fPreferences.getBoolean("DependenciesView.show.list")) {
                return this.fPartCallersList;
            }
            return this.fPartCallersTree;
        }
        if (this.fPreferences.getBoolean("DependenciesView.show.list")) {
            return this.fPartCalleesList;
        }
        return this.fPartCalleesTree;
    }

    private IPageBookViewPage createPage(IWorkbenchPart part) {
        Page page = part == this.fPartCalleesTree ? new DependenciesViewTreePage(this, new CalleesTreeContentProvider(this)) : (part == this.fPartCalleesList ? new DependenciesViewListPage(this, new CalleesListContentProvider(this)) : (part == this.fPartCallersTree ? new DependenciesViewTreePage(this, new CallersTreeContentProvider(this)) : (part == this.fPartCallersList ? new DependenciesViewListPage(this, new CallersListContentProvider(this)) : new StateViewPage(this))));
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        this.fPartsToPages.put(part, (IPageBookViewPage)page);
        this.fPagesToParts.put((IPageBookViewPage)page, part);
        return page;
    }

    public void createPartControl(Composite parent) {
        this.fShowCallees = new ShowCalleesAction();
        this.fShowCallees.setChecked(!this.fPreferences.getBoolean("DependenciesView.show.callers"));
        this.fShowCallers = new ShowCallersAction();
        this.fShowCallers.setChecked(this.fPreferences.getBoolean("DependenciesView.show.callers"));
        this.fShowTree = new ShowTreeAction();
        this.fShowTree.setChecked(!this.fPreferences.getBoolean("DependenciesView.show.list"));
        this.fShowList = new ShowListAction();
        this.fShowList.setChecked(this.fPreferences.getBoolean("DependenciesView.show.list"));
        this.fShowLoops = new ShowLoopsAction();
        this.fShowLoops.setEnabled(this.fLoops != NO_LOOPS);
        this.fHistoryDropDownAction = new HistoryDropDownAction(this);
        this.fHistoryDropDownAction.setEnabled(!this.fInputHistory.isEmpty());
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.contributeToActionBars(actionBars);
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.dependencies_view");
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IPageBookViewPage page = this.fPartsToPages.get(part);
        if (page == null && !this.fPartsToPages.containsKey(part)) {
            page = this.createPage(part);
        }
        if (page != null) {
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        this.fPartsToPages.remove(part);
    }

    protected IWorkbenchPart getBootstrapPart() {
        return this.getDefaultPart();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        IPluginModelBase plugin;
        super.init(site, memento);
        this.fPartCalleesList = new DummyPart((IWorkbenchPartSite)site);
        this.fPartCalleesTree = new DummyPart((IWorkbenchPartSite)site);
        this.fPartCallersList = new DummyPart((IWorkbenchPartSite)site);
        this.fPartCallersTree = new DummyPart((IWorkbenchPartSite)site);
        if (memento == null) {
            return;
        }
        String id = memento.getString(MEMENTO_KEY_INPUT);
        if (id != null && (plugin = PluginRegistry.findModel((String)id)) != null) {
            this.fInput = plugin;
            this.addHistoryEntry(id);
            this.findLoops();
        }
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof DummyPart;
    }

    public void openTo(Object object) {
        if (object != null && !object.equals(this.fInput) && object instanceof IPluginModelBase) {
            String id = ((IPluginModelBase)object).getPluginBase().getId();
            this.addHistoryEntry(id);
        }
        this.updateInput(object);
    }

    public void openCallersFor(Object object) {
        if (!this.fShowCallers.isChecked() && this.fShowCallees.isChecked()) {
            this.fShowCallers.setChecked(true);
            this.fShowCallees.setChecked(false);
            this.fShowCallers.run();
        }
        this.openTo(object);
    }

    public void openCalleesFor(Object object) {
        if (!this.fShowCallees.isChecked() && this.fShowCallers.isChecked()) {
            this.fShowCallees.setChecked(true);
            this.fShowCallers.setChecked(false);
            this.fShowCallees.run();
        }
        this.openTo(object);
    }

    private void updateInput(Object object) {
        this.fInput = object;
        this.findLoops();
        ((DependenciesViewPage)this.getCurrentPage()).setInput(object);
    }

    private void findLoops() {
        this.fLoops = NO_LOOPS;
        if (this.fInput != null && this.fInput instanceof IPluginModel) {
            BusyIndicator.showWhile((Display)PDEPlugin.getActiveWorkbenchShell().getDisplay(), () -> {
                IPlugin plugin = ((IPluginModel)this.fInput).getPlugin();
                DependencyLoop[] loops = DependencyLoopFinder.findLoops((IPlugin)plugin);
                if (loops.length > 0) {
                    this.fLoops = loops;
                }
            });
        }
        if (this.fShowLoops != null) {
            this.fShowLoops.setEnabled(this.fLoops != NO_LOOPS);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.fInput != null && this.fInput instanceof IPluginModelBase) {
            String inputPluginId = ((IPluginModelBase)this.fInput).getPluginBase().getId();
            memento.putString(MEMENTO_KEY_INPUT, inputPluginId);
        }
    }

    void setPresentation(boolean listNotTree) {
        IWorkbenchPart currentPart = this.getCurrentContributingPart();
        if (listNotTree) {
            if (currentPart == this.fPartCalleesTree) {
                this.partActivated(this.fPartCalleesList);
            } else if (currentPart == this.fPartCallersTree) {
                this.partActivated(this.fPartCallersList);
            }
        } else if (currentPart == this.fPartCalleesList) {
            this.partActivated(this.fPartCalleesTree);
        } else if (currentPart == this.fPartCallersList) {
            this.partActivated(this.fPartCallersTree);
        }
    }

    void setViewType(boolean callers) {
        IWorkbenchPart currentPart = this.getCurrentContributingPart();
        if (callers) {
            if (currentPart == this.fPartCalleesTree) {
                this.partActivated(this.fPartCallersTree);
            } else if (currentPart == this.fPartCalleesList) {
                this.partActivated(this.fPartCallersList);
            }
        } else if (currentPart == this.fPartCallersTree) {
            this.partActivated(this.fPartCalleesTree);
        } else if (currentPart == this.fPartCallersList) {
            this.partActivated(this.fPartCalleesList);
        }
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        IPage p;
        IPage currPage = this.getCurrentPage();
        if (pageRec.page.equals(currPage)) {
            super.showPageRec(pageRec);
            return;
        }
        IStructuredSelection selection = null;
        if (currPage instanceof DependenciesViewPage) {
            selection = ((DependenciesViewPage)currPage).getSelection();
            ((DependenciesViewPage)currPage).setActive(false);
        }
        if ((p = pageRec.page) instanceof DependenciesViewPage) {
            ((DependenciesViewPage)p).setInput(this.fInput);
            ((DependenciesViewPage)p).setActive(true);
        }
        super.showPageRec(pageRec);
        if (p instanceof DependenciesViewPage) {
            this.updateTitle(this.fInput);
            ((DependenciesViewPage)p).setSelection(selection);
        }
    }

    void updateTitle(Object newInput) {
        if (newInput == null) {
            this.updateTitle("");
        } else if (!newInput.equals(PDECore.getDefault().getModelManager())) {
            String name = PDEPlugin.getDefault().getLabelProvider().getText(newInput);
            String title = this.getCurrentContributingPart() == this.fPartCalleesTree ? NLS.bind((String)PDEUIMessages.DependenciesView_callees_tree_title, (Object)name) : (this.getCurrentContributingPart() == this.fPartCalleesList ? NLS.bind((String)PDEUIMessages.DependenciesView_callees_list_title, (Object)name) : (this.getCurrentContributingPart() == this.fPartCallersTree ? NLS.bind((String)PDEUIMessages.DependenciesView_callers_tree_title, (Object)name) : NLS.bind((String)PDEUIMessages.DependenciesView_callers_list_title, (Object)name)));
            if (this.fLoops != NO_LOOPS) {
                title = String.valueOf(title) + " " + PDEUIMessages.DependenciesView_cycles_title;
            }
            this.updateTitle(title);
        }
    }

    void updateTitle(String description) {
        this.setContentDescription(description);
        this.setTitleToolTip(this.getTitle());
    }

    private void addHistoryEntry(String entry) {
        if (this.fInputHistory.contains(entry)) {
            this.fInputHistory.remove(entry);
        }
        this.fInputHistory.add(0, entry);
        if (this.fHistoryDropDownAction != null) {
            this.fHistoryDropDownAction.setEnabled(true);
        }
    }

    private void updateHistoryEntries() {
        int i = this.fInputHistory.size() - 1;
        while (i >= 0) {
            String type = this.fInputHistory.get(i);
            if (PluginRegistry.findModel((String)type) == null) {
                this.fInputHistory.remove(i);
            }
            --i;
        }
        if (this.fHistoryDropDownAction != null) {
            this.fHistoryDropDownAction.setEnabled(!this.fInputHistory.isEmpty());
        }
    }

    public void gotoHistoryEntry(String entry) {
        if (this.fInputHistory.contains(entry)) {
            this.updateInput(PluginRegistry.findModel((String)entry));
        }
    }

    public String[] getHistoryEntries() {
        if (this.fInputHistory.size() > 0) {
            this.updateHistoryEntries();
        }
        return this.fInputHistory.toArray(new String[this.fInputHistory.size()]);
    }

    public void setHistoryEntries(String[] elems) {
        this.fInputHistory.clear();
        String[] stringArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            String elem = stringArray[n2];
            this.fInputHistory.add(elem);
            ++n2;
        }
        this.updateHistoryEntries();
    }

    public String getInput() {
        if (this.fInput != null) {
            return ((IPluginModelBase)this.fInput).getPluginBase().getId();
        }
        return null;
    }

    public boolean isShowingCallers() {
        return this.fPreferences.getBoolean("DependenciesView.show.callers");
    }

    protected void enableStateView(boolean enabled) {
        if (this.fLastDependenciesPart != null) {
            this.partActivated(this.fLastDependenciesPart);
        } else {
            this.partActivated(this.getDefaultPart());
        }
        this.fLastDependenciesPart = null;
        this.getViewSite().getActionBars().getToolBarManager().update(true);
    }

    public void dispose() {
        super.dispose();
        this.fPartCalleesList.dispose();
        this.fPartCalleesTree.dispose();
        this.fPartCallersList.dispose();
        this.fPartCallersTree.dispose();
    }

    static class DummyPart
    implements IWorkbenchPart {
        private IWorkbenchPartSite fSite;

        public DummyPart(IWorkbenchPartSite site) {
            this.fSite = site;
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
            this.fSite = null;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public IWorkbenchPartSite getSite() {
            return this.fSite;
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }
    }

    class ShowCalleesAction
    extends Action {
        public ShowCalleesAction() {
            super("", 8);
            this.setText(PDEUIMessages.DependenciesView_ShowCalleesAction_label);
            this.setDescription(PDEUIMessages.DependenciesView_ShowCalleesAction_description);
            this.setToolTipText(PDEUIMessages.DependenciesView_ShowCalleesAction_tooltip);
            this.setImageDescriptor(PDEPluginImages.DESC_CALLEES);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_CALLEES_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                DependenciesView.this.fPreferences.setValue("DependenciesView.show.callers", false);
                DependenciesView.this.setViewType(false);
            }
        }
    }

    class ShowCallersAction
    extends Action {
        public ShowCallersAction() {
            super("", 8);
            this.setText(PDEUIMessages.DependenciesView_ShowCallersAction_label);
            this.setDescription(PDEUIMessages.DependenciesView_ShowCallersAction_description);
            this.setToolTipText(PDEUIMessages.DependenciesView_ShowCallersAction_tooltip);
            this.setImageDescriptor(PDEPluginImages.DESC_CALLERS);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_CALLERS_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                DependenciesView.this.fPreferences.setValue("DependenciesView.show.callers", true);
                DependenciesView.this.setViewType(true);
            }
        }
    }

    class ShowListAction
    extends Action {
        public ShowListAction() {
            super("", 8);
            this.setText(PDEUIMessages.DependenciesView_ShowListAction_label);
            this.setDescription(PDEUIMessages.DependenciesView_ShowListAction_description);
            this.setToolTipText(PDEUIMessages.DependenciesView_ShowListAction_tooltip);
            this.setImageDescriptor(PDEPluginImages.DESC_FLAT_LAYOUT);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_FLAT_LAYOUT_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                DependenciesView.this.fPreferences.setValue("DependenciesView.show.list", true);
                DependenciesView.this.setPresentation(true);
            }
        }
    }

    class ShowLoopsAction
    extends Action {
        public ShowLoopsAction() {
            super("", 1);
            this.setText(PDEUIMessages.DependenciesView_ShowLoopsAction_label);
            this.setDescription(PDEUIMessages.DependenciesView_ShowLoopsAction_description);
            this.setToolTipText(PDEUIMessages.DependenciesView_ShowLoopsAction_tooltip);
            this.setImageDescriptor(PDEPluginImages.DESC_DEP_LOOP);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_DEP_LOOP_DISABLED);
            this.setEnabled(false);
        }

        public void run() {
            LoopDialog dialog = new LoopDialog(PDEPlugin.getActiveWorkbenchShell(), DependenciesView.this.fLoops);
            dialog.open();
        }
    }

    class ShowTreeAction
    extends Action {
        public ShowTreeAction() {
            super("", 8);
            this.setText(PDEUIMessages.DependenciesView_ShowTreeAction_label);
            this.setDescription(PDEUIMessages.DependenciesView_ShowTreeAction_description);
            this.setToolTipText(PDEUIMessages.DependenciesView_ShowTreeAction_tooltip);
            this.setImageDescriptor(PDEPluginImages.DESC_HIERARCHICAL_LAYOUT);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_HIERARCHICAL_LAYOUT_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                DependenciesView.this.fPreferences.setValue("DependenciesView.show.list", false);
                DependenciesView.this.setPresentation(false);
            }
        }
    }
}

