/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl.functions;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stem.model.ctdl.functions.ExternalFunctionDefinition;
import org.eclipse.stem.model.ctdl.functions.ExternalFunctionsFactory;
import org.eclipse.stem.model.ctdl.functions.FunctionArgument;
import org.eclipse.stem.model.ctdl.functions.FunctionArgumentReference;
import org.eclipse.stem.model.ctdl.functions.FunctionDefinitionException;
import org.eclipse.stem.model.ctdl.functions.JavaMethodArgument;
import org.eclipse.stem.model.ctdl.functions.STEMDSLUtils;
import org.eclipse.stem.model.ctdl.functions.SystemArgumentReference;

public class FunctionDefinitionLoader {
    public static final String EXTENSION_POINT_NAME = "org.eclipse.stem.model.ctdl.functions.functions";
    private static FunctionDefinitionLoader INSTANCE;
    private Map<String, List<ExternalFunctionDefinition>> functionDefinitions = new HashMap<String, List<ExternalFunctionDefinition>>();
    private ResourceSet resourceSet;
    private Resource defaultResource;

    private FunctionDefinitionLoader() {
        this.load();
    }

    public static synchronized FunctionDefinitionLoader getInstance() {
        INSTANCE = new FunctionDefinitionLoader();
        return INSTANCE;
    }

    public Map<String, List<ExternalFunctionDefinition>> getDefinitions() {
        return Collections.unmodifiableMap(this.functionDefinitions);
    }

    private void load() {
        IConfigurationElement[] extensions;
        this.resourceSet = new ResourceSetImpl();
        this.defaultResource = this.resourceSet.createResource(URI.createURI((String)"empty.extFunc"));
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_NAME);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            ExternalFunctionDefinition functionDef = this.getDefinitionForExtension(extension);
            if (functionDef != null) {
                List<ExternalFunctionDefinition> definitionsByName = this.functionDefinitions.get(functionDef.getName());
                if (definitionsByName == null) {
                    definitionsByName = new ArrayList<ExternalFunctionDefinition>();
                    this.functionDefinitions.put(functionDef.getName(), definitionsByName);
                }
                definitionsByName.add(functionDef);
            }
            ++n2;
        }
    }

    private ExternalFunctionDefinition getDefinitionForExtension(IConfigurationElement functionDef) {
        ExternalFunctionDefinition functionDefinition = ExternalFunctionsFactory.eINSTANCE.createExternalFunctionDefinition();
        functionDefinition.setName(functionDef.getAttribute("name"));
        functionDefinition.setClassName(functionDef.getAttribute("className"));
        functionDefinition.setMethodName(functionDef.getAttribute("methodName"));
        functionDefinition.setExtPointDefinition(functionDef);
        try {
            this.populateFunctionArguments(functionDefinition);
            this.populateMethodArguments(functionDefinition);
            this.validateClassAndMethodSignature(functionDefinition);
        }
        catch (FunctionDefinitionException fde) {
            fde.printStackTrace();
            return null;
        }
        this.defaultResource.getContents().add((Object)functionDefinition);
        return functionDefinition;
    }

    private void populateFunctionArguments(ExternalFunctionDefinition definition) {
        IConfigurationElement[] functionParamBlocks = definition.getExtPointDefinition().getChildren("functionParams");
        if (functionParamBlocks.length > 0) {
            IConfigurationElement[] args;
            IConfigurationElement[] iConfigurationElementArray = args = functionParamBlocks[0].getChildren("functionParam");
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement arg = iConfigurationElementArray[n2];
                FunctionArgument fa = ExternalFunctionsFactory.eINSTANCE.createFunctionArgument();
                fa.setName(arg.getAttribute("name"));
                fa.setType(arg.getAttribute("type"));
                definition.getFunctionArguments().add((Object)fa);
                ++n2;
            }
        }
    }

    private void populateMethodArguments(ExternalFunctionDefinition definition) throws FunctionDefinitionException {
        IConfigurationElement[] generatedParamBlocks = definition.getExtPointDefinition().getChildren("generatedParams");
        if (generatedParamBlocks.length > 0) {
            IConfigurationElement[] args;
            IConfigurationElement[] iConfigurationElementArray = args = generatedParamBlocks[0].getChildren("generatedParam");
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement arg = iConfigurationElementArray[n2];
                String mapsFrom = arg.getAttribute("mapsFrom");
                FunctionArgument fa = this.getParameterByName(mapsFrom, definition);
                if (fa != null) {
                    FunctionArgumentReference ref = ExternalFunctionsFactory.eINSTANCE.createFunctionArgumentReference();
                    ref.setArgIndex(definition.getFunctionArguments().indexOf((Object)fa));
                    ref.setRef(fa);
                    ref.setType(fa.getType());
                    definition.getJavaMethodArguments().add((Object)ref);
                } else {
                    Class<?> globalType = STEMDSLUtils.getGlobalSystemVariables().get(mapsFrom);
                    if (globalType == null) {
                        globalType = STEMDSLUtils.getGlobalUserVariables().get(mapsFrom);
                    }
                    if (globalType == null) {
                        throw new FunctionDefinitionException("Unable to find parameter mapping for method parameter key " + mapsFrom, definition);
                    }
                    SystemArgumentReference ref = ExternalFunctionsFactory.eINSTANCE.createSystemArgumentReference();
                    ref.setMapsFrom(mapsFrom);
                    ref.setType(globalType.getName());
                    definition.getJavaMethodArguments().add((Object)ref);
                }
                ++n2;
            }
        }
    }

    private void validateClassAndMethodSignature(ExternalFunctionDefinition definition) throws FunctionDefinitionException {
        CoreException parent = null;
        Class<?> functionClass = null;
        try {
            functionClass = Class.forName(definition.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (functionClass == null) {
            try {
                Object classInstance = definition.getExtPointDefinition().createExecutableExtension("className");
                if (classInstance != null) {
                    functionClass = classInstance.getClass();
                }
            }
            catch (CoreException e) {
                parent = e;
            }
        }
        definition.setClass(functionClass);
        if (definition.getClass_() == null) {
            throw new FunctionDefinitionException("Could not instantiate instance of function definition class for function " + definition.getName(), definition, parent);
        }
        String[] declaredParams = this.getJavaMethodArgTypes(definition);
        Method foundMethod = null;
        Method[] methodArray = functionClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] methodParams;
            Method method = methodArray[n2];
            if (method.getName().equals(definition.getMethodName()) && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()) && (methodParams = method.getParameterTypes()).length == declaredParams.length) {
                boolean match = true;
                int idx = 0;
                while (idx < methodParams.length) {
                    if (!this.methodParameterMatch(methodParams[idx], declaredParams[idx])) {
                        match = false;
                        break;
                    }
                    ((JavaMethodArgument)definition.getJavaMethodArguments().get(idx)).setJavaType(methodParams[idx]);
                    ++idx;
                }
                if (match) {
                    foundMethod = method;
                    break;
                }
            }
            ++n2;
        }
        definition.setMethod(foundMethod);
        if (definition.getMethod() == null) {
            throw new FunctionDefinitionException("Could not find an appropriate class method for definition " + definition.getName(), definition);
        }
    }

    private boolean methodParameterMatch(Class<?> methodParam, String declaredParam) {
        if (methodParam.getName().equals(declaredParam)) {
            return true;
        }
        return declaredParam.equals("compartment") && (methodParam == Double.TYPE || methodParam == EAttribute.class);
    }

    private String[] getJavaMethodArgTypes(ExternalFunctionDefinition definition) throws FunctionDefinitionException {
        String[] types = new String[definition.getJavaMethodArguments().size()];
        int idx = 0;
        for (JavaMethodArgument arg : definition.getJavaMethodArguments()) {
            types[idx++] = arg.getType();
        }
        return types;
    }

    private FunctionArgument getParameterByName(String name, ExternalFunctionDefinition def) {
        for (FunctionArgument param : def.getFunctionArguments()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }
}

