/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.predicate.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.predicate.ModulusTimeTest;
import org.eclipse.stem.core.predicate.PredicatePackage;
import org.eclipse.stem.core.predicate.impl.TimeTestImpl;

public class ModulusTimeTestImpl
extends TimeTestImpl
implements ModulusTimeTest {
    protected static final int MODULUS_DAYS_EDEFAULT = 365;
    protected int modulusDays = 365;
    protected static final boolean REFERENCE_TIME_VALID_EDEFAULT = false;
    protected boolean referenceTimeValid = false;
    protected static final int DURATION_EDEFAULT = 1;
    protected int duration = 1;
    protected STEMTime referenceTime;
    protected STEMTime triggerTime;

    protected ModulusTimeTestImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PredicatePackage.Literals.MODULUS_TIME_TEST;
    }

    @Override
    public int getModulusDays() {
        return this.modulusDays;
    }

    @Override
    public void setModulusDays(int newModulusDays) {
        int oldModulusDays = this.modulusDays;
        this.modulusDays = newModulusDays;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldModulusDays, this.modulusDays));
        }
    }

    @Override
    public boolean isReferenceTimeValid() {
        return this.referenceTimeValid;
    }

    @Override
    public void setReferenceTimeValid(boolean newReferenceTimeValid) {
        boolean oldReferenceTimeValid = this.referenceTimeValid;
        this.referenceTimeValid = newReferenceTimeValid;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldReferenceTimeValid, this.referenceTimeValid));
        }
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(int newDuration) {
        int oldDuration = this.duration;
        this.duration = newDuration;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldDuration, this.duration));
        }
    }

    @Override
    public STEMTime getReferenceTime() {
        return this.referenceTime;
    }

    public NotificationChain basicSetReferenceTime(STEMTime newReferenceTime, NotificationChain msgs) {
        STEMTime oldReferenceTime = this.referenceTime;
        this.referenceTime = newReferenceTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldReferenceTime, (Object)newReferenceTime);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setReferenceTime(STEMTime newReferenceTime) {
        if (newReferenceTime != this.referenceTime) {
            NotificationChain msgs = null;
            if (this.referenceTime != null) {
                msgs = ((InternalEObject)this.referenceTime).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newReferenceTime != null) {
                msgs = ((InternalEObject)newReferenceTime).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetReferenceTime(newReferenceTime, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newReferenceTime, (Object)newReferenceTime));
        }
    }

    @Override
    public STEMTime getTriggerTime() {
        return this.triggerTime;
    }

    public NotificationChain basicSetTriggerTime(STEMTime newTriggerTime, NotificationChain msgs) {
        STEMTime oldTriggerTime = this.triggerTime;
        this.triggerTime = newTriggerTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldTriggerTime, (Object)newTriggerTime);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTriggerTime(STEMTime newTriggerTime) {
        if (newTriggerTime != this.triggerTime) {
            NotificationChain msgs = null;
            if (this.triggerTime != null) {
                msgs = ((InternalEObject)this.triggerTime).eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newTriggerTime != null) {
                msgs = ((InternalEObject)newTriggerTime).eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetTriggerTime(newTriggerTime, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newTriggerTime, (Object)newTriggerTime));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetReferenceTime(null, msgs);
            }
            case 4: {
                return this.basicSetTriggerTime(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getModulusDays();
            }
            case 1: {
                return this.isReferenceTimeValid();
            }
            case 2: {
                return this.getDuration();
            }
            case 3: {
                return this.getReferenceTime();
            }
            case 4: {
                return this.getTriggerTime();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setModulusDays((Integer)newValue);
                return;
            }
            case 1: {
                this.setReferenceTimeValid((Boolean)newValue);
                return;
            }
            case 2: {
                this.setDuration((Integer)newValue);
                return;
            }
            case 3: {
                this.setReferenceTime((STEMTime)newValue);
                return;
            }
            case 4: {
                this.setTriggerTime((STEMTime)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setModulusDays(365);
                return;
            }
            case 1: {
                this.setReferenceTimeValid(false);
                return;
            }
            case 2: {
                this.setDuration(1);
                return;
            }
            case 3: {
                this.setReferenceTime(null);
                return;
            }
            case 4: {
                this.setTriggerTime(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.modulusDays != 365;
            }
            case 1: {
                return this.referenceTimeValid;
            }
            case 2: {
                return this.duration != 1;
            }
            case 3: {
                return this.referenceTime != null;
            }
            case 4: {
                return this.triggerTime != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean evaluate(STEMTime time, long timerPeriod, Graph graph) {
        boolean retValue = false;
        if (this.isReferenceTimeValid()) {
            boolean returnValue;
            if (this.getTriggerTime() != null) {
                boolean returnValue2;
                long elapsedTimeSinceTriggeredMS = time.getTime().getTime() - this.getTriggerTime().getTime().getTime();
                int elapsedTimeDays = (int)(elapsedTimeSinceTriggeredMS / STEMTime.Units.DAY.getMilliseconds());
                boolean bl = returnValue2 = elapsedTimeDays < this.getDuration();
                if (!returnValue2) {
                    this.setTriggerTime(null);
                }
                return returnValue2;
            }
            long elapsedTimeMS = time.getTime().getTime() - this.getReferenceTime().getTime().getTime();
            int elapsedTimeDays = (int)(elapsedTimeMS / STEMTime.Units.DAY.getMilliseconds());
            boolean bl = returnValue = elapsedTimeDays % this.getModulusDays() == 0;
            if (returnValue) {
                STEMTime triggerTime = (STEMTime)EcoreUtil.copy((EObject)time);
                this.setTriggerTime(triggerTime);
            }
            return returnValue;
        }
        STEMTime newTime = (STEMTime)EcoreUtil.copy((EObject)time);
        newTime = newTime.addIncrement(-timerPeriod);
        this.setReferenceTime(newTime);
        this.setReferenceTimeValid(true);
        return this.evaluate(time, timerPeriod, graph);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (modulusDays: ");
        result.append(this.modulusDays);
        result.append(", referenceTimeValid: ");
        result.append(this.referenceTimeValid);
        result.append(", duration: ");
        result.append(this.duration);
        result.append(')');
        return result.toString();
    }
}

