/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.ui.adapters.color.STEMColor;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.AggregateValueHistoryPlotter;
import org.eclipse.stem.ui.reports.views.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class AggregateTimeSeriesCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private AggregateValueHistoryPlotter control = null;
    private static final String defaultKey = "ref";
    private static final String DEFAULT_PROPERTY = "I";
    private boolean overlayMode = false;
    Menu popUpMenu = null;
    private LinearScaleAction linearTimeAction;
    private LogScaleAction logTimeAction;
    protected boolean useLinearTimeScale = true;
    private LegendViewAction viewLegend;
    private ClearAction clearAction;
    private LegendHideAction hideLegend;
    protected boolean showLegend = true;
    protected Legend legend = null;
    final MenuManager contextMenuManager = new MenuManager();
    protected final Map<String, DataSeries> dataSeriesMap = new HashMap<String, DataSeries>();
    private final List<Double> cycleNumbers = new ArrayList<Double>();
    Generator gr;
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    double maxY = -1.0;
    private double minYscale = 1.0E-7;
    public String Ordinate_LEGEND = "Time";
    public String Ordinate_AXIS = "";
    protected final ColorDefinition[] colorDefault = new ColorDefinition[]{ColorDefinitionImpl.RED(), ColorDefinitionImpl.ORANGE(), ColorDefinitionImpl.YELLOW(), ColorDefinitionImpl.GREEN(), ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.CYAN(), ColorDefinitionImpl.PINK()};
    final ColorDefinition TEXT_COLOR = ColorDefinitionImpl.create((int)0, (int)0, (int)0);
    final ColorDefinition FRAME_COLOR = ColorDefinitionImpl.create((int)230, (int)230, (int)255);
    final ColorDefinition BACKGROUND_COLOR = ColorDefinitionImpl.create((int)255, (int)255, (int)255);
    protected int seriesCount = 0;
    Image imgChart = null;

    public AggregateTimeSeriesCanvas(AggregateValueHistoryPlotter reportControl) {
        super((Composite)reportControl, 0x20000800);
        this.setOverlayMode(false);
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError("Problem initializing chart", pex);
            return;
        }
        this.setControl(reportControl);
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, this.cycleNumbers, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (AggregateTimeSeriesCanvas.this.imgChart != null) {
                    AggregateTimeSeriesCanvas.this.imgChart.dispose();
                }
                AggregateTimeSeriesCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                AggregateTimeSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)AggregateTimeSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)AggregateTimeSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    AggregateTimeSeriesCanvas.this.gr.render(AggregateTimeSeriesCanvas.this.idr, AggregateTimeSeriesCanvas.this.gr.build(AggregateTimeSeriesCanvas.this.idr.getDisplayServer(), AggregateTimeSeriesCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(AggregateTimeSeriesCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError("Problem rendering chart", ce);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public void draw() {
        int maxLines = this.getControl().getNumProperties();
        int i = 0;
        while (i < maxLines) {
            DataSeries series;
            String property = this.getControl().getProperty(i);
            if (!this.dataSeriesMap.containsKey(property)) {
                series = new DataSeries(property, this.getOverlayMode(), this.seriesCount);
                this.dataSeriesMap.put(property, series);
            }
            if ((series = this.dataSeriesMap.get(property)).isVisible()) {
                series.show();
            } else {
                series.hide();
            }
            ++i;
        }
        this.resetData();
        this.updateContextMenu((Composite)this);
        this.maxY = -1.0;
        boolean setCycles = false;
        int maxPoints = 0;
        int i2 = 0;
        while (i2 < maxLines) {
            String property = this.getControl().getProperty(i2);
            double[] doubleValues = this.getControl().getValues(property);
            DataSeries series = this.dataSeriesMap.get(property);
            int j = 0;
            while (j < doubleValues.length) {
                if (doubleValues[j] <= this.minYscale && doubleValues[j] > 0.0) {
                    this.minYscale = doubleValues[j];
                }
                if (doubleValues[j] >= this.maxY) {
                    if (series.isVisible()) {
                        this.maxY = doubleValues[j];
                    }
                    double log = Math.floor(Math.log10(this.maxY));
                    double adjustedMax = Math.ceil(this.maxY / Math.pow(10.0, log)) * Math.pow(10.0, log);
                    if (this.useLinearTimeScale) {
                        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)adjustedMax));
                        double step = adjustedMax / 10.0;
                        this.yAxisPrimary.getScale().setStep(step);
                    } else {
                        double ymax = Math.log(adjustedMax);
                        if (adjustedMax > 1.0) {
                            long imax = Math.round(ymax += 0.499);
                            ymax = imax;
                        }
                        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)ymax));
                        double step = ymax / 10.0;
                        if (step > 0.0) {
                            this.yAxisPrimary.getScale().setStep(step);
                        }
                    }
                }
                ++j;
            }
            if (doubleValues.length > 0) {
                if (maxPoints < doubleValues.length) {
                    maxPoints = doubleValues.length;
                }
                int cycleNumber = 0;
                while (cycleNumber < maxPoints) {
                    double displayValue = doubleValues[cycleNumber];
                    if (displayValue <= this.minYscale) {
                        displayValue = this.minYscale;
                    }
                    Double value = this.useLinearTimeScale ? Double.valueOf(displayValue) : Double.valueOf(Math.log(displayValue));
                    series.addValue(value);
                    if (!setCycles) {
                        this.cycleNumbers.add(Double.valueOf(cycleNumber));
                    }
                    ++cycleNumber;
                }
                setCycles = true;
            }
            ++i2;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public final Chart createSimpleLineChart(Map<String, DataSeries> dataSeriesMap, List<Double> cycleNumbers, String seriesIdentifier) {
        ChartWithAxes retValue = ChartWithAxesImpl.create();
        retValue.getBlock().setBackground((Fill)this.FRAME_COLOR);
        Plot p = retValue.getPlot();
        p.getClientArea().setBackground((Fill)this.BACKGROUND_COLOR);
        retValue.getTitle().setVisible(false);
        this.legend = retValue.getLegend();
        LineAttributes lia = this.legend.getOutline();
        this.legend.getText().getFont().setSize(8.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        this.legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        this.legend.getOutline().setVisible(false);
        this.legend.setAnchor(Anchor.NORTH_LITERAL);
        this.legend.setPosition(Position.BELOW_LITERAL);
        this.legend.getText().setColor(this.TEXT_COLOR);
        this.legend.getOutline().setColor(this.TEXT_COLOR);
        this.xAxisPrimary = retValue.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().setVisible(false);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getTitle().getCaption().setColor(this.TEXT_COLOR);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.TEXT_COLOR);
        Series xAxisSeries = SeriesImpl.create();
        xAxisSeries.getLabel().getCaption().setColor(this.TEXT_COLOR);
        xAxisSeries.getLabel().getOutline().setColor(this.TEXT_COLOR);
        NumberDataSet xValues = NumberDataSetImpl.create(cycleNumbers);
        xAxisSeries.setDataSet((DataSet)xValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        this.xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)xAxisSeries);
        this.yAxisPrimary = retValue.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.TEXT_COLOR);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.xAxisPrimary.getTitle().getCaption().setValue(Messages.getString("TS.TIMELABEL"));
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getLabel().getCaption().setColor(this.TEXT_COLOR);
        this.yAxisPrimary.getTitle().getCaption().setValue(this.Ordinate_AXIS);
        this.yAxisPrimary.getTitle().setVisible(true);
        if (!dataSeriesMap.containsKey(defaultKey)) {
            DataSeries series = new DataSeries(defaultKey, this.getOverlayMode(), this.seriesCount);
            dataSeriesMap.put(defaultKey, series);
        }
        return retValue;
    }

    private void createContextMenu(Composite parent) {
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        this.contextMenuManager.add((IAction)this.linearTimeAction);
        this.contextMenuManager.add((IAction)this.logTimeAction);
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        this.contextMenuManager.add((IAction)this.viewLegend);
        this.contextMenuManager.add((IAction)this.hideLegend);
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.popUpMenu = this.contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(this.popUpMenu);
    }

    private void updateContextMenu(Composite parent) {
        if (this.popUpMenu == null) {
            return;
        }
        this.popUpMenu.dispose();
        this.contextMenuManager.removeAll();
        if (this.linearTimeAction == null) {
            this.linearTimeAction = new LinearScaleAction();
        }
        if (this.logTimeAction == null) {
            this.logTimeAction = new LogScaleAction();
        }
        this.contextMenuManager.add((IAction)this.linearTimeAction);
        this.contextMenuManager.add((IAction)this.logTimeAction);
        this.contextMenuManager.update();
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        this.contextMenuManager.add((IAction)this.viewLegend);
        this.contextMenuManager.add((IAction)this.hideLegend);
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.clearAction = new ClearAction();
        this.contextMenuManager.add((IAction)this.clearAction);
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        int i = 0;
        while (i < this.getControl().getNumProperties()) {
            String nextProp = this.getControl().getProperty(i);
            DataSeries series = this.dataSeriesMap.get(nextProp);
            DisplayableProperty property = new DisplayableProperty(nextProp, series.isVisible());
            this.contextMenuManager.add((IAction)property);
            ++i;
        }
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        Menu popUpMenu = this.contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(popUpMenu);
    }

    public static void setColorDefs(List<String> propertiesToPlot, List<LineSeries> lsList) {
        Map colorMap = VisualizationPreferencePage.getColorMapping();
        int i = 0;
        while (i < lsList.size()) {
            ColorDefinition color = ColorDefinitionImpl.WHITE();
            if (propertiesToPlot != null && propertiesToPlot.size() > i) {
                String key = propertiesToPlot.get(i);
                if (colorMap.containsKey(key)) {
                    STEMColor c = (STEMColor)colorMap.get(key);
                    color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                }
                lsList.get(i).setSeriesIdentifier((Object)key);
                lsList.get(i).getLineAttributes().setColor(color);
            } else if (lsList.get(i) != null) {
                lsList.get(i).setSeriesIdentifier((Object)" ");
                lsList.get(i).getLineAttributes().setColor(color);
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
        this.cycleNumbers.add(0.0);
    }

    private void clearData() {
        Iterator<String> iter = this.dataSeriesMap.keySet().iterator();
        while (iter != null && iter.hasNext()) {
            String key = iter.next();
            DataSeries series = this.dataSeriesMap.get(key);
            series.relativeValues.clear();
            series.addValue(0.0);
        }
        this.cycleNumbers.clear();
    }

    void toggleAxisScale() {
        if (this.useLinearTimeScale) {
            this.logTimeAction.setChecked(true);
            this.linearTimeAction.setChecked(false);
            this.yAxisPrimary.getScale().setMin(null);
            this.yAxisPrimary.getScale().setMax(null);
            this.yAxisPrimary.getScale().unsetStep();
            this.yAxisPrimary.getScale().unsetStepNumber();
        } else {
            this.logTimeAction.setChecked(false);
            this.linearTimeAction.setChecked(true);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.yAxisPrimary.getScale().setStep(0.25);
        }
        this.useLinearTimeScale = !this.useLinearTimeScale;
        this.draw();
    }

    void toggleLegend() {
        if (this.showLegend) {
            this.viewLegend.setChecked(false);
            this.hideLegend.setChecked(true);
            this.legend.setVisible(false);
        } else {
            this.viewLegend.setChecked(true);
            this.hideLegend.setChecked(false);
            this.legend.setVisible(true);
        }
        this.showLegend = !this.showLegend;
        this.draw();
    }

    public void setMinYscale(double minYscale) {
        this.minYscale = minYscale;
    }

    public boolean getOverlayMode() {
        return this.overlayMode;
    }

    public void setOverlayMode(boolean overlayMode) {
        this.overlayMode = overlayMode;
    }

    public AggregateValueHistoryPlotter getControl() {
        return this.control;
    }

    public void setControl(AggregateValueHistoryPlotter control) {
        this.control = control;
    }

    protected class ClearAction
    extends Action {
        public ClearAction() {
            super(Messages.getString("ContextMenu.Clear"), 1);
        }

        public String getText() {
            return Messages.getString("ContextMenu.Clear");
        }

        public void run() {
            int maxLines = AggregateTimeSeriesCanvas.this.getControl().getNumProperties();
            int i = 0;
            while (i < maxLines) {
                DataSeries series;
                String property = AggregateTimeSeriesCanvas.this.getControl().getProperty(i);
                if (!AggregateTimeSeriesCanvas.this.dataSeriesMap.containsKey(property)) {
                    series = new DataSeries(property, AggregateTimeSeriesCanvas.this.getOverlayMode(), AggregateTimeSeriesCanvas.this.seriesCount);
                    AggregateTimeSeriesCanvas.this.dataSeriesMap.put(property, series);
                }
                if ((series = AggregateTimeSeriesCanvas.this.dataSeriesMap.get(property)).isVisible()) {
                    series.hide();
                }
                ++i;
            }
        }
    }

    protected class DataSeries {
        public String propertyName = "";
        public List<Double> relativeValues = new ArrayList<Double>();
        public LineSeries lineSeries = null;
        private boolean visible = true;
        private SeriesDefinition sdY = null;
        private boolean overlayMode = false;
        private int seriesIndex = 0;

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean state) {
            this.visible = state;
        }

        public void toggleVisible() {
            this.visible = !this.visible;
        }

        public DataSeries(String propertyName, boolean overlay, int index) {
            this.propertyName = propertyName;
            this.overlayMode = overlay;
            this.seriesIndex = index;
            ++AggregateTimeSeriesCanvas.this.seriesCount;
            this.relativeValues = new ArrayList<Double>();
            this.relativeValues.add(0.0);
            this.addLineSeries(propertyName);
            if (!this.propertyName.equalsIgnoreCase(AggregateTimeSeriesCanvas.defaultKey) && !this.propertyName.equalsIgnoreCase(AggregateTimeSeriesCanvas.DEFAULT_PROPERTY)) {
                this.visible = false;
            }
        }

        public void addValue(Double val) {
            if (this.relativeValues == null) {
                this.relativeValues = new ArrayList<Double>();
            }
            this.relativeValues.add(val);
        }

        public void addValue(int time, Double val) {
            if (this.relativeValues == null) {
                this.relativeValues = new ArrayList<Double>();
            }
            this.relativeValues.add(time, val);
        }

        public void addLineSeries(String propertyName) {
            NumberDataSet orthoValues = NumberDataSetImpl.create(this.relativeValues);
            if (this.lineSeries == null) {
                this.lineSeries = (ScatterSeries)ScatterSeriesImpl.create();
            }
            this.lineSeries.setDataSet((DataSet)orthoValues);
            this.lineSeries.getLineAttributes().setVisible(true);
            if (!this.lineSeries.getMarkers().isEmpty()) {
                Marker marker = (Marker)this.lineSeries.getMarkers().get(0);
                marker.setVisible(false);
            }
            this.setColorDefs(propertyName);
            this.sdY = SeriesDefinitionImpl.create();
            this.sdY.getSeriesPalette().update(-2);
            this.sdY.getSeries().add((Object)this.lineSeries);
            AggregateTimeSeriesCanvas.this.yAxisPrimary.getSeriesDefinitions().add((Object)this.sdY);
        }

        public void hide() {
            this.lineSeries.setVisible(false);
            this.visible = false;
        }

        public void show() {
            this.lineSeries.setVisible(true);
            this.visible = true;
        }

        private void setColorDefs(String propertyName) {
            Object color;
            this.lineSeries.setSeriesIdentifier((Object)propertyName);
            this.lineSeries.setPaletteLineColor(false);
            Map colorMap = VisualizationPreferencePage.getColorMapping();
            boolean colorSet = false;
            if (colorMap != null && colorMap.size() >= 1 && propertyName != null && propertyName.length() >= 1) {
                if (colorMap.containsKey(propertyName)) {
                    STEMColor c = (STEMColor)colorMap.get(propertyName);
                    color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                    this.lineSeries.getLineAttributes().setColor((ColorDefinition)color);
                    colorSet = true;
                } else {
                    for (String key : colorMap.keySet()) {
                        if (key.length() < 1 || !propertyName.substring(0, 1).equalsIgnoreCase(key.substring(0, 1))) continue;
                        STEMColor c = (STEMColor)colorMap.get(key);
                        ColorDefinition color2 = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                        this.lineSeries.getLineAttributes().setColor(color2);
                        colorSet = true;
                        break;
                    }
                }
            }
            if (!colorSet) {
                int colorIndex = this.seriesIndex % AggregateTimeSeriesCanvas.this.colorDefault.length;
                color = AggregateTimeSeriesCanvas.this.colorDefault[colorIndex];
                this.lineSeries.getLineAttributes().setColor((ColorDefinition)color);
            }
        }

        public int getDataSize() {
            return this.relativeValues.size();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public List<Double> getRelativeValues() {
            return this.relativeValues;
        }

        public void setRelativeValues(List<Double> relativeValues) {
            this.relativeValues = relativeValues;
        }

        public void setLineSeries(LineSeries lineSeries) {
            this.lineSeries = lineSeries;
        }
    }

    protected class DisplayableProperty
    extends Action {
        String property;

        public DisplayableProperty(String property, boolean visibility) {
            super(property, 2);
            this.property = null;
            this.property = property;
            this.setChecked(visibility);
        }

        public String getText() {
            return this.property;
        }

        public void run() {
            DataSeries series = AggregateTimeSeriesCanvas.this.dataSeriesMap.get(this.property);
            series.toggleVisible();
            AggregateTimeSeriesCanvas.this.dataSeriesMap.put(this.property, series);
            this.setChecked(series.isVisible());
            AggregateTimeSeriesCanvas.this.draw();
        }
    }

    class LegendHideAction
    extends Action {
        public LegendHideAction() {
            super(Messages.getString("ContextMenu.HideLegend"), 2);
            this.setChecked(!AggregateTimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.HideLegend");
        }

        public void run() {
            if (!AggregateTimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                AggregateTimeSeriesCanvas.this.toggleLegend();
            }
            AggregateTimeSeriesCanvas.this.draw();
        }
    }

    protected class LegendViewAction
    extends Action {
        public LegendViewAction() {
            super(Messages.getString("ContextMenu.ShowLegend"), 2);
            this.setChecked(AggregateTimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.ShowLegend");
        }

        public void run() {
            if (AggregateTimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                AggregateTimeSeriesCanvas.this.toggleLegend();
            }
            AggregateTimeSeriesCanvas.this.draw();
        }
    }

    protected class LinearScaleAction
    extends Action {
        public LinearScaleAction() {
            super(Messages.getString("ContextMenu.LinearTimeScale"), 2);
            this.setChecked(AggregateTimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearTimeScale");
        }

        public void run() {
            if (AggregateTimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                AggregateTimeSeriesCanvas.this.toggleAxisScale();
            }
            AggregateTimeSeriesCanvas.this.draw();
        }
    }

    class LogScaleAction
    extends Action {
        public LogScaleAction() {
            super(Messages.getString("ContextMenu.LogTimeScale"), 2);
            this.setChecked(!AggregateTimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogTimeScale");
        }

        public void run() {
            if (!AggregateTimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                AggregateTimeSeriesCanvas.this.toggleAxisScale();
            }
            AggregateTimeSeriesCanvas.this.draw();
        }
    }
}

