/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.analysis.DiseaseType;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.views.EstimatorControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class ParameterEstimatorWizard
extends Wizard {
    protected ParameterEstimatorWizardSelectFolderPage selectFolderPage;
    protected ParameterEstimatorWizardSelectEstimatorPage selectEstimatorPage;
    protected IWorkbench workbench;
    EstimatorControl estimatorControl;
    ReferenceScenarioDataMapImpl referenceScenarioDataMap;
    public ParameterEstimatorMethod parameterEstimatorMethod;
    private String initDir = null;

    public ParameterEstimatorWizard(EstimatorControl ctrl, String initDir) {
        this.estimatorControl = ctrl;
        this.initDir = initDir;
        this.setForcePreviousAndNextButtons(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle("Create Parameter Estimator");
    }

    public boolean performFinish() {
        EstimatorControl.text1.setText(this.selectFolderPage.getDirName());
        EstimatorControl.estimatorText.setText(this.parameterEstimatorMethod.getName());
        this.estimatorControl.enableAnalysis(true);
        return true;
    }

    public ReferenceScenarioDataMapImpl getReferenceScenarioDataMap() {
        return this.referenceScenarioDataMap;
    }

    public ParameterEstimatorMethod getParameterEstimatorMethod() {
        return this.parameterEstimatorMethod;
    }

    public void createPageControls(Composite pageContainer) {
    }

    public void addPages() {
        this.selectFolderPage = new ParameterEstimatorWizardSelectFolderPage("Folder");
        this.selectFolderPage.setTitle(Messages.getString("EST.WIZARDPAGE1TITLE"));
        this.selectFolderPage.setDescription("");
        this.selectFolderPage.setDirName(this.initDir);
        this.addPage((IWizardPage)this.selectFolderPage);
    }

    public static class ParameterEstimatorWizardSelectEstimatorPage
    extends WizardPage {
        public ParameterEstimatorWizardSelectEstimatorPage(String pageId) {
            super(pageId);
        }

        protected boolean validatePage() {
            return ((ParameterEstimatorWizard)this.getWizard()).parameterEstimatorMethod != null;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(Messages.getString("EST.PARAMESTLABEL"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            Label descriptionLabel = new Label(composite, 16384);
            descriptionLabel.setText("");
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            descriptionLabel.setLayoutData((Object)data2);
            boolean first = true;
            ParameterEstimatorMethod[] parameterEstimatorMethodArray = ParameterEstimatorMethod.values();
            int n = parameterEstimatorMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterEstimatorMethod method = parameterEstimatorMethodArray[n2];
                DiseaseType dataType = ((ParameterEstimatorWizard)this.getWizard()).referenceScenarioDataMap.getType();
                if (method.getType() == dataType) {
                    Button button = new Button(composite, 16);
                    button.setText(method.getName());
                    if (first) {
                        button.setSelection(true);
                        ((ParameterEstimatorWizard)this.getWizard()).parameterEstimatorMethod = method;
                        descriptionLabel.setText(method.getDescription());
                        first = false;
                    }
                    final ParameterEstimatorWizard wizard = (ParameterEstimatorWizard)this.getWizard();
                    final ParameterEstimatorMethod currentMethod = method;
                    final Label descLabel = descriptionLabel;
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            wizard.parameterEstimatorMethod = currentMethod;
                            descLabel.setText(currentMethod.getDescription());
                            wizard.getContainer().updateButtons();
                        }
                    });
                }
                ++n2;
            }
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        public boolean canFlipToNextPage() {
            return false;
        }

        public boolean isPageComplete() {
            return this.validatePage();
        }
    }

    public class ParameterEstimatorWizardSelectFolderPage
    extends WizardPage {
        Text folderText;
        private String directory;

        public ParameterEstimatorWizardSelectFolderPage(String pageId) {
            super(pageId);
            this.folderText = null;
        }

        protected boolean validatePage() {
            return true;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(Messages.getString("EST.SCFOLDER"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.folderText = new Text(composite, 16384);
            this.folderText.setText(this.getDirName());
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.minimumWidth = 100;
            this.folderText.setLayoutData((Object)data);
            Button selectFolderButton = new Button(composite, 16384);
            selectFolderButton.setText(Messages.getString("EST.SELECTFOLDEBUTTON"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            selectFolderButton.setLayoutData((Object)data2);
            final Shell shell = this.getShell();
            selectFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                    dd.setText(Messages.getString("EST.SELECTFOLDEDIALOGTITLE"));
                    dd.setFilterPath(ParameterEstimatorWizardSelectFolderPage.this.folderText.getText());
                    String selected = dd.open();
                    if (selected != null) {
                        ParameterEstimatorWizardSelectFolderPage.this.folderText.setText(selected);
                    }
                }
            });
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        public void setDirName(String dir) {
            this.directory = dir;
        }

        public String getDirName() {
            return this.directory;
        }

        public boolean canFlipToNextPage() {
            return this.validatePage();
        }

        public boolean isPageComplete() {
            return this.validatePage();
        }

        public IWizardPage getNextPage() {
            try {
                ReferenceScenarioDataMapImpl map;
                ParameterEstimatorWizard.this.selectEstimatorPage = new ParameterEstimatorWizardSelectEstimatorPage("Estimator");
                ParameterEstimatorWizard.this.selectEstimatorPage.setTitle(Messages.getString("EST.PARAMESTTITLE"));
                ParameterEstimatorWizard.this.selectEstimatorPage.setDescription("");
                ParameterEstimatorWizard.this.selectEstimatorPage.setWizard(this.getWizard());
                CSVscenarioLoader loader = new CSVscenarioLoader(this.folderText.getText());
                int maxResolution = loader.getMaxResolution("");
                ((ParameterEstimatorWizard)this.getWizard()).referenceScenarioDataMap = map = loader.parseAllFiles("", maxResolution);
                this.setDirName(this.folderText.getText());
            }
            catch (Exception e) {
                this.setErrorMessage(e.getMessage());
                return this;
            }
            return ParameterEstimatorWizard.this.selectEstimatorPage;
        }
    }
}

