/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.pde.api.tools.internal.ApiJavadocTag;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;

public final class JavadocTagManager {
    private HashMap tagcache = null;
    private IApiJavadocTag[] tags;

    private void initializeJavadocTags() {
        if (this.tagcache == null) {
            this.tagcache = new HashMap();
            ArrayList<ApiJavadocTag> list = new ArrayList<ApiJavadocTag>(4);
            ApiJavadocTag newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noimplement", "noimplement", 1);
            newtag.setApplicableTo(2, 16, "This interface is not intended to be implemented by clients.");
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noextend", "noextend", 2);
            newtag.setApplicableTo(1, 16, "This class is not intended to be subclassed by clients.");
            newtag.setApplicableTo(2, 16, "This interface is not intended to be extended by clients.");
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.nooverride", "nooverride", 16);
            newtag.setApplicableTo(1, 4, "This method is not intended to be re-implemented or extended by clients.");
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noinstantiate", "noinstantiate", 4);
            newtag.setApplicableTo(1, 16, "This class is not intended to be instantiated by clients.");
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noreference", "noreference", 8);
            newtag.setApplicableTo(1, 4, "This method is not intended to be referenced by clients.");
            newtag.setApplicableTo(2, 4, "This method is not intended to be referenced by clients.");
            newtag.setApplicableTo(1, 8, "This field is not intended to be referenced by clients.");
            newtag.setApplicableTo(2, 8, "This field is not intended to be referenced by clients.");
            newtag.setApplicableTo(1, 32, "This constructor is not intended to be referenced by clients.");
            newtag.setApplicableTo(64, 8, "This enum field is not intended to be referenced by clients.");
            newtag.setApplicableTo(64, 4, "This enum method is not intended to be referenced by clients.");
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            this.tags = list.toArray(new IApiJavadocTag[list.size()]);
        }
    }

    public synchronized IApiJavadocTag[] getTagsForType(int type, int member) {
        this.initializeJavadocTags();
        ArrayList<IApiJavadocTag> list = new ArrayList<IApiJavadocTag>();
        int i = 0;
        while (i < this.tags.length) {
            if (this.tags[i].isApplicable(type, member)) {
                list.add(this.tags[i]);
            }
            ++i;
        }
        return list.toArray(new IApiJavadocTag[list.size()]);
    }

    public synchronized IApiJavadocTag getTag(String id) {
        this.initializeJavadocTags();
        return (IApiJavadocTag)this.tagcache.get(id);
    }

    public synchronized IApiJavadocTag[] getAllTags() {
        this.initializeJavadocTags();
        if (this.tagcache == null) {
            return new IApiJavadocTag[0];
        }
        Collection values = this.tagcache.values();
        return values.toArray(new IApiJavadocTag[values.size()]);
    }

    public synchronized Set getAllTagNames() {
        IApiJavadocTag[] tags = this.getAllTags();
        HashSet<String> names = new HashSet<String>(tags.length);
        int i = 0;
        while (i < tags.length) {
            names.add(tags[i].getTagName());
            ++i;
        }
        return names;
    }

    public synchronized int getRestrictionsForTag(String tagname, int type, int member) {
        if (tagname == null) {
            return 0;
        }
        this.initializeJavadocTags();
        ApiJavadocTag tag = null;
        int i = 0;
        while (i < this.tags.length) {
            tag = (ApiJavadocTag)this.tags[i];
            if (tag.getTagName().equals(tagname) && tag.isApplicable(type, member)) {
                return tag.getRestrictionModifier();
            }
            ++i;
        }
        return 0;
    }
}

