/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.populationmodels.standard.DemographicPopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationGroup;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelValueImpl;

public class DemographicPopulationModelImpl
extends StandardPopulationModelImpl
implements DemographicPopulationModel {
    protected EList<PopulationGroup> populationGroups;

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.DEMOGRAPHIC_POPULATION_MODEL;
    }

    @Override
    public EList<PopulationGroup> getPopulationGroups() {
        if (this.populationGroups == null) {
            this.populationGroups = new BasicInternalEList(PopulationGroup.class);
        }
        return this.populationGroups;
    }

    @Override
    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        if (this.isGraphDecorated()) {
            return;
        }
        for (PopulationLabel populationLabel : this.getPopulationLabels(this.getPopulationIdentifier(), this.getGraph())) {
            if (!this.getPopulationIdentifier().equals(populationLabel.getPopulationIdentifier())) continue;
            boolean found = false;
            for (NodeLabel l : populationLabel.getNode().getLabels()) {
                if (l instanceof PopulationModelLabel) {
                    for (PopulationGroup group : this.getPopulationGroups()) {
                        if (!group.getIdentifier().equals(((PopulationModelLabel)l).getPopulationIdentifier())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) break;
            }
            if (found) continue;
            found = false;
            for (Decorator d : this.getGraph().getDecorators()) {
                if (!d.equals(this) && d instanceof DemographicPopulationModel) {
                    for (PopulationGroup group : this.getPopulationGroups()) {
                        for (PopulationGroup group2 : ((DemographicPopulationModel)d).getPopulationGroups()) {
                            if (!group.getIdentifier().equals(group2.getIdentifier()) || Utility.keyLevel((String)((PopulationModel)d).getTargetISOKey()) <= Utility.keyLevel((String)this.getTargetISOKey()) || !this.isContained(populationLabel.getNode(), ((PopulationModel)d).getTargetISOKey())) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                    }
                }
                if (found) break;
            }
            if (found) continue;
            for (PopulationGroup group : this.getPopulationGroups()) {
                PopulationModelLabel pl = this.createPopulationModelLabel(group.getIdentifier());
                URI unique = STEMURI.createURI((String)("label/" + populationLabel.getNode().getURI().lastSegment() + "/" + this.getName() + "/" + group.getIdentifier()));
                pl.setURI(unique);
                pl.setPopulationLabel(populationLabel);
                this.getLabelsToUpdate().add((Object)pl);
                populationLabel.getNode().getLabels().add((Object)pl);
                pl.setNode(populationLabel.getNode());
                this.getGraph().putNodeLabel((NodeLabel)pl);
                pl.setPopulationIdentifier(group.getIdentifier());
                StandardPopulationModelLabelValueImpl currentValue = (StandardPopulationModelLabelValueImpl)pl.getCurrentValue();
                currentValue.setCount(populationLabel.getCurrentPopulationValue().getCount() * group.getFraction());
            }
        }
        this.resetLabels();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 18: {
                return ((InternalEList)this.getPopulationGroups()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 18: {
                return this.getPopulationGroups();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 18: {
                this.getPopulationGroups().clear();
                this.getPopulationGroups().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 18: {
                this.getPopulationGroups().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 18: {
                return this.populationGroups != null && !this.populationGroups.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void resetLabels() {
        this.setEnabled(true);
        this.setGraphDecorated(false);
        block0: for (StandardPopulationModelLabel plm : this.getLabelsToUpdate()) {
            plm.reset();
            plm.getCurrentValue().reset();
            plm.getNextValue().reset();
            plm.getDeltaValue().reset();
            plm.getTempValue().reset();
            plm.getProbeValue().reset();
            plm.getErrorScale().reset();
            if (plm.getPopulationIdentifier().equals(this.getPopulationIdentifier())) {
                double originalCount = plm.getPopulationLabel().getCurrentPopulationValue().getCount();
                ((StandardPopulationModelLabelValue)plm.getCurrentValue()).setCount(originalCount);
                continue;
            }
            for (PopulationGroup g : this.getPopulationGroups()) {
                if (!g.getIdentifier().equals(plm.getPopulationIdentifier())) continue;
                double originalCount = plm.getPopulationLabel().getCurrentPopulationValue().getCount();
                ((StandardPopulationModelLabelValue)plm.getCurrentValue()).setCount(originalCount * g.getFraction());
                continue block0;
            }
        }
        super.populatePipeSystemNodes();
    }

    @Override
    public EList<String> getAllLabelIdentifiers() {
        BasicEList identifiers = new BasicEList();
        for (PopulationGroup group : this.getPopulationGroups()) {
            identifiers.add((Object)group.getIdentifier());
        }
        return identifiers;
    }
}

