/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AnalysisControl
extends Composite {
    protected static final String CLEAR_TEXT = "clear monitors";
    protected Label simulationNameLabel;
    public static final String STATUS_TEXT = "status";
    protected static Map<String, Object> controlParametersMap = new HashMap<String, Object>();
    protected String userMessage = "";
    protected Label userMessageLabel = null;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    protected Label identifiableTitle;
    protected static final int MARGIN_WIDTH = 5;
    protected static final int MARGIN_HEIGHT = 5;

    public AnalysisControl(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AnalysisControl.this.dispose();
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.setLayout((Layout)layout);
    }

    protected Composite createTopComposite(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        FillLayout topCompositeLayout = new FillLayout(512);
        topComposite.setLayout((Layout)topCompositeLayout);
        this.simulationNameLabel = new Label(topComposite, 0x1000000);
        this.simulationNameLabel.setText("");
        return topComposite;
    }

    protected abstract void initializeHeader(String var1);

    public abstract void remove();

    public abstract double[] getValues(int var1, int var2);

    public void updateMessage() {
        if (this.userMessageLabel != null) {
            this.userMessageLabel.setText(this.userMessage);
        }
    }

    public void updateMessage(String message) {
        this.userMessage = message;
        if (this.userMessageLabel != null) {
            this.userMessageLabel.setText(this.userMessage);
        }
    }

    public abstract String getProperty(int var1, int var2);

    public abstract int getNumProperties(int var1);
}

