/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypesSwitch;

@Singleton
public class JvmFeatureSignatureProvider {
    public String getSignature(JvmFeature from, ITypeArgumentContext ctx, int numberOfIrrelevantArguments) {
        String result = (String)this.createSwitch(ctx, numberOfIrrelevantArguments).doSwitch((EObject)from);
        if (result == null) {
            throw new IllegalStateException("Could not create signature for " + from);
        }
        return result;
    }

    protected Switch createSwitch(ITypeArgumentContext context, int numberOfIrrelevantArguments) {
        return new Switch(context, numberOfIrrelevantArguments);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Switch
    extends TypesSwitch<String> {
        private int numberOfIrrelevantArguments;
        private ITypeArgumentContext ctx;

        public Switch(ITypeArgumentContext ctx, int numberOfIrrelevantArguments) {
            this.numberOfIrrelevantArguments = numberOfIrrelevantArguments;
            this.ctx = ctx;
        }

        public String caseJvmField(JvmField object) {
            return object.getSimpleName();
        }

        public String caseJvmExecutable(JvmExecutable object) {
            StringBuilder builder = new StringBuilder(32);
            builder.append(object.getSimpleName());
            builder.append("(");
            EList params = object.getParameters();
            int i = 0;
            while (i < params.size()) {
                JvmTypeReference resolvedParameterType;
                if (i != 0) {
                    builder.append(",");
                }
                if (i < this.numberOfIrrelevantArguments) {
                    builder.append("implicit ");
                }
                if ((resolvedParameterType = this.ctx.getLowerBound(((JvmFormalParameter)params.get(i)).getParameterType())) != null) {
                    builder.append(resolvedParameterType.getIdentifier());
                } else {
                    builder.append("null");
                }
                ++i;
            }
            builder.append(")");
            return builder.toString();
        }
    }
}

