/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.scoping.featurecalls.AbstractFeaturesForTypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionMethodsFeaturesProvider
extends AbstractFeaturesForTypeProvider {
    private JvmTypeReference extensionProvidingType;
    private boolean noParameters;

    public void setContext(JvmTypeReference type) {
        this.extensionProvidingType = type;
    }

    public void setExpectNoParameters(boolean noParameters) {
        this.noParameters = noParameters;
    }

    public Iterable<JvmFeature> getFeaturesByName(String name, JvmTypeReference declarator, Iterable<JvmTypeReference> hierarchy) {
        if (this.extensionProvidingType == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        List rawTypes = this.getRawTypeHelper().getAllRawTypes(this.extensionProvidingType, null);
        for (JvmType rawType : rawTypes) {
            if (!(rawType instanceof JvmDeclaredType)) continue;
            Iterable candidates = ((JvmDeclaredType)rawType).findAllFeaturesByName(name);
            this.collectExtensionMethods(hierarchy, candidates, result);
        }
        return result;
    }

    protected void collectExtensionMethods(Iterable<JvmTypeReference> hierarchy, Iterable<JvmFeature> candidates, Collection<JvmFeature> result) {
        boolean atLeastOneCandidate = false;
        for (JvmTypeReference reference : hierarchy) {
            for (JvmFeature candidate : candidates) {
                if (candidate instanceof JvmOperation && !this.isFiltered((JvmOperation)candidate)) {
                    JvmOperation operation = (JvmOperation)candidate;
                    EList parameters = operation.getParameters();
                    if (!this.isCandidate(operation)) continue;
                    atLeastOneCandidate = true;
                    if (parameters.size() > 0 && !this.noParameters) {
                        JvmTypeReference parameterType = ((JvmFormalParameter)parameters.get(0)).getParameterType();
                        if (!this.isSameTypeOrAssignableToUpperBound(reference, parameterType)) continue;
                        result.add((JvmFeature)operation);
                        continue;
                    }
                    if (!this.noParameters) continue;
                    result.add((JvmFeature)operation);
                    continue;
                }
                if (!(candidate instanceof JvmField) || !this.noParameters) continue;
                result.add(candidate);
            }
            if (atLeastOneCandidate && !this.noParameters) continue;
            return;
        }
    }

    private boolean isCandidate(JvmOperation operation) {
        return !operation.isStatic();
    }

    protected boolean isFiltered(JvmOperation candidate) {
        return Object.class.getCanonicalName().equals(candidate.getDeclaringType().getIdentifier());
    }

    public Iterable<JvmFeature> getAllFeatures(JvmTypeReference typeReference, Iterable<JvmTypeReference> hierarchy) {
        if (this.extensionProvidingType == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        List rawTypes = this.getRawTypeHelper().getAllRawTypes(this.extensionProvidingType, null);
        for (JvmType rawType : rawTypes) {
            if (!(rawType instanceof JvmDeclaredType)) continue;
            Iterable candidates = ((JvmDeclaredType)rawType).getAllFeatures();
            this.collectExtensionMethods(hierarchy, candidates, result);
        }
        return result;
    }

    public boolean isExtensionProvider() {
        return !this.noParameters;
    }

    public String toString() {
        return "ExtensionMethodsFeaturesProvider [extensionProvidingType=" + this.extensionProvidingType + ", noParameters=" + this.noParameters + "]";
    }
}

