/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.diagnostics.Diagnostic;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBasedDiagnosticConsumer
implements IDiagnosticConsumer {
    private Internal errors;
    private Internal warnings;

    @Override
    public void consume(Diagnostic diagnostic, Severity severity) {
        this.getInternal(severity).consume(diagnostic);
    }

    private Internal getInternal(Severity severity) {
        if (severity == null) {
            throw new NullPointerException("Severity may not be null");
        }
        switch (severity) {
            case ERROR: {
                if (this.errors == null) {
                    this.errors = new Internal();
                }
                return this.errors;
            }
            case WARNING: {
                if (this.warnings == null) {
                    this.warnings = new Internal();
                }
                return this.warnings;
            }
        }
        throw new IllegalArgumentException("Illegal severity: INFO. Diagnostics may either be warnings or errors");
    }

    @Override
    public boolean hasConsumedDiagnostics(Severity severity) {
        if (severity == Severity.ERROR) {
            return this.errors != null;
        }
        if (severity == Severity.WARNING) {
            return this.warnings != null;
        }
        return this.getInternal(severity).hasConsumedDiagnostics();
    }

    public List<Diagnostic> getResult(Severity severity) {
        if (this.hasConsumedDiagnostics(severity)) {
            return this.getInternal(severity).getResult();
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Internal {
        private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        private final Set<Pair<Integer, Integer>> coveredNodes = new HashSet<Pair<Integer, Integer>>();
        private boolean diagnosticsConsumed = false;

        public void consume(Diagnostic diagnostic) {
            Pair newRange = Tuples.create((Object)diagnostic.getOffset(), (Object)diagnostic.getLength());
            if (this.coveredNodes.add((Pair<Integer, Integer>)newRange)) {
                boolean changed = this.diagnostics.add(diagnostic);
                this.diagnosticsConsumed |= changed;
            }
        }

        public boolean hasConsumedDiagnostics() {
            return this.diagnosticsConsumed;
        }

        public List<Diagnostic> getResult() {
            return Collections.unmodifiableList(this.diagnostics);
        }
    }
}

