/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.mapping.IStorageMerger;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.mapping.LineComparator;

public class TextStorageMerger
implements IStorageMerger {
    public IStatus merge(OutputStream output, String outputEncoding, IStorage ancestor, IStorage target, IStorage other, IProgressMonitor monitor) throws CoreException {
        LineComparator o;
        LineComparator t;
        LineComparator a;
        try {
            a = LineComparator.create(ancestor, outputEncoding);
            t = LineComparator.create(target, outputEncoding);
            o = LineComparator.create(other, outputEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 3, TeamUIMessages.TextAutoMerge_inputEncodingError, (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 2, e.getMessage(), (Throwable)e));
        }
        try {
            boolean firstLine = true;
            String lineSeparator = System.getProperty("line.separator");
            if (lineSeparator == null) {
                lineSeparator = "\n";
            }
            RangeDifference[] diffs = RangeDifferencer.findRanges((IProgressMonitor)monitor, (IRangeComparator)a, (IRangeComparator)t, (IRangeComparator)o);
            int i = 0;
            while (i < diffs.length) {
                RangeDifference rd = diffs[i];
                switch (rd.kind()) {
                    case 0: 
                    case 2: 
                    case 4: {
                        String s;
                        int j = rd.rightStart();
                        while (j < rd.rightEnd()) {
                            s = o.getLine(j);
                            if (!firstLine) {
                                output.write(lineSeparator.getBytes(outputEncoding));
                            }
                            output.write(s.getBytes(outputEncoding));
                            firstLine = false;
                            ++j;
                        }
                        break;
                    }
                    case 3: {
                        String s;
                        int j = rd.leftStart();
                        while (j < rd.leftEnd()) {
                            s = t.getLine(j);
                            if (!firstLine) {
                                output.write(lineSeparator.getBytes(outputEncoding));
                            }
                            output.write(s.getBytes(outputEncoding));
                            firstLine = false;
                            ++j;
                        }
                        break;
                    }
                    case 1: {
                        return new Status(2, "org.eclipse.compare", 1, TeamUIMessages.TextAutoMerge_conflict, null);
                    }
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 3, TeamUIMessages.TextAutoMerge_outputEncodingError, (Throwable)e));
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.compare", 2, TeamUIMessages.TextAutoMerge_outputIOError, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public boolean canMergeWithoutAncestor() {
        return false;
    }
}

