/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import org.eclipse.stem.ui.ge.GELog;

public class BBoxInfo
implements Runnable {
    private static final long SLEEPTIME = 10000L;
    private String servletId = null;
    private String servletUrl = null;
    private static Rectangle bBox = null;
    private String bboxOld = null;

    public BBoxInfo(String url, String id) {
        this.servletId = id;
        this.servletUrl = url;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Rectangle bbox;
                    if ((bbox = this.readBBox()) != null) {
                        BBoxInfo.setBBox(bbox);
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public Rectangle readBBox() {
        Rectangle bbox = null;
        try {
            URL url = new URL(this.servletUrl);
            URLConnection connect = url.openConnection();
            connect.setUseCaches(false);
            connect.setDoInput(true);
            connect.setDoOutput(true);
            connect.setRequestProperty("Content-type", "application/octet-stream");
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteOutput);
            output.writeUTF("BBOX " + this.servletId);
            output.flush();
            byte[] buf = byteOutput.toByteArray();
            connect.setRequestProperty("Content-length", "" + buf.length);
            DataOutputStream dataOutput = new DataOutputStream(connect.getOutputStream());
            dataOutput.write(buf);
            dataOutput.flush();
            dataOutput.close();
            DataInputStream in = new DataInputStream(connect.getInputStream());
            String stringValue = in.readUTF();
            in.close();
            String bboxstr = stringValue.substring(5);
            if (!bboxstr.equals(this.bboxOld)) {
                GELog.debug(this, "BBOX: " + bboxstr);
                bbox = BBoxInfo.getBBox(bboxstr);
                GELog.debug(this, "bbox: " + bbox);
                this.bboxOld = bboxstr;
            }
        }
        catch (MalformedURLException e) {
            GELog.debug(e.getMessage());
        }
        catch (IOException e) {
            GELog.debug(e.getMessage());
        }
        return bbox;
    }

    private static Rectangle getBBox(String bboxString) {
        Rectangle bBox = null;
        Polygon polygon = new Polygon();
        StringTokenizer st = new StringTokenizer(bboxString, ",");
        if (st.countTokens() == 4) {
            double x1 = Double.parseDouble(st.nextToken());
            double y1 = Double.parseDouble(st.nextToken());
            double x2 = Double.parseDouble(st.nextToken());
            double y2 = Double.parseDouble(st.nextToken());
            double[] longitudes = new double[]{x1, x1, x2, x2, x1};
            double[] latitudes = new double[]{y1, y2, y2, y2, y1};
            if (x1 == -180.0 && x2 == 180.0) {
                x2 = 0.0;
                GELog.debug(BBoxInfo.class, "****** modify BBOX to 180,0 ******");
            }
            int p = 0;
            while (p < longitudes.length) {
                double x = longitudes[p];
                double y = latitudes[p];
                int xint = (int)((x + 180.0) * 1000.0);
                int yint = (int)((y + 90.0) * 1000.0);
                polygon.addPoint(xint, yint);
                ++p;
            }
        }
        bBox = polygon.getBounds();
        return bBox;
    }

    public static synchronized Rectangle getBBox() {
        return bBox;
    }

    public static synchronized void setBBox(Rectangle box) {
        bBox = box;
    }

    public static boolean testContainment(Rectangle r1, Rectangle r2) {
        int xMin1 = r1.x;
        int xMax1 = r1.x + r1.width;
        int yMin1 = r1.y - r1.height;
        int yMax1 = r1.y;
        if (r2.contains(xMin1, yMin1)) {
            return true;
        }
        if (r2.contains(xMin1, yMax1)) {
            return true;
        }
        if (r2.contains(xMax1, yMax1)) {
            return true;
        }
        if (r2.contains(xMax1, yMin1)) {
            return true;
        }
        int xMin2 = r2.x;
        int xMax2 = r2.x + r2.width;
        int yMin2 = r2.y - r2.height;
        int yMax2 = r2.y;
        if (r1.contains(xMin2, yMin2)) {
            return true;
        }
        if (r1.contains(xMin2, yMax2)) {
            return true;
        }
        if (r1.contains(xMax2, yMax2)) {
            return true;
        }
        return r1.contains(xMax2, yMin2);
    }
}

