/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.adapters.time.TimeProvider;
import org.eclipse.stem.adapters.time.TimeProviderAdapterFactory;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.util.loggers.views.LogWriter;
import org.eclipse.stem.util.loggers.views.NewCSVLogWriter;

public class CustomCSVLogger
implements ISimulationListenerSync {
    protected ISimulation simulation = null;
    protected IntegrationDecorator diseaseModel = null;
    LogWriter logWriter;
    Graph graph = null;
    TimeProvider timeProvider = null;
    protected Map<Node, Integer> nodeLevels;

    public CustomCSVLogger(String outputDir, ISimulation simulation, IntegrationDecorator dm) {
        this.logWriter = new NewCSVLogWriter(outputDir, simulation, dm, true);
        this.setSimulation(simulation);
        this.diseaseModel = dm;
    }

    public final void setSimulation(ISimulation simulation) {
        if (this.simulation == simulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
        this.nodeLevels = this.getNodeLevels(simulation);
        this.simulation = simulation;
        if (this.simulation != null) {
            this.simulation.addSimulationListenerSync((ISimulationListenerSync)this, true);
            this.initializeFromSimulation(this.simulation);
        }
        this.flushLoggerData();
    }

    protected void initializeFromSimulation(ISimulation simulation) {
        this.graph = simulation.getScenario().getCanonicalGraph();
        this.timeProvider = (TimeProvider)TimeProviderAdapterFactory.INSTANCE.adapt((Notifier)this.graph, TimeProvider.class);
    }

    public void flushLoggerData() {
        if (this.logWriter != null) {
            this.logWriter.flushLoggerData();
        }
    }

    public void simulationChangedSync(SimulationEvent event) {
        if (event.getSimulationState() == SimulationState.RUNNING) {
            if (this.logWriter != null && this.logWriter.needsHeader) {
                this.logWriter.logHeader(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider);
                this.logWriter.logData(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider, true);
            }
        } else if (event.getSimulationState() == SimulationState.COMPLETED_CYCLE) {
            if (this.logWriter != null) {
                this.logWriter.logData(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider, false);
            }
        } else if (event.getSimulationState() == SimulationState.PAUSED) {
            this.flushLoggerData();
        } else if (event.getSimulationState() == SimulationState.STOPPED) {
            this.close();
        }
    }

    private Map<Node, Integer> getNodeLevels(ISimulation simulation) {
        HashMap<Node, Integer> result = new HashMap<Node, Integer>();
        Graph graph = simulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            EMap allNodes = graph.getNodes();
            Set allGraphURIs = allNodes.keySet();
            Iterator graphIter2 = allGraphURIs.iterator();
            while (graphIter2 != null && graphIter2.hasNext()) {
                URI uri = (URI)graphIter2.next();
                Node node = (Node)allNodes.get((Object)uri);
                if (node.getLabels().size() == 0) continue;
                String id = node.getURI().toString();
                int level = this.getAdminLevel(id);
                result.put(node, level);
            }
        }
        return result;
    }

    private int getAdminLevel(String uriKey) {
        int retVal = 0;
        String test = uriKey;
        while (test.contains("-")) {
            String test2;
            ++retVal;
            int idx1 = test.indexOf("-");
            test = test2 = test.substring(idx1 + 1, test.length());
        }
        return retVal;
    }

    public void close() {
        if (this.logWriter != null) {
            this.logWriter.flushLoggerData();
        }
        if (this.logWriter != null) {
            this.logWriter.closeLoggerData();
        }
        this.logWriter = null;
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
    }

    public String getDirectoryName() {
        return this.logWriter.getDirectoryName();
    }

    public String getLogDataObjectName() {
        return this.logWriter.getLogDataObjectName();
    }
}

