/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.migration;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioPackage;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.migration.MigrationTask;
import org.eclipse.stem.ui.versioning.VersioningUtil;
import org.eclipse.stem.ui.wizards.Messages;
import org.osgi.framework.Version;

public class MigrationV1V2Task
implements MigrationTask {
    public static MigrationV1V2Task INSTANCE = new MigrationV1V2Task();

    private MigrationV1V2Task() {
    }

    @Override
    public void executeTask(IProject project) {
        try {
            IResource[] scenarios;
            IFolder scenariosFolder = project.getFolder("scenarios");
            IResource[] iResourceArray = scenarios = scenariosFolder.members();
            int n = scenarios.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                try {
                    Scenario scenario = (Scenario)Utility.getIdentifiable((URI)URI.createURI((String)resource.getLocationURI().toString()));
                    scenario.eClass().getEStructuralFeature(ScenarioPackage.eINSTANCE.getScenario_Solver().getName());
                    Solver s = scenario.getSolver();
                    Solver movedSolver = (Solver)EcoreUtil.copy((EObject)s);
                    IFolder solverFolder = project.getFolder("solvers");
                    if (!solverFolder.exists()) {
                        solverFolder.create(true, true, null);
                    }
                    String shortSolverName = movedSolver.getClass().getSimpleName();
                    boolean unique = false;
                    int n3 = 1;
                    IFile solverFile = null;
                    do {
                        String solverName;
                        unique = !(solverFile = solverFolder.getFile(solverName = String.valueOf(shortSolverName) + n3 + "." + s.eClass().getEPackage().getName())).exists();
                        ++n3;
                    } while (!unique);
                    URI newURI = STEMURI.normalize((URI)URI.createURI((String)solverFile.getLocationURI().toString()));
                    movedSolver.setURI(newURI);
                    Utility.serializeIdentifiable((Identifiable)movedSolver, (URI)newURI);
                    scenario.setSolver(null);
                    scenario.setSolver(movedSolver);
                    Utility.serializeIdentifiable((Identifiable)scenario, (URI)scenario.getURI());
                }
                catch (Exception exception) {}
                ++n2;
            }
            String versionString = VersioningUtil.getSTEMVersion().toString();
            VersioningUtil.setSTEMProjectVersion(project, versionString);
            String logInfo = MessageFormat.format(Messages.getString("project.migrated"), project.getName(), versionString);
            Utility.unloadResourcesInProject((IProject)project);
            Activator.logInformation(logInfo);
        }
        catch (CoreException ce) {
            CorePlugin.logError((String)ce.getMessage(), (Throwable)ce);
        }
    }

    @Override
    public Version getFromVersion() {
        return new Version(1, 0, 0);
    }

    @Override
    public Version getToVersion() {
        return new Version(2, 0, 0);
    }
}

