/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.ModelPackage;
import org.eclipse.stem.ui.Utility;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.editors.validation.EAnnotationConstraintValidator;
import org.eclipse.stem.ui.widgets.LocationPickerDialog;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class GenericPropertyEditor
extends Composite {
    public static final String EMPTY_STRING = "";
    public static final String FEATURE_CONSTRAINT_ANNOTATION_SOURCE = "http:///org/eclipse/stem/modelgen/modelparam/constraints";
    private Map<EStructuralFeature, EAnnotationConstraintValidator> validators = new HashMap<EStructuralFeature, EAnnotationConstraintValidator>();
    protected final Map<EStructuralFeature, Text> map = new HashMap<EStructuralFeature, Text>();
    protected final Map<EStructuralFeature, Button> booleanMap = new HashMap<EStructuralFeature, Button>();
    protected final Map<EStructuralFeature, Combo> comboMap = new HashMap<EStructuralFeature, Combo>();
    protected String errorMessage;
    protected IProject project;
    protected PropertyStringProviderAdapter stringProvider;
    private IItemPropertySource propertySource;
    private Identifiable identifiable;

    public GenericPropertyEditor(Composite parent, int style, IProject project) {
        super(parent, style);
        this.project = project;
    }

    public GenericPropertyEditor(Composite parent, int style, Identifiable identifiable, ModifyListener projectValidator, IProject project) {
        super(parent, style);
        this.project = project;
        this.identifiable = identifiable;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        this.stringProvider = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)identifiable, PropertyStringProvider.class);
        ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)identifiable, IItemPropertySource.class);
        List properties = this.propertySource.getPropertyDescriptors((Object)identifiable);
        for (IItemPropertyDescriptor descriptor : properties) {
            EReference ref;
            EClassifier eClassifier;
            final EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
            EClassifier classifier = feature.getEType();
            if (!this.isUserSpecifiedProperty(feature) || classifier != EcorePackage.Literals.EBOOLEAN && classifier != CommonPackage.Literals.URI && classifier != EcorePackage.Literals.ESHORT && classifier != EcorePackage.Literals.EINT && classifier != EcorePackage.Literals.ELONG && classifier != EcorePackage.Literals.EFLOAT && classifier != EcorePackage.Literals.EDOUBLE && classifier != EcorePackage.Literals.ESTRING && classifier != ModelPackage.Literals.INTEGRATION_DECORATOR) continue;
            boolean isDataPath = false;
            boolean isURI = false;
            Label label = new Label((Composite)this, 0);
            label.setText(this.stringProvider.getPropertyName(descriptor));
            GridData labelGD = new GridData(1);
            labelGD.grabExcessHorizontalSpace = true;
            labelGD.horizontalAlignment = 4;
            labelGD.horizontalIndent = 0;
            label.setLayoutData((Object)labelGD);
            String defaultValueString = this.getPropertyDefaultValueString(descriptor);
            if (classifier == EcorePackage.Literals.EBOOLEAN) {
                Composite radioComposite = new Composite((Composite)this, 2048);
                FillLayout fillLayout = new FillLayout();
                fillLayout.type = 256;
                radioComposite.setLayout((Layout)fillLayout);
                Button falseButton = new Button(radioComposite, 16);
                falseButton.setText(Messages.getString("NO"));
                Button trueButton = new Button(radioComposite, 16);
                trueButton.setText(Messages.getString("YES"));
                if (defaultValueString != null) {
                    trueButton.setSelection(defaultValueString.equals("true"));
                    falseButton.setSelection(!defaultValueString.equals("true"));
                } else {
                    falseButton.setSelection(true);
                    trueButton.setSelection(false);
                }
                this.booleanMap.put(feature, trueButton);
                falseButton.setToolTipText(this.stringProvider.getPropertyToolTip(descriptor));
                trueButton.setToolTipText(this.stringProvider.getPropertyToolTip(descriptor));
                GridData cGD = new GridData(3);
                cGD.grabExcessHorizontalSpace = true;
                cGD.horizontalAlignment = 4;
                radioComposite.setLayoutData((Object)cGD);
            } else if (classifier == CommonPackage.Literals.URI) {
                isURI = true;
                final Text isokeyValueText = new Text((Composite)this, 0);
                isokeyValueText.setToolTipText(this.stringProvider.getPropertyToolTip(descriptor));
                isokeyValueText.setText(EMPTY_STRING);
                this.map.put(feature, isokeyValueText);
                GridData gd_isoKeyLabelValue = new GridData(4, 0x1000000, true, false);
                isokeyValueText.setLayoutData((Object)gd_isoKeyLabelValue);
                Button locationButton = new Button((Composite)this, 0);
                locationButton.setText(Messages.getString("NPickLoc"));
                GridData lb_isoKeyLabel = new GridData(4, 0x1000000, true, false);
                locationButton.setLayoutData((Object)lb_isoKeyLabel);
                locationButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        LocationPickerDialog lpDialog = new LocationPickerDialog(GenericPropertyEditor.this.getShell(), 0, Messages.getString("NPickLocTitle"), isokeyValueText.getText(), GenericPropertyEditor.this.project);
                        Object[] ret = lpDialog.open();
                        if (ret != null) {
                            if (ret[1] != null) {
                                isokeyValueText.setText(((URI)ret[1]).toString());
                            } else {
                                isokeyValueText.setText(STEMURI.createURI((String)("node/geo/region/" + (String)ret[0])).toString());
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
            } else if (classifier == EcorePackage.Literals.ESHORT || classifier == EcorePackage.Literals.EINT || classifier == EcorePackage.Literals.ELONG || classifier == EcorePackage.Literals.EFLOAT || classifier == EcorePackage.Literals.EDOUBLE || classifier == EcorePackage.Literals.ESTRING) {
                Text _text;
                Button fileChooserButton;
                RowLayout buttonsLayout;
                Composite buttons;
                Text text = new Text((Composite)this, 133120);
                if (defaultValueString != null) {
                    text.setText(defaultValueString);
                }
                text.setToolTipText(this.stringProvider.getPropertyToolTip(descriptor));
                this.map.put(feature, text);
                GridData textGD = new GridData(3);
                textGD.grabExcessHorizontalSpace = true;
                textGD.horizontalAlignment = 4;
                text.setLayoutData((Object)textGD);
                text.addModifyListener(projectValidator);
                if (feature.getName().startsWith("dataPath")) {
                    isDataPath = true;
                    buttons = new Composite((Composite)this, 0);
                    buttonsLayout = new RowLayout();
                    buttonsLayout.marginTop = 0;
                    buttonsLayout.marginBottom = 0;
                    buttons.setLayout((Layout)buttonsLayout);
                    final Shell shell = this.getShell();
                    fileChooserButton = new Button(buttons, 0);
                    fileChooserButton.setText(Messages.getString("fileChooserButtonText"));
                    fileChooserButton.setToolTipText(Messages.getString("fileChooserButtonTooltipText"));
                    _text = text;
                    fileChooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            FileDialog fd = new FileDialog(shell, 4098);
                            fd.setText(Messages.getString("fileChooserDialogTitle"));
                            String[] extensionsFilter = new String[]{"*.txt", "*.csv"};
                            fd.setFilterExtensions(extensionsFilter);
                            String selected = fd.open();
                            String[] selectedFiles = fd.getFileNames();
                            if (selectedFiles.length > 1) {
                                StringBuilder str = new StringBuilder(selected);
                                int i = 1;
                                while (i < selectedFiles.length) {
                                    str.append(" \"");
                                    str.append(selectedFiles[i]);
                                    str.append("\"");
                                    ++i;
                                }
                                selected = str.toString();
                            }
                            _text.setText(selected);
                        }
                    });
                    Button dirChooserButton = new Button(buttons, 0);
                    dirChooserButton.setText(Messages.getString("dirChooserButtonText"));
                    dirChooserButton.setToolTipText(Messages.getString("dirChooserButtonTooltipText"));
                    dirChooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                            dd.setText(Messages.getString("dirChooserDialogTitle"));
                            String pathName = dd.open();
                            Path rootPath = new Path(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
                            if (pathName != null) {
                                Path path = new Path(pathName);
                                if (rootPath.isPrefixOf((IPath)path)) {
                                    String relPath = path.makeRelativeTo((IPath)rootPath).toString();
                                    if (relPath.isEmpty()) {
                                        relPath = "/";
                                    }
                                    _text.setText(URI.createPlatformResourceURI((String)relPath, (boolean)false).toString());
                                } else {
                                    _text.setText(pathName);
                                }
                            }
                        }
                    });
                    GridData fileBtnGD = new GridData(3);
                    buttons.setLayoutData((Object)fileBtnGD);
                } else if (feature.getName().startsWith("dataFile")) {
                    isDataPath = true;
                    buttons = new Composite((Composite)this, 0);
                    buttonsLayout = new RowLayout();
                    buttonsLayout.marginTop = 0;
                    buttonsLayout.marginBottom = 0;
                    buttons.setLayout((Layout)buttonsLayout);
                    final Shell shell = this.getShell();
                    fileChooserButton = new Button(buttons, 0);
                    fileChooserButton.setText(Messages.getString("fileChooserButtonText"));
                    fileChooserButton.setToolTipText(Messages.getString("fileChooserButtonTooltipText"));
                    _text = text;
                    fileChooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            FileDialog fd = new FileDialog(shell, 4100);
                            fd.setText(Messages.getString("fileChooserDialogTitle"));
                            StringTokenizer tok = new StringTokenizer(feature.getName(), "_");
                            Vector<String> v = new Vector<String>();
                            tok.nextToken();
                            while (tok.hasMoreTokens()) {
                                v.add("*." + tok.nextToken());
                            }
                            v.add("*");
                            String[] extensionsFilter = new String[v.size()];
                            fd.setFilterExtensions(v.toArray(extensionsFilter));
                            _text.setText(fd.open());
                        }
                    });
                    GridData fileBtnGD = new GridData(3);
                    buttons.setLayoutData((Object)fileBtnGD);
                }
            } else if (feature instanceof EReference && (eClassifier = (ref = (EReference)feature).getEType()).getInstanceClass().equals(IntegrationDecorator.class)) {
                Combo decoratorsCombo = new Combo((Composite)this, 0x100000C);
                List<IntegrationDecorator> decoratorsList = this.getDecoratorsForProject(project);
                int index = 0;
                for (IntegrationDecorator idec : decoratorsList) {
                    decoratorsCombo.add(idec.getURI().toString());
                    decoratorsCombo.setData(EMPTY_STRING + index++, (Object)idec);
                }
                decoratorsCombo.setVisible(true);
                GridData comboGD = new GridData(3);
                comboGD.grabExcessHorizontalSpace = true;
                comboGD.horizontalAlignment = 4;
                decoratorsCombo.setLayoutData((Object)comboGD);
                this.comboMap.put(feature, decoratorsCombo);
            }
            if (isDataPath || isURI) continue;
            Label unitLabel = new Label((Composite)this, 0);
            unitLabel.setText(this.stringProvider.getPropertyUnits(descriptor));
            GridData unitLabelGD = new GridData(3);
            unitLabelGD.verticalAlignment = 2;
            unitLabel.setLayoutData((Object)unitLabelGD);
        }
    }

    public List<IntegrationDecorator> getDecoratorsForProject(IProject project) {
        ArrayList<IntegrationDecorator> retVal;
        block7: {
            retVal = new ArrayList<IntegrationDecorator>();
            try {
                IResource[] members;
                IFolder folder = project.getFolder("decorators");
                if (!folder.exists() || (members = folder.members()) == null) break block7;
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFile) {
                        try {
                            Identifiable id = Utility.getIdentifiable((IFile)resource);
                            if (id instanceof IntegrationDecorator) {
                                retVal.add((IntegrationDecorator)id);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++n2;
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
        return retVal;
    }

    public void populate(EObject obj) {
        if (obj instanceof IntegrationDecorator) {
            IntegrationDecorator model = (IntegrationDecorator)obj;
            model.setAddStochasticNoise(this.booleanMap.get(ModelPackage.Literals.INTEGRATION_DECORATOR__ADD_STOCHASTIC_NOISE).getSelection());
            model.setRandomSeed(Long.parseLong(this.map.get(ModelPackage.Literals.INTEGRATION_DECORATOR__RANDOM_SEED).getText()));
        }
    }

    public boolean validate() {
        Text text;
        boolean retValue = true;
        if (retValue && (text = this.map.get(ModelPackage.Literals.INTEGRATION_DECORATOR__RANDOM_SEED)) != null && !(retValue = this.isValidLongValue(text.getText(), 0L))) {
            this.errorMessage = Messages.getString("NIdWiz.WizErrInvSeed");
        }
        return retValue;
    }

    protected abstract boolean isUserSpecifiedProperty(EStructuralFeature var1);

    protected boolean isValidLongValue(String text) {
        boolean retValue = true;
        try {
            Long.parseLong(text);
        }
        catch (NumberFormatException numberFormatException) {
            retValue = false;
        }
        return retValue;
    }

    protected boolean isValidLongValue(String text, long minValue) {
        boolean retValue = true;
        try {
            double value = Long.parseLong(text);
            retValue = value >= (double)minValue;
        }
        catch (NumberFormatException numberFormatException) {
            retValue = false;
        }
        return retValue;
    }

    protected boolean isValidPercentage(String text) {
        boolean retValue = true;
        try {
            double value = Double.parseDouble(text);
            retValue = value >= 0.0 && value <= 100.0;
        }
        catch (NumberFormatException numberFormatException) {
            retValue = false;
        }
        return retValue;
    }

    protected boolean isValidValue(String text, double minValue) {
        boolean retValue = true;
        try {
            double value = Double.parseDouble(text);
            retValue = value >= minValue;
        }
        catch (NumberFormatException numberFormatException) {
            retValue = false;
        }
        return retValue;
    }

    protected boolean isValidIntValue(String text) {
        return this.isValidIntValue(text, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    protected boolean isValidIntValue(String text, int minValue) {
        return this.isValidIntValue(text, minValue, Integer.MAX_VALUE);
    }

    protected boolean isValidIntValue(String text, int minValue, int maxValue) {
        boolean retValue = true;
        try {
            double value = Integer.parseInt(text);
            retValue = value >= (double)minValue && value <= (double)maxValue;
        }
        catch (NumberFormatException numberFormatException) {
            retValue = false;
        }
        return retValue;
    }

    protected boolean isValidDoubleValue(String text) {
        boolean retValue = true;
        try {
            Double.parseDouble(text);
        }
        catch (NumberFormatException numberFormatException) {
            retValue = false;
        }
        return retValue;
    }

    protected boolean isValidDoubleValue(String text, double minValue) {
        boolean retValue = true;
        try {
            double value = Double.parseDouble(text);
            retValue = value >= minValue;
        }
        catch (NumberFormatException numberFormatException) {
            retValue = false;
        }
        return retValue;
    }

    protected boolean isValidDoubleValue(String text, double minValue, double maxValue) {
        boolean retValue = true;
        try {
            double value = Double.parseDouble(text);
            retValue = value >= minValue && value <= maxValue;
        }
        catch (NumberFormatException numberFormatException) {
            retValue = false;
        }
        return retValue;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected String getPropertyDefaultValueString(IItemPropertyDescriptor descriptor) {
        EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
        return feature.getDefaultValueLiteral();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean typeIsHandledByValidator(EStructuralFeature feature) {
        EClassifier classifier = feature.getEType();
        boolean value = classifier.equals(EcorePackage.Literals.ESHORT) || classifier.equals(EcorePackage.Literals.EINT) || classifier.equals(EcorePackage.Literals.ELONG) || classifier.equals(EcorePackage.Literals.EFLOAT) || classifier.equals(EcorePackage.Literals.EDOUBLE) || classifier.equals(EcorePackage.Literals.ESTRING);
        return value;
    }

    protected boolean validateFeatureConstraint(EStructuralFeature feature) {
        Text data;
        if (this.typeIsHandledByValidator(feature) && (data = this.map.get(feature)) != null) {
            return this.validateFeatureConstraint(feature, data.getText().trim());
        }
        return true;
    }

    private IItemPropertyDescriptor getDescriptorForFeature(EStructuralFeature feature) {
        return this.propertySource.getPropertyDescriptor((Object)this.identifiable, (Object)feature);
    }

    protected boolean validateFeatureConstraint(EStructuralFeature feature, String value) {
        if (feature.getLowerBound() > 0 && GenericPropertyEditor.isNullOrEmpty(value)) {
            this.errorMessage = this.stringProvider.getPropertyMissing(this.getDescriptorForFeature(feature));
            return false;
        }
        EAnnotation constraint = feature.getEAnnotation(FEATURE_CONSTRAINT_ANNOTATION_SOURCE);
        if (constraint != null) {
            EAnnotationConstraintValidator validator = this.validators.get(feature);
            if (validator == null) {
                validator = new EAnnotationConstraintValidator(constraint);
                this.validators.put(feature, validator);
            }
            if (!validator.validate(value)) {
                this.errorMessage = this.stringProvider.getPropertyInvalid(this.getDescriptorForFeature(feature));
                return false;
            }
        }
        return true;
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || EMPTY_STRING.equals(value);
    }
}

