/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IBreakpointImportParticipant;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ImportBreakpointsOperation
implements IRunnableWithProgress {
    private boolean fOverwriteAll = false;
    private String fFileName = null;
    private boolean fCreateWorkingSets = false;
    private ArrayList fAdded = new ArrayList();
    private String fCurrentWorkingSetProperty = null;
    private BreakpointManager fManager = (BreakpointManager)DebugPlugin.getDefault().getBreakpointManager();
    private StringBuffer fBuffer = null;

    public ImportBreakpointsOperation(String fileName, boolean overwrite, boolean createWorkingSets) {
        this.fFileName = fileName;
        this.fOverwriteAll = overwrite;
        this.fCreateWorkingSets = createWorkingSets;
    }

    public ImportBreakpointsOperation(StringBuffer buffer, boolean overwrite, boolean createWorkingSets) {
        this.fBuffer = buffer;
        this.fOverwriteAll = overwrite;
        this.fCreateWorkingSets = createWorkingSets;
    }

    /*
     * Exception decompiling
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IMarker findExistingMarker(Map attributes, IBreakpointImportParticipant[] participants) {
        IBreakpoint[] bps = this.fManager.getBreakpoints();
        int i = 0;
        while (i < bps.length) {
            int j = 0;
            while (j < participants.length) {
                try {
                    if (participants[j].matches(attributes, bps[i])) {
                        return bps[i].getMarker();
                    }
                }
                catch (CoreException coreException) {}
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected Map collectBreakpointProperties(IMemento memento) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", memento.getBoolean("enabled"));
        map.put("persistant", memento.getBoolean("persistant"));
        map.put("registered", memento.getBoolean("registered"));
        IMemento child = memento.getChild("marker");
        map.put("type", child.getString("type"));
        map.put("lineNumber", child.getInteger("lineNumber"));
        IMemento[] children = child.getChildren("attrib");
        int i = 0;
        while (i < children.length) {
            this.readAttribute(children[i], map);
            ++i;
        }
        child = memento.getChild("resource");
        map.put("path", child.getString("path"));
        return map;
    }

    private void readAttribute(IMemento memento, Map map) {
        String name = memento.getString("name");
        String value = memento.getString("value");
        if (value != null && name != null) {
            Object val;
            block5: {
                if (name.equals("workingset_name")) {
                    this.fCurrentWorkingSetProperty = value;
                }
                val = value;
                try {
                    val = Integer.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("true")) break block5;
                    val = Boolean.valueOf(value);
                }
            }
            if (val != null) {
                map.put(name, val);
            }
        }
    }

    protected void restoreBreakpoint(IMarker marker, Map attributes, IBreakpointImportParticipant[] participants) {
        block10: {
            String key = null;
            Iterator iter = attributes.keySet().iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                try {
                    marker.setAttribute(key, attributes.get(key));
                }
                catch (CoreException coreException) {}
            }
            IBreakpoint breakpoint = null;
            try {
                breakpoint = this.fManager.createBreakpoint(marker);
                breakpoint.setEnabled(((Boolean)attributes.get("enabled")).booleanValue());
                breakpoint.setPersisted(((Boolean)attributes.get("persistant")).booleanValue());
                breakpoint.setRegistered(((Boolean)attributes.get("registered")).booleanValue());
                this.fAdded.add(breakpoint);
                if (this.fCreateWorkingSets && this.fCurrentWorkingSetProperty != null) {
                    String[] names = this.fCurrentWorkingSetProperty.split("\\<;#>");
                    this.updateWorkingSets(names, breakpoint);
                }
                if (participants != null) {
                    int i = 0;
                    while (i < participants.length) {
                        participants[i].verify(breakpoint);
                        ++i;
                    }
                }
            }
            catch (CoreException coreException) {
                if (breakpoint == null) break block10;
                try {
                    this.fAdded.remove(breakpoint);
                    marker.delete();
                }
                catch (CoreException coreException2) {}
            }
        }
    }

    private void updateWorkingSets(String[] wsnames, IBreakpoint breakpoint) {
        IWorkingSetManager mgr = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet set = null;
        ArrayList sets = new ArrayList();
        this.collectContainingWorkingsets(breakpoint, sets);
        int i = 0;
        while (i < wsnames.length) {
            if (!"".equals(wsnames[i])) {
                set = mgr.getWorkingSet(wsnames[i]);
                if (set == null) {
                    set = mgr.createWorkingSet(wsnames[i], new IAdaptable[0]);
                    set.setId("org.eclipse.debug.ui.breakpointWorkingSet");
                    mgr.addWorkingSet(set);
                }
                if (!sets.contains(set)) {
                    IAdaptable[] elements = set.getElements();
                    IAdaptable[] newElements = new IAdaptable[elements.length + 1];
                    newElements[newElements.length - 1] = breakpoint;
                    System.arraycopy(elements, 0, newElements, 0, elements.length);
                    set.setElements(newElements);
                }
                sets.remove(set);
            }
            ++i;
        }
        ArrayList<IAdaptable> items = null;
        Iterator iter = sets.iterator();
        while (iter.hasNext()) {
            set = (IWorkingSet)iter.next();
            items = new ArrayList<IAdaptable>(Arrays.asList(set.getElements()));
            if (!items.remove(breakpoint)) continue;
            set.setElements(items.toArray(new IAdaptable[items.size()]));
        }
    }

    private void collectContainingWorkingsets(IBreakpoint breakpoint, List collector) {
        IWorkingSetManager mgr = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] sets = mgr.getWorkingSets();
        int i = 0;
        while (i < sets.length) {
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(sets[i].getId()) && this.containsBreakpoint(sets[i], breakpoint)) {
                collector.add(sets[i]);
            }
            ++i;
        }
    }

    private boolean containsBreakpoint(IWorkingSet set, IBreakpoint breakpoint) {
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(breakpoint)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IBreakpoint[] getImportedBreakpoints() {
        return this.fAdded.toArray(new IBreakpoint[this.fAdded.size()]);
    }
}

