/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.EditorUtilities;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.validation.TextValidator;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.FileExtensionFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LauncherSection
extends PDESection {
    private TextValidator[] fMultipleWinIconValidator;
    private TextValidator fSingleWinIconValidator;
    private static final String[] F_WIN_ICON_LABELS = new String[]{PDEUIMessages.LauncherSection_Low16, PDEUIMessages.LauncherSection_High16, PDEUIMessages.LauncherSection_32Low, PDEUIMessages.LauncherSection_32High, PDEUIMessages.LauncherSection_48Low, PDEUIMessages.LauncherSection_48High, PDEUIMessages.LauncherSection_256High};
    public static final int[] F_WIN_ICON_DEPTHS = new int[]{8, 32, 8, 32, 8, 32, 32};
    public static final int[][] F_WIN_ICON_DIMENSIONS = new int[][]{{16, 16}, {16, 16}, {32, 32}, {32, 32}, {48, 48}, {48, 48}, {256, 256}};
    private static final String[] F_WIN_ICON_IDS = new String[]{"winSmallLow", "winSmallHigh", "winMediumLow", "winMediumHigh", "winLargeLow", "winLargeHigh", "winExtraLargeHigh"};
    private FormEntry fNameEntry;
    private ArrayList fIcons = new ArrayList();
    private Button fIcoButton;
    private Button fBmpButton;
    private CTabFolder fTabFolder;
    private Composite fNotebook;
    private StackLayout fNotebookLayout;
    private Composite fLinuxSection;
    private Composite fMacSection;
    private Composite fSolarisSection;
    private Composite fWin32Section;

    public LauncherSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(770);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.LauncherSection_title);
        section.setDescription(PDEUIMessages.LauncherSection_desc);
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = FormLayoutFactory.createSectionClientGridLayout(false, 2);
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fNameEntry = new FormEntry(container, toolkit, PDEUIMessages.LauncherSection_launcherName, null, false);
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                LauncherSection.this.getLauncherInfo().setLauncherName(entry.getValue());
            }
        });
        this.fNameEntry.setEditable(this.isEditable());
        this.createLabel(container, toolkit, PDEUIMessages.LauncherSection_label, 2);
        this.fTabFolder = new CTabFolder(container, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        gd.heightHint = 2;
        gd.horizontalSpan = 2;
        this.fTabFolder.setLayoutData((Object)gd);
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LauncherSection.this.updateTabSelection();
            }
        });
        this.fTabFolder.setUnselectedImageVisible(false);
        this.fNotebook = toolkit.createComposite(container);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fNotebook.setLayoutData((Object)gd);
        this.fNotebookLayout = new StackLayout();
        this.fNotebook.setLayout((Layout)this.fNotebookLayout);
        this.fLinuxSection = this.addLinuxSection(this.fNotebook, toolkit);
        this.fMacSection = this.addMacSection(this.fNotebook, toolkit);
        this.fSolarisSection = this.addSolarisSection(this.fNotebook, toolkit);
        this.fWin32Section = this.addWin32Section(this.fNotebook, toolkit);
        this.createTabs();
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void createTabs() {
        this.addTab("linux");
        this.addTab("macosx");
        this.addTab("solaris");
        this.addTab("win32");
        String currentTarget = TargetPlatform.getOS();
        if ("win32".equals(currentTarget)) {
            this.fTabFolder.setSelection(3);
            this.fNotebookLayout.topControl = this.fWin32Section;
        } else if ("macosx".equals(currentTarget)) {
            this.fTabFolder.setSelection(1);
            this.fNotebookLayout.topControl = this.fMacSection;
        } else if ("solaris".equals(currentTarget)) {
            this.fTabFolder.setSelection(2);
            this.fNotebookLayout.topControl = this.fSolarisSection;
        } else {
            this.fTabFolder.setSelection(0);
            this.fNotebookLayout.topControl = this.fLinuxSection;
        }
    }

    private void addTab(String label) {
        CTabItem item = new CTabItem(this.fTabFolder, 0);
        item.setText(label);
        item.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ));
    }

    private Composite addWin32Section(Composite parent, FormToolkit toolkit) {
        Composite comp = this.createComposite(parent, toolkit);
        this.fBmpButton = toolkit.createButton(comp, PDEUIMessages.LauncherSection_bmpImages, 16);
        TableWrapData td = new TableWrapData();
        td.colspan = 3;
        this.fBmpButton.setLayoutData((Object)td);
        this.fBmpButton.setEnabled(this.isEditable());
        this.fMultipleWinIconValidator = new TextValidator[F_WIN_ICON_LABELS.length];
        int i = 0;
        while (i < F_WIN_ICON_LABELS.length) {
            final IconEntry ientry = new IconEntry(comp, toolkit, F_WIN_ICON_LABELS[i], F_WIN_ICON_IDS[i]);
            final int index = i++;
            this.fMultipleWinIconValidator[index] = new TextValidator(this.getManagedForm(), ientry.getText(), this.getProject(), true){

                protected boolean validateControl() {
                    return LauncherSection.this.validateMultipleWinIcon(ientry, index);
                }
            };
            this.fMultipleWinIconValidator[index].setEnabled(false);
            ientry.getText().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LauncherSection.this.fMultipleWinIconValidator[index].validate();
                }
            });
            this.fIcons.add(ientry);
        }
        this.fIcoButton = toolkit.createButton(comp, PDEUIMessages.LauncherSection_ico, 16);
        td = new TableWrapData();
        td.colspan = 3;
        this.fIcoButton.setLayoutData((Object)td);
        this.fIcoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = LauncherSection.this.fIcoButton.getSelection();
                LauncherSection.this.getLauncherInfo().setUseWinIcoFile(selected);
                LauncherSection.this.updateWinEntries(selected);
            }
        });
        this.fIcoButton.setEnabled(this.isEditable());
        final IconEntry ientry = new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_file, "icoFile");
        this.fSingleWinIconValidator = new TextValidator(this.getManagedForm(), ientry.getText(), this.getProject(), true){

            protected boolean validateControl() {
                return LauncherSection.this.validateSingleWinIcon(ientry);
            }
        };
        this.fSingleWinIconValidator.setEnabled(false);
        this.fIcons.add(ientry);
        toolkit.paintBordersFor(comp);
        return comp;
    }

    private boolean validateSingleWinIcon(IconEntry ientry) {
        return EditorUtilities.imageEntryHasValidIco(this.fSingleWinIconValidator, ientry, this.getProduct());
    }

    private boolean validateMultipleWinIcon(IconEntry ientry, int index) {
        return EditorUtilities.imageEntryHasExactDepthAndSize(this.fMultipleWinIconValidator[index], ientry, this.getProduct(), F_WIN_ICON_DIMENSIONS[index][0], F_WIN_ICON_DIMENSIONS[index][1], F_WIN_ICON_DEPTHS[index]);
    }

    private void createLabel(Composite parent, FormToolkit toolkit, String text, int span) {
        Label label = toolkit.createLabel(parent, text, 64);
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            label.setLayoutData((Object)gd);
        } else if (layout instanceof TableWrapLayout) {
            TableWrapData td = new TableWrapData();
            td.colspan = span;
            label.setLayoutData((Object)td);
        }
    }

    private Composite addLinuxSection(Composite parent, FormToolkit toolkit) {
        Composite comp = this.createComposite(parent, toolkit);
        this.createLabel(comp, toolkit, PDEUIMessages.LauncherSection_linuxLabel, 3);
        this.fIcons.add(new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_icon, "linuxIcon"));
        toolkit.paintBordersFor(comp);
        return comp;
    }

    private Composite addSolarisSection(Composite parent, FormToolkit toolkit) {
        Composite comp = this.createComposite(parent, toolkit);
        this.createLabel(comp, toolkit, PDEUIMessages.LauncherSection_solarisLabel, 3);
        this.fIcons.add(new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_large, "solarisLarge"));
        this.fIcons.add(new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_medium, "solarisMedium"));
        this.fIcons.add(new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_small, "solarisSmall"));
        this.fIcons.add(new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_tiny, "solarisTiny"));
        toolkit.paintBordersFor(comp);
        return comp;
    }

    private Composite addMacSection(Composite parent, FormToolkit toolkit) {
        Composite comp = this.createComposite(parent, toolkit);
        this.createLabel(comp, toolkit, PDEUIMessages.LauncherSection_macLabel, 3);
        this.fIcons.add(new IconEntry(comp, toolkit, PDEUIMessages.LauncherSection_file, "macosxIcon"));
        toolkit.paintBordersFor(comp);
        return comp;
    }

    private Composite createComposite(Composite parent, FormToolkit toolkit) {
        Composite comp = toolkit.createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.rightMargin = 0;
        layout.leftMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        return comp;
    }

    public void refresh() {
        ILauncherInfo info = this.getLauncherInfo();
        this.fNameEntry.setValue(info.getLauncherName(), true);
        boolean useIco = info.usesWinIcoFile();
        this.fIcoButton.setSelection(useIco);
        this.fBmpButton.setSelection(!useIco);
        this.fSingleWinIconValidator.setRefresh(false);
        int i = 0;
        while (i < this.fIcons.size()) {
            IconEntry entry = (IconEntry)this.fIcons.get(i);
            entry.setValue(info.getIconPath(entry.getIconId()), true);
            ++i;
        }
        this.fSingleWinIconValidator.setRefresh(true);
        this.updateWinEntries(useIco);
        super.refresh();
    }

    private void updateWinEntries(boolean useIco) {
        int i = 0;
        while (i < this.fIcons.size()) {
            IconEntry entry = (IconEntry)this.fIcons.get(i);
            String id = entry.getIconId();
            if (id.equals("icoFile")) {
                boolean enabled = this.isEditable() && useIco;
                entry.setEditable(enabled);
            } else if (id.equals("winSmallHigh") || id.equals("winSmallLow") || id.equals("winMediumHigh") || id.equals("winMediumLow") || id.equals("winLargeHigh") || id.equals("winLargeLow") || id.equals("winExtraLargeHigh")) {
                entry.setEditable(this.isEditable() && !useIco);
            }
            ++i;
        }
        this.updateWinEntryValidators(useIco);
    }

    private void updateWinEntryValidators(boolean useIco) {
        this.fSingleWinIconValidator.setRefresh(false);
        this.fSingleWinIconValidator.setEnabled(this.isEditable() && useIco);
        int i = 0;
        while (i < this.fMultipleWinIconValidator.length) {
            this.fMultipleWinIconValidator[i].setEnabled(this.isEditable() && !useIco);
            ++i;
        }
        this.fSingleWinIconValidator.setRefresh(true);
    }

    private ILauncherInfo getLauncherInfo() {
        ILauncherInfo info = this.getProduct().getLauncherInfo();
        if (info == null) {
            info = this.getModel().getFactory().createLauncherInfo();
            this.getProduct().setLauncherInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void commit(boolean onSave) {
        this.fNameEntry.commit();
        int i = 0;
        while (i < this.fIcons.size()) {
            ((FormEntry)this.fIcons.get(i)).commit();
            ++i;
        }
        super.commit(onSave);
    }

    public void cancelEdit() {
        this.fNameEntry.cancelEdit();
        int i = 0;
        while (i < this.fIcons.size()) {
            ((FormEntry)this.fIcons.get(i)).commit();
            ++i;
        }
        super.cancelEdit();
    }

    private void handleBrowse(IconEntry entry) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getSection().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.LauncherSection_dialogTitle);
        String extension = this.getExtension(entry.getIconId());
        dialog.setMessage(PDEUIMessages.LauncherSection_dialogMessage);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter(extension));
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            entry.setValue(file.getFullPath().toString());
        }
    }

    private void openImage(String value) {
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        Path path = new Path(value);
        if (path.isEmpty()) {
            MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.WindowImagesSection_open, (String)PDEUIMessages.WindowImagesSection_emptyPath);
            return;
        }
        IResource resource = root.findMember((IPath)new Path(value));
        try {
            if (resource != null && resource instanceof IFile) {
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)((IFile)resource), (boolean)true);
            } else {
                MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.WindowImagesSection_open, (String)PDEUIMessages.WindowImagesSection_warning);
            }
        }
        catch (PartInitException partInitException) {}
    }

    private String getExtension(String iconId) {
        if (iconId.equals("linuxIcon")) {
            return "xpm";
        }
        if (iconId.equals("macosxIcon")) {
            return "icns";
        }
        if (iconId.equals("solarisLarge")) {
            return "l.pm";
        }
        if (iconId.equals("solarisMedium")) {
            return "m.pm";
        }
        if (iconId.equals("solarisSmall")) {
            return "s.pm";
        }
        if (iconId.equals("solarisTiny")) {
            return "t.pm";
        }
        if (iconId.equals("icoFile")) {
            return "ico";
        }
        return "bmp";
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        return d.getFocusControl() instanceof Text;
    }

    private void updateTabSelection() {
        int index = this.fTabFolder.getSelectionIndex();
        Control oldPage = this.fNotebookLayout.topControl;
        switch (index) {
            case 0: {
                this.fNotebookLayout.topControl = this.fLinuxSection;
                break;
            }
            case 1: {
                this.fNotebookLayout.topControl = this.fMacSection;
                break;
            }
            case 2: {
                this.fNotebookLayout.topControl = this.fSolarisSection;
                break;
            }
            case 3: {
                this.fNotebookLayout.topControl = this.fWin32Section;
            }
        }
        if (oldPage != this.fNotebookLayout.topControl) {
            this.fNotebook.layout();
        }
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
        this.getPage().setLastFocusControl((Control)this.fNameEntry.getText());
    }

    static /* synthetic */ void access$1(LauncherSection launcherSection, IconEntry iconEntry) {
        launcherSection.handleBrowse(iconEntry);
    }

    static /* synthetic */ void access$2(LauncherSection launcherSection, String string) {
        launcherSection.openImage(string);
    }

    class IconEntry
    extends FormEntry {
        String fIconId;

        public IconEntry(Composite parent, FormToolkit toolkit, String labelText, String iconId) {
            super(parent, toolkit, labelText, PDEUIMessages.LauncherSection_browse, LauncherSection.this.isEditable(), 20);
            this.fIconId = iconId;
            this.addEntryFormListener();
            this.setEditable(LauncherSection.this.isEditable());
        }

        private void addEntryFormListener() {
            IActionBars actionBars = LauncherSection.this.getPage().getPDEEditor().getEditorSite().getActionBars();
            this.setFormEntryListener(new FormEntryAdapter(this, LauncherSection.this, actionBars){
                final /* synthetic */ IconEntry this$1;
                {
                    this.this$1 = iconEntry;
                }

                public void textValueChanged(FormEntry entry) {
                    LauncherSection.access$0(IconEntry.access$0(this.this$1)).setIconPath(this.this$1.fIconId, entry.getValue());
                }

                public void browseButtonSelected(FormEntry entry) {
                    LauncherSection.access$1(IconEntry.access$0(this.this$1), (IconEntry)entry);
                }

                public void linkActivated(HyperlinkEvent e) {
                    LauncherSection.access$2(IconEntry.access$0(this.this$1), this.this$1.getValue());
                }
            });
        }

        public String getIconId() {
            return this.fIconId;
        }

        static /* synthetic */ LauncherSection access$0(IconEntry iconEntry) {
            return iconEntry.LauncherSection.this;
        }
    }
}

