/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.model.common.Activator;
import org.eclipse.stem.model.common.ModelProjectNature;
import org.eclipse.stem.model.common.ModelProjectUtils;
import org.eclipse.stem.ui.views.explorer.IdentifiableContentProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

final class ModelProjectBundleLoadHandler {
    private static final ModelProjectBundleLoadHandler INSTANCE = new ModelProjectBundleLoadHandler();
    private final List<IProject> changedProjects = Collections.synchronizedList(new ArrayList());
    private final List<IProject> managedBundleProjects = new CopyOnWriteArrayList<IProject>();
    private final List<Bundle> managedBundles = new CopyOnWriteArrayList<Bundle>();
    private BundleContext bundleContext;
    boolean DEBUG = true;
    private Set<String> changedPlugins = new CopyOnWriteArraySet<String>();
    private final IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if ((event.getType() == 2 || event.getType() == 4) && event.getResource() instanceof IProject) {
                ModelProjectBundleLoadHandler.this.handleStopProject((IProject)event.getResource());
            } else if (event.getType() == 1) {
                try {
                    if (event.getDelta() != null) {
                        event.getDelta().accept(new IResourceDeltaVisitor(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public boolean visit(IResourceDelta delta) throws CoreException {
                                if (delta.getResource() instanceof IProject) {
                                    IProject proj = (IProject)delta.getResource();
                                    List list = ModelProjectBundleLoadHandler.this.changedProjects;
                                    synchronized (list) {
                                        if (!ModelProjectBundleLoadHandler.this.changedProjects.contains(proj)) {
                                            ModelProjectBundleLoadHandler.this.changedProjects.add(proj);
                                        }
                                    }
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
            }
        }
    };
    private final IRegistryEventListener registryEventListener = new IRegistryEventListener(){

        public void removed(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void added(IExtension[] extensions) {
            ModelProjectBundleLoadHandler.this.handleExtensionsAdded(extensions);
        }
    };
    private final IJobChangeListener jobListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            Job job = event.getJob();
            if (job.getName().equals("Registry event dispatcher")) {
                ModelProjectBundleLoadHandler.this.resourceUpdateJob.schedule();
                return;
            }
            if (job.belongsTo(CorePlugin.FAMILY_STEM_SIMULATION)) {
                ModelProjectBundleLoadHandler.this.printDebug("[Job Done] STEM Simulation");
            }
            if (job.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD) || job.belongsTo(ResourcesPlugin.FAMILY_MANUAL_BUILD)) {
                ModelProjectBundleLoadHandler.this.printDebug("build completed, scheduling bundle update");
                ModelProjectBundleLoadHandler.this.bundleLoaderJob.schedule();
            }
        }
    };
    private final UIJob resourceUpdateJob = new UIJob("Resource update job"){

        public boolean belongsTo(Object family) {
            return super.belongsTo(family);
        }

        private void checkShouldUpdateResource(Resource r) {
            ClassLoader cl;
            if (r.getContents().isEmpty()) {
                return;
            }
            EObject obj = (EObject)r.getContents().get(0);
            if (obj != null && (cl = obj.getClass().getClassLoader()) instanceof BundleClassLoader) {
                Bundle br = ((BundleClassLoader)cl).getBundle();
                if (ModelProjectBundleLoadHandler.this.changedPlugins.contains(br.getSymbolicName())) {
                    try {
                        r.unload();
                        r.load(null);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ModelProjectBundleLoadHandler.this.printDebug("Resource reloaded:  " + r.getURI());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkResourceSet(ResourceSet rs) {
            ResourceSet resourceSet = rs;
            synchronized (resourceSet) {
                for (Resource r : rs.getResources()) {
                    this.checkShouldUpdateResource(r);
                }
            }
        }

        private List<ResourceSet> getEditorResourceSets() {
            ArrayList<ResourceSet> resourceSets = new ArrayList<ResourceSet>();
            IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                IEditorPart editor = ref.getEditor(false);
                if (editor instanceof IEditingDomainProvider) {
                    resourceSets.add(((IEditingDomainProvider)editor).getEditingDomain().getResourceSet());
                }
                ++n2;
            }
            return resourceSets;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!ModelProjectBundleLoadHandler.this.changedPlugins.isEmpty()) {
                this.checkResourceSet(Utility.resourceSet);
                for (ResourceSet rs : this.getEditorResourceSets()) {
                    this.checkResourceSet(rs);
                }
                ModelProjectBundleLoadHandler.this.changedPlugins.clear();
                Viewer viewer = IdentifiableContentProvider.getViewer();
                if (viewer != null && !viewer.getControl().isDisposed()) {
                    viewer.refresh();
                }
            }
            return Status.OK_STATUS;
        }
    };
    private final Job bundleLoaderJob = new Job("Bundle Loader Job"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Updating bundle packages", 4);
            ModelProjectBundleLoadHandler.this.printDebug("Starting bundle load job");
            try {
                ModelProjectBundleLoadHandler.this.printDebug("Waiting for build and simulation to complete...");
                5.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                5.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                5.getJobManager().join(CorePlugin.FAMILY_STEM_SIMULATION, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ModelProjectBundleLoadHandler.this.printDebug("Done waiting for simulation and build to complete...");
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            if (!monitor.isCanceled()) {
                List list = ModelProjectBundleLoadHandler.this.changedProjects;
                synchronized (list) {
                    for (IProject project : ModelProjectBundleLoadHandler.this.changedProjects) {
                        ModelProjectBundleLoadHandler.this.handleUpdatedProject(project);
                    }
                    ModelProjectBundleLoadHandler.this.changedProjects.clear();
                    monitor.worked(1);
                }
            }
            monitor.done();
            ModelProjectBundleLoadHandler.this.printDebug("Done updating bundles...");
            return Status.OK_STATUS;
        }
    };

    private ModelProjectBundleLoadHandler() {
    }

    static ModelProjectBundleLoadHandler getInstance() {
        return INSTANCE;
    }

    void start(BundleContext ctx) {
        this.bundleContext = ctx;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 31);
        Job.getJobManager().addJobChangeListener(this.jobListener);
        this.loadProjects();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener(this.registryEventListener);
    }

    void stop() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeListener(this.registryEventListener);
        Job.getJobManager().removeJobChangeListener(this.jobListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        this.shutdownProjects();
        this.bundleContext = null;
    }

    private void shutdownProjects() {
        for (IProject project : this.managedBundleProjects) {
            if (!ModelProjectUtils.isValidProject(project)) continue;
            this.handleStopProject(project);
        }
    }

    private void loadProjects() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = ws.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ModelProjectUtils.isValidProject(project)) {
                this.handleUpdatedProject(project);
            }
            ++n2;
        }
    }

    private void updateBuilders(IProject project) throws CoreException {
        ModelProjectNature.updateBuilders(project);
    }

    private void installAndStartProjectBundle(IProject project) {
        if (!ModelProjectUtils.isValidProject(project)) {
            return;
        }
        Bundle bundle = this.getBundleForProject(project);
        if (bundle != null) {
            this.updateBundle(bundle);
        } else {
            this.printDebug("Installing bundle for " + project.getFullPath().toString());
            Bundle newBundle = null;
            try {
                newBundle = this.bundleContext.installBundle(project.getLocationURI().toString());
                newBundle.start();
            }
            catch (BundleException be) {
                if (newBundle != null) {
                    this.stopAndUninstallBundle(newBundle);
                }
                Activator.log((IStatus)new Status(4, project.getName(), "Error installing project bundle into OSGi container", (Throwable)be));
            }
            this.printDebug("  ... bundle installed  " + project.getFullPath().toString());
            this.managedBundleProjects.add(project);
            this.managedBundles.add(newBundle);
        }
    }

    private void updateBundle(Bundle bundle) {
        try {
            this.printDebug("Updating bundle for " + bundle.getLocation());
            bundle.update();
            this.printDebug("  ... bundle updated for " + bundle.getLocation());
        }
        catch (BundleException be) {
            Activator.log((IStatus)new Status(4, bundle.getSymbolicName(), "Error updating the installed bundle.", (Throwable)be));
        }
    }

    private void stopAndUninstallBundle(Bundle bundle) {
        try {
            bundle.stop();
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
        try {
            bundle.uninstall();
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
    }

    private void handleUpdatedProject(IProject project) {
        if (!ModelProjectUtils.isValidProject(project)) {
            return;
        }
        try {
            this.updateBuilders(project);
            int severity = project.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
            if (severity >= 2) {
                project.build(10, "org.eclipse.stem.model.builder.MetamodelBuilder", Collections.emptyMap(), (IProgressMonitor)new NullProgressMonitor());
                Activator.log((IStatus)new Status(2, project.getName(), "Error building project, cannot install", null));
            } else {
                this.installAndStartProjectBundle(project);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    private void handleStopProject(IProject project) {
        if (!ModelProjectUtils.isValidProject(project)) {
            return;
        }
        Bundle bundle = this.getBundleForProject(project);
        if (bundle != null) {
            this.managedBundleProjects.remove(project);
            this.managedBundles.remove(bundle);
            this.printDebug("Uninstalling bundle for " + project.getFullPath().toString());
            this.stopAndUninstallBundle(bundle);
            this.printDebug("  ... bundle uninstalled for " + project.getFullPath().toString());
        }
    }

    private Bundle getBundleForProject(IProject project) {
        Bundle b = Platform.getBundle((String)project.getName());
        if (b != null) {
            this.printDebug("Bundle location:" + b.getLocation());
            this.printDebug("Project location:" + project.getLocation().toString());
            return b;
        }
        return null;
    }

    private void handleExtensionsAdded(IExtension[] added) {
        IExtension[] iExtensionArray = added;
        int n = added.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.changedPlugins.add(extension.getContributor().getName());
            ++n2;
        }
    }

    private void printDebug(String s) {
        if (this.DEBUG) {
            System.out.println(s);
        }
    }
}

